package dev.overgrown.aspectslib.entity.aura_node.client;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.class_1657;

public class AuraNodeVisibilityConfig {
    private static final List<BiPredicate<class_1657, Boolean>> visibilityConditions = new ArrayList<>();
    private static boolean alwaysShow = false;

    public static void addVisibilityCondition(BiPredicate<class_1657, Boolean> condition) {
        visibilityConditions.add(condition);
    }

    public static void setAlwaysShow(boolean alwaysShow) {
        AuraNodeVisibilityConfig.alwaysShow = alwaysShow;
    }

    public static boolean shouldShowNode(@Nullable class_1657 player, boolean hasAspects) {
        if (player == null) return false;

        // If alwaysShow is true, show regardless of conditions
        if (alwaysShow) return true;

        // If no conditions are set, use default behavior (low transparency)
        if (visibilityConditions.isEmpty()) return false;

        // Check if any condition matches
        return visibilityConditions.stream().anyMatch(condition -> condition.test(player, hasAspects));
    }
}