package dev.overgrown.aspectslib.entity.aura_node.render;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.entity.aura_node.client.AuraNodeVisibilityConfig;
import dev.overgrown.aspectslib.entity.aura_node.AuraNodeEntity;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_765;
import net.minecraft.class_897;
import net.minecraft.client.render.*;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class AuraNodeRenderer extends class_897<AuraNodeEntity> {

    private static final float SCALE = 1.0F;
    private static final float DEFAULT_ALPHA = 0.2f; // 20% opacity by default
    private static final float VISIBLE_ALPHA = 1.0f; // 100% opacity when visible

    public AuraNodeRenderer(class_5617.class_5618 ctx) {
        super(ctx);
    }

    @Override
    public class_2960 getTexture(AuraNodeEntity entity) {
        // Return different texture based on node type
        return AspectsLib.identifier("textures/entity/aura_node/" +
                entity.getNodeType().name().toLowerCase() + ".png");
    }

    @Override
    public void render(AuraNodeEntity node, float yaw, float partialTick,
                       class_4587 pose, class_4597 bufferSource, int light) {
        super.method_3936(node, yaw, partialTick, pose, bufferSource, light);

        class_310 mc = class_310.method_1551();
        class_4184 camera = mc.field_1773.method_19418();

        // Check if it should show the node with full clarity
        boolean shouldShow = AuraNodeVisibilityConfig.shouldShowNode(mc.field_1724, !node.getAspects().isEmpty());

        // Calculate alpha based on visibility condition
        float alpha = shouldShow ? VISIBLE_ALPHA : DEFAULT_ALPHA;

        // Don't render if completely transparent
        if (alpha <= 0.0f) {
            return;
        }

        pose.method_22903();
        pose.method_22907(camera.method_23767());

        class_4588 buffer = bufferSource.getBuffer(class_1921.method_23580(getTexture(node)));

        int argb = node.getRenderColour();
        int baseAlpha = (argb >> 24) & 0xFF;
        int red = (argb >> 16) & 0xFF;
        int green = (argb >> 8) & 0xFF;
        int blue = argb & 0xFF;

        // Apply calculated alpha to the base color
        int finalAlpha = (int)(baseAlpha * alpha);
        if (finalAlpha <= 0) return; // Don't render if completely transparent

        Matrix4f pm = pose.method_23760().method_23761();
        Matrix3f nm = pose.method_23760().method_23762();

        vertex(buffer, pm, nm, 0.0F, 0, 0, 1, red, green, blue, finalAlpha);
        vertex(buffer, pm, nm, 1.0F, 0, 1, 1, red, green, blue, finalAlpha);
        vertex(buffer, pm, nm, 1.0F, 1, 1, 0, red, green, blue, finalAlpha);
        vertex(buffer, pm, nm, 0.0F, 1, 0, 0, red, green, blue, finalAlpha);

        pose.method_22909();
    }

    private static void vertex(class_4588 buffer, Matrix4f positionMatrix, Matrix3f normalMatrix, float x, int y, int u, int v, int r, int g, int b, int a) {
        buffer.method_22918(positionMatrix, x - 0.5F, y - 0.25F, 0.0F)
                .method_1336(r, g, b, a)
                .method_22913(u, v)
                .method_22922(class_4608.field_21444)
                .method_22916(class_765.field_32769)
                .method_23763(normalMatrix, 0.0F, 1.0F, 0.0F)
                .method_1344();
    }
}