package dev.overgrown.aspectslib.entity.aura_node.world;

import dev.overgrown.aspectslib.entity.aura_node.AuraNodeEntity;
import dev.overgrown.aspectslib.registry.ModEntities;
import net.minecraft.class_1923;
import net.minecraft.class_1948;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_5819;

public class AuraNodeSpawner {
    public static void spawnNodes(class_3218 world, boolean spawnMonsters, boolean spawnAnimals) {
        if (!spawnMonsters) return;

        class_5819 random = world.method_8409();
        class_1923 spawnChunk = new class_1923(world.method_43126());

        for (int i = 0; i < 3; i++) { // Try 3 times per chunk
            // Calculate random position near spawn
            int chunkXOffset = random.method_43048(32) - 16;
            int chunkZOffset = random.method_43048(32) - 16;
            int startX = (spawnChunk.field_9181 + chunkXOffset) * 16;
            int startZ = (spawnChunk.field_9180 + chunkZOffset) * 16;

            class_2338 pos = new class_2338(
                    random.method_43048(16) + startX,
                    world.method_8615() + random.method_43048(64),
                    random.method_43048(16) + startZ
            );

            // Check if position is valid for spawning
            class_2680 blockState = world.method_8320(pos);
            class_3610 fluidState = world.method_8316(pos);
            if (!class_1948.method_8662(world, pos, blockState, fluidState, ModEntities.AURA_NODE)) continue;

            // Determine node type
            AuraNodeEntity.NodeType nodeType;
            float roll = random.method_43057();
            if (roll < 0.0056f) { // 0.56%
                nodeType = AuraNodeEntity.NodeType.HUNGRY;
            } else if (roll < 0.0056f + 0.0167f) { // 0.56% + 1.67% = 2.23%
                nodeType = AuraNodeEntity.NodeType.PURE;
            } else if (roll < 0.0056f + 0.0167f + 0.0167f) { // 2.23% + 1.67% = 3.9%
                nodeType = AuraNodeEntity.NodeType.SINISTER;
            } else if (roll < 0.0056f + 0.0167f + 0.0167f + 0.0167f) { // 3.9% + 1.67% = 5.57%
                nodeType = AuraNodeEntity.NodeType.UNSTABLE;
            } else {
                nodeType = random.method_43057() < 0.8f ?
                        AuraNodeEntity.NodeType.NORMAL :
                        AuraNodeEntity.NodeType.UNSTABLE;
            }

            // Create and spawn node
            AuraNodeEntity node = new AuraNodeEntity(ModEntities.AURA_NODE, world);
            node.method_5814(pos.method_10263() + 0.5, pos.method_10264(), pos.method_10260() + 0.5);
            node.setNodeType(nodeType);
            node.initializeAspects(random);

            world.method_8649(node);
        }
    }
}