package dev.overgrown.aspectslib.mixin;

import dev.overgrown.aspectslib.api.IAspectAffinityEntity;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.EntityAspectRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements IAspectAffinityEntity {

    @Unique
    private AspectData aspectslib$originalAspectData = AspectData.DEFAULT;

    @Unique
    @Override
    public AspectData aspectslib$getOriginalAspectData() {
        return this.aspectslib$originalAspectData;
    }

    @Unique
    @Override
    public void aspectslib$setOriginalAspectData(AspectData data) {
        this.aspectslib$originalAspectData = data;
    }

    @Unique
    private static final class_2940<class_2487> ASPECTS_DATA = class_2945.method_12791(LivingEntityMixin.class, class_2943.field_13318);

    @Unique
    private AspectData aspectslib$aspectData = AspectData.DEFAULT;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "<init>", at = @At("TAIL"))
    private void onEntityInit(class_1299<? extends class_1309> entityType, class_1937 world, CallbackInfo ci) {
        // Initialize from registry only on server
        if (!world.field_9236) {
            class_2960 entityId = class_1299.method_5890(entityType);
            AspectData data = EntityAspectRegistry.get(entityId);
            if (data != null) {
                this.aspectslib$setAspectData(data);
            }
        }
    }
    
    @Inject(method = "writeCustomDataToNbt", at = @At("TAIL"))
    public void aspects_writeOriginalDataToNbt(class_2487 nbt, CallbackInfo ci) {
        if (!this.aspectslib$originalAspectData.isEmpty()) {
            nbt.method_10566("AspectsLibOriginalData", this.aspectslib$originalAspectData.toNbt());
        }
    }

    @Inject(method = "readCustomDataFromNbt", at = @At("TAIL"))
    public void aspects_readOriginalDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("AspectsLibOriginalData", class_2520.field_33260)) {
            this.aspectslib$originalAspectData = AspectData.fromNbt(nbt.method_10562("AspectsLibOriginalData"));
        }
    }

    @Inject(method = "initDataTracker", at = @At("TAIL"))
    private void aspects_initDataTracker(CallbackInfo ci) {
        this.field_6011.method_12784(ASPECTS_DATA, new class_2487());
    }

    @Inject(method = "onTrackedDataSet", at = @At("TAIL"))
    private void aspects_onTrackedDataSet(class_2940<?> data, CallbackInfo ci) {
        if (ASPECTS_DATA.equals(data) && this.method_37908().field_9236) {
            class_2487 nbt = this.field_6011.method_12789(ASPECTS_DATA);
            this.aspectslib$aspectData = AspectData.fromNbt(nbt);
        }
    }

    @Inject(method = "writeCustomDataToNbt", at = @At("TAIL"))
    public void aspects_writeCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        if (!this.aspectslib$getAspectData().isEmpty()) {
            nbt.method_10566("AspectsLibData", this.aspectslib$getAspectData().toNbt());
        }
    }

    @Inject(method = "readCustomDataFromNbt", at = @At("TAIL"))
    public void aspects_readCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("AspectsLibData", class_2520.field_33260)) {
            this.aspectslib$setAspectData(AspectData.fromNbt(nbt.method_10562("AspectsLibData")));
        }
    }

    @Override
    public AspectData aspectslib$getAspectData() {
        return this.aspectslib$aspectData;
    }

    @Override
    public void aspectslib$setAspectData(AspectData data) {
        this.aspectslib$aspectData = data;
        if (!this.method_37908().field_9236) {
            this.field_6011.method_12778(ASPECTS_DATA, data.toNbt());
        }
    }
}