package dev.overgrown.aspectslib.mixin.client;

import dev.overgrown.aspectslib.api.IAspectDataProvider;
import dev.overgrown.aspectslib.client.AspectsTooltipConfig;
import dev.overgrown.aspectslib.client.tooltip.AspectTooltipComponent;
import dev.overgrown.aspectslib.client.tooltip.AspectTooltipData;
import dev.overgrown.aspectslib.data.AspectData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_5632;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;

/**
 * Client-side mixin to provide aspect tooltip data.
 * <p>
 * Responsibilities:
 * <ol type="1">
 * <li>Attach AspectTooltipData to items with aspects</li>
 * </ol>
 * <p>
 * Important Connections:
 * <li>{@link IAspectDataProvider}: Source of aspect data</li>
 * <li>{@link AspectTooltipComponent}: Renders the tooltip</li>
 */
@Environment(EnvType.CLIENT)
@Mixin(class_1799.class)
public abstract class ItemStackClientMixin {

    @Inject(method = "getTooltipData", at = @At("HEAD"), cancellable = true)
    private void addAspectTooltipData(CallbackInfoReturnable<Optional<class_5632>> cir) {
        IAspectDataProvider provider = (IAspectDataProvider) this;
        AspectData aspectData = provider.aspectslib$getAspectData();

        if (aspectData == null || aspectData.isEmpty()) {
            return;
        }

        // Check if we should show aspects based on conditions
        class_310 client = class_310.method_1551();
        class_1657 player = client.field_1724;

        if (!AspectsTooltipConfig.shouldShowTooltip((class_1799)(Object)this, player)) {
            return;
        }

        cir.setReturnValue(Optional.of(new AspectTooltipData(aspectData)));
    }
}