package dev.overgrown.aspectslib.registry;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.item.AspectShardItem;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import java.util.LinkedHashMap;
import java.util.Map;

public class ModItems {
    private static final Map<String, class_1792> ASPECT_SHARDS = new LinkedHashMap<>();
    public static final class_5321<class_1761> ASPECT_SHARDS_GROUP =
            class_5321.method_29179(class_7924.field_44688, AspectsLib.identifier("aspect_shards"));

    public static void initialize() {
        registerAspectShards();
        registerItemGroup();
    }

    private static void registerAspectShards() {
        registerShard("aer");
        registerShard("aqua");
        registerShard("ignis");
        registerShard("ordo");
        registerShard("perditio");
        registerShard("terra");
        registerShard("gelum");
        registerShard("lux");
        registerShard("metallum");
        registerShard("mortuus");
        registerShard("motus");
        registerShard("permutatio");
        registerShard("potentia");
        registerShard("vacuos");
        registerShard("victus");
        registerShard("vitreus");
        registerShard("bestia");
        registerShard("exanimis");
        registerShard("herba");
        registerShard("instrumentum");
        registerShard("praecantatio");
        registerShard("spiritus");
        registerShard("tenebrae");
        registerShard("vinculum");
        registerShard("volatus");
        registerShard("alienis");
        registerShard("alkimia");
        registerShard("auram");
        registerShard("aversio");
        registerShard("cognitio");
        registerShard("desiderium");
        registerShard("fabrico");
        registerShard("humanus");
        registerShard("machina");
        registerShard("praemunio");
        registerShard("sensus");
        registerShard("vitium");
        registerShard("fames");
    }

    private static void registerShard(String aspectName) {
        class_2960 id = AspectsLib.identifier(aspectName + "_aspect_shard");
        class_1792 item = new AspectShardItem(aspectName, new FabricItemSettings().method_7889(64));
        class_2378.method_10230(class_7923.field_41178, id, item);
        ASPECT_SHARDS.put(aspectName, item);
        AspectsLib.LOGGER.info("Registered aspect shard: {}", id);
    }

    private static void registerItemGroup() {
        class_1761 group = FabricItemGroup.builder()
                .method_47321(class_2561.method_43471("itemGroup.aspectslib.aspect_shards"))
                .method_47320(() -> new class_1799(ASPECT_SHARDS.get("aer")))
                .method_47317((displayContext, entries) -> {
                    for (class_1792 item : ASPECT_SHARDS.values()) {
                        entries.method_45421(item);
                    }
                })
                .method_47324();

        class_2378.method_39197(class_7923.field_44687, ASPECT_SHARDS_GROUP, group);
        AspectsLib.LOGGER.info("Registered item group: {}", ASPECT_SHARDS_GROUP.method_29177());
    }

    public static class_1792 getAspectShard(String aspectName) {
        return ASPECT_SHARDS.get(aspectName);
    }
}