/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib;

import com.google.gson.Gson;
import com.mojang.brigadier.CommandDispatcher;
import dev.overgrown.aspectslib.aether.AetherEvents;
import dev.overgrown.aspectslib.aether.AetherManager;
import dev.overgrown.aspectslib.command.AspectDebugCommand;
import dev.overgrown.aspectslib.command.CorruptionCommand;
import dev.overgrown.aspectslib.command.RecipeAspectCommand;
import dev.overgrown.aspectslib.command.TagDumpCommand;
import dev.overgrown.aspectslib.corruption.CorruptionManager;
import dev.overgrown.aspectslib.data.AspectManager;
import dev.overgrown.aspectslib.data.UniversalAspectManager;
import dev.overgrown.aspectslib.networking.SyncAspectIdentifierPacket;
import dev.overgrown.aspectslib.recipe.RecipeAspectManager;
import dev.overgrown.aspectslib.registry.ModEntities;
import dev.overgrown.aspectslib.registry.ModItems;
import dev.overgrown.aspectslib.resonance.ResonanceManager;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectsLib
implements ModInitializer {
    public static final String MOD_ID = "aspectslib";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"aspectslib");
    public static final Gson GSON = new Gson();

    public static class_2960 identifier(String path) {
        return new class_2960(MOD_ID, path);
    }

    public void onInitialize() {
        ModItems.initialize();
        ModEntities.register();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            AspectDebugCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            RecipeAspectCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
            TagDumpCommand.register((CommandDispatcher<class_2168>)dispatcher);
            CorruptionCommand.register((CommandDispatcher<class_2168>)dispatcher, registryAccess);
        });
        ServerLifecycleEvents.SYNC_DATA_PACK_CONTENTS.register((player, joined) -> {
            try {
                SyncAspectIdentifierPacket.sendAllData(player);
                LOGGER.debug("Sent aspect data to player: {}", (Object)player.method_5477().getString());
            }
            catch (Exception e) {
                LOGGER.error("Failed to send aspect data to player {}: {}", (Object)player.method_5477().getString(), (Object)e.getMessage());
            }
        });
        AspectManager aspectManager = new AspectManager();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)aspectManager);
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new UniversalAspectManager());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new ResonanceManager());
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new AetherManager());
        AetherEvents.initialize();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new RecipeAspectManager());
        RecipeAspectManager.initialize();
        CorruptionManager.initialize();
        LOGGER.info("AspectsLib initialized!");
    }
}

