/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.aether;

import dev.overgrown.aspectslib.aether.AetherManager;
import dev.overgrown.aspectslib.aether.DeadZoneData;
import dev.overgrown.aspectslib.corruption.CorruptionManager;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class AetherChunkData {
    private class_1937 world;
    private final class_1923 chunkPos;
    private final Map<class_2960, Integer> currentAether;
    private final Map<class_2960, Integer> maxAether;
    private long lastRecoveryTime;
    private double totalExpendedThisHour;
    private long hourStartTime;
    private boolean initialized = false;

    public AetherChunkData(class_1937 world, class_1923 chunkPos) {
        this.world = world;
        this.chunkPos = chunkPos;
        this.currentAether = new HashMap<class_2960, Integer>();
        this.maxAether = new HashMap<class_2960, Integer>();
        this.lastRecoveryTime = world.method_8510();
        this.hourStartTime = world.method_8510();
        this.totalExpendedThisHour = 0.0;
        this.initializeFromBiome();
    }

    private AetherChunkData(class_1937 world, class_1923 chunkPos, Map<class_2960, Integer> currentAether, Map<class_2960, Integer> maxAether, long lastRecoveryTime, double totalExpendedThisHour, long hourStartTime) {
        this.world = world;
        this.chunkPos = chunkPos;
        this.currentAether = currentAether;
        this.maxAether = maxAether;
        this.lastRecoveryTime = lastRecoveryTime;
        this.totalExpendedThisHour = totalExpendedThisHour;
        this.hourStartTime = hourStartTime;
        this.initialized = true;
    }

    protected void setWorld(@NotNull class_1937 world) {
        this.world = world;
    }

    private void initializeFromBiome() {
        if (this.initialized) {
            return;
        }
        int[] sampleX = new int[]{this.chunkPos.method_8326() + 4, this.chunkPos.method_8326() + 8, this.chunkPos.method_8326() + 12};
        int[] sampleZ = new int[]{this.chunkPos.method_8328() + 4, this.chunkPos.method_8328() + 8, this.chunkPos.method_8328() + 12};
        HashMap biomeAspectTotals = new HashMap();
        int sampleCount = 0;
        for (int x : sampleX) {
            for (int z : sampleZ) {
                class_2338 samplePos = new class_2338(x, 64, z);
                class_6880 biomeEntry = this.world.method_23753(samplePos);
                biomeEntry.method_40230().ifPresent(biomeKey -> {
                    AspectData biomeAspects = BiomeAspectRegistry.get((class_5321<class_1959>)biomeKey);
                    if (!biomeAspects.isEmpty()) {
                        for (Map.Entry entry : biomeAspects.getMap().entrySet()) {
                            biomeAspectTotals.merge((class_2960)entry.getKey(), (Integer)entry.getValue(), Integer::sum);
                        }
                    }
                });
                ++sampleCount;
            }
        }
        Object object = biomeAspectTotals.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            int averageDensity = (Integer)entry.getValue() / sampleCount;
            int capacity = averageDensity * 16 * 16 * 256;
            this.maxAether.put((class_2960)entry.getKey(), capacity);
            this.currentAether.put((class_2960)entry.getKey(), capacity);
        }
        this.initialized = true;
    }

    public boolean canHarvest(class_2960 aspectId, int amount) {
        if (AetherManager.isDeadZone(this.world, this.chunkPos)) {
            return false;
        }
        Integer current = this.currentAether.get(aspectId);
        return current != null && current >= amount;
    }

    public boolean harvestAether(class_2960 aspectId, int amount) {
        if (!this.canHarvest(aspectId, amount)) {
            return false;
        }
        Integer current = this.currentAether.get(aspectId);
        if (current != null) {
            this.currentAether.put(aspectId, current - amount);
            this.totalExpendedThisHour += (double)amount;
            this.checkForDeadZone();
            return true;
        }
        return false;
    }

    private void checkForDeadZone() {
        long currentTime = this.world.method_8510();
        if (currentTime - this.hourStartTime > 72000L) {
            this.totalExpendedThisHour = 0.0;
            this.hourStartTime = currentTime;
        }
        if (this.totalExpendedThisHour > (double)AetherManager.getPermanentDeadZoneThreshold(this.world)) {
            AetherManager.markAsDeadZone(this.world, this.chunkPos, new DeadZoneData(true, this.world.method_8510()));
            return;
        }
        boolean severelyDepleted = true;
        for (Map.Entry<class_2960, Integer> entry : this.currentAether.entrySet()) {
            int max = this.maxAether.getOrDefault(entry.getKey(), 0);
            if (max <= 0 || !((double)entry.getValue().intValue() > (double)max * 0.1)) continue;
            severelyDepleted = false;
            break;
        }
        if (severelyDepleted) {
            AetherManager.markAsDeadZone(this.world, this.chunkPos, new DeadZoneData(false, this.world.method_8510()));
        }
    }

    public void recoverAether() {
        if (this.world == null) {
            return;
        }
        if (AetherManager.isDeadZone(this.world, this.chunkPos)) {
            this.recoverDeadZone();
            return;
        }
        long currentTime = this.world.method_8510();
        long timeSinceLastRecovery = currentTime - this.lastRecoveryTime;
        double recoveryRate = AetherManager.getRecoveryRate(this.world);
        if (timeSinceLastRecovery >= 24000L) {
            int recoveryCycles = (int)(timeSinceLastRecovery / 24000L);
            for (Map.Entry<class_2960, Integer> entry : this.maxAether.entrySet()) {
                class_2960 aspectId = entry.getKey();
                int max = entry.getValue();
                int current = this.currentAether.getOrDefault(aspectId, 0);
                if (current >= max) continue;
                int recoveryAmount = (int)(recoveryRate * (double)recoveryCycles);
                this.currentAether.put(aspectId, Math.min(max, current + recoveryAmount));
            }
            this.lastRecoveryTime = currentTime - timeSinceLastRecovery % 24000L;
        }
    }

    private void recoverDeadZone() {
        DeadZoneData deadZoneData = AetherManager.getDeadZoneData(this.world, this.chunkPos);
        if (deadZoneData == null || deadZoneData.isPermanent()) {
            return;
        }
        long currentTime = this.world.method_8510();
        long timeSinceLastRecovery = currentTime - this.lastRecoveryTime;
        if (timeSinceLastRecovery >= 24000L) {
            int recoveryCycles = (int)(timeSinceLastRecovery / 24000L);
            double recoveryAmount = AetherManager.getRecoveryRate(this.world) * (double)recoveryCycles;
            boolean sufficientlyRecovered = true;
            for (Map.Entry<class_2960, Integer> entry : this.maxAether.entrySet()) {
                class_2960 aspectId = entry.getKey();
                int max = entry.getValue();
                int current = this.currentAether.getOrDefault(aspectId, 0);
                if (current >= max) continue;
                int newAmount = Math.min(max, current + (int)recoveryAmount);
                this.currentAether.put(aspectId, newAmount);
                if (!((double)newAmount < (double)max * AetherManager.getTemporaryDeadZoneRecoveryThreshold(this.world))) continue;
                sufficientlyRecovered = false;
            }
            this.lastRecoveryTime = currentTime - timeSinceLastRecovery % 24000L;
            if (sufficientlyRecovered) {
                AetherManager.removeDeadZone(this.world, this.chunkPos);
            }
        }
    }

    public int getCurrentAether(class_2960 aspectId) {
        return this.currentAether.getOrDefault(aspectId, 0);
    }

    public int getMaxAether(class_2960 aspectId) {
        return this.maxAether.getOrDefault(aspectId, 0);
    }

    public double getAetherPercentage(class_2960 aspectId) {
        int max = this.getMaxAether(aspectId);
        if (max == 0) {
            return 0.0;
        }
        return (double)this.getCurrentAether(aspectId) / (double)max;
    }

    public Set<class_2960> getAspectIds() {
        return Collections.unmodifiableSet(this.currentAether.keySet());
    }

    public boolean canHarvestVitium() {
        if (AetherManager.isDeadZone(this.world, this.chunkPos)) {
            return false;
        }
        return this.getCurrentAether(CorruptionManager.VITIUM_ID) > 0;
    }

    public boolean harvestVitium(int amount) {
        return this.harvestAether(CorruptionManager.VITIUM_ID, amount);
    }

    public boolean isEmpty() {
        return this.currentAether.isEmpty() && this.maxAether.isEmpty();
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        class_2499 currentList = new class_2499();
        for (Map.Entry<class_2960, Integer> entry : this.currentAether.entrySet()) {
            class_2487 aspectNbt = new class_2487();
            aspectNbt.method_10582("Aspect", entry.getKey().toString());
            aspectNbt.method_10569("Amount", entry.getValue().intValue());
            currentList.add((Object)aspectNbt);
        }
        nbt.method_10566("CurrentAether", (class_2520)currentList);
        class_2499 maxList = new class_2499();
        for (Map.Entry<class_2960, Integer> entry : this.maxAether.entrySet()) {
            class_2487 aspectNbt = new class_2487();
            aspectNbt.method_10582("Aspect", entry.getKey().toString());
            aspectNbt.method_10569("Amount", entry.getValue().intValue());
            maxList.add((Object)aspectNbt);
        }
        nbt.method_10566("MaxAether", (class_2520)maxList);
        nbt.method_10544("LastRecoveryTime", this.lastRecoveryTime);
        nbt.method_10549("TotalExpendedThisHour", this.totalExpendedThisHour);
        nbt.method_10544("HourStartTime", this.hourStartTime);
        nbt.method_10556("Initialized", this.initialized);
        return nbt;
    }

    public static AetherChunkData fromNbt(class_2487 nbt) {
        int amount;
        class_2960 aspectId;
        class_2487 aspectNbt;
        int i;
        HashMap<class_2960, Integer> currentAether = new HashMap<class_2960, Integer>();
        HashMap<class_2960, Integer> maxAether = new HashMap<class_2960, Integer>();
        if (nbt.method_10573("CurrentAether", 9)) {
            class_2499 currentList = nbt.method_10554("CurrentAether", 10);
            for (i = 0; i < currentList.size(); ++i) {
                aspectNbt = currentList.method_10602(i);
                aspectId = new class_2960(aspectNbt.method_10558("Aspect"));
                amount = aspectNbt.method_10550("Amount");
                currentAether.put(aspectId, amount);
            }
        }
        if (nbt.method_10573("MaxAether", 9)) {
            class_2499 maxList = nbt.method_10554("MaxAether", 10);
            for (i = 0; i < maxList.size(); ++i) {
                aspectNbt = maxList.method_10602(i);
                aspectId = new class_2960(aspectNbt.method_10558("Aspect"));
                amount = aspectNbt.method_10550("Amount");
                maxAether.put(aspectId, amount);
            }
        }
        return new AetherChunkData(null, new class_1923(0, 0), currentAether, maxAether, nbt.method_10537("LastRecoveryTime"), nbt.method_10574("TotalExpendedThisHour"), nbt.method_10537("HourStartTime"));
    }
}

