/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.aether;

import com.google.gson.JsonElement;
import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.aether.AetherChunkData;
import dev.overgrown.aspectslib.aether.AetherWorldState;
import dev.overgrown.aspectslib.aether.DeadZoneData;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_26;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.server.MinecraftServer;

public class AetherManager
extends class_4309
implements IdentifiableResourceReloadListener {
    private static final Map<class_2960, AetherConfig> DIMENSION_CONFIGS = new ConcurrentHashMap<class_2960, AetherConfig>();
    private static final Map<class_1923, AetherChunkData> CHUNK_CACHE = new ConcurrentHashMap<class_1923, AetherChunkData>();
    private static MinecraftServer server;

    public AetherManager() {
        super(AspectsLib.GSON, "aether_config");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        DIMENSION_CONFIGS.clear();
        CHUNK_CACHE.clear();
        prepared.forEach((id, json) -> {
            try {
                AetherConfig config = (AetherConfig)AspectsLib.GSON.fromJson(json, AetherConfig.class);
                DIMENSION_CONFIGS.put((class_2960)id, config);
                AspectsLib.LOGGER.debug("Loaded Aether config for dimension: {}", id);
            }
            catch (Exception e) {
                AspectsLib.LOGGER.error("Failed to load Aether config {}: {}", id, (Object)e.getMessage());
            }
        });
        AspectsLib.LOGGER.info("Loaded {} Aether dimension configurations", (Object)DIMENSION_CONFIGS.size());
    }

    public static void setServer(MinecraftServer server) {
        AetherManager.server = server;
    }

    public static AetherChunkData getAetherData(class_1937 world, class_1923 chunkPos) {
        if (world.method_8608()) {
            return CHUNK_CACHE.computeIfAbsent(chunkPos, pos -> new AetherChunkData(world, (class_1923)pos));
        }
        class_3218 serverWorld = (class_3218)world;
        AetherWorldState worldState = AetherManager.getWorldState(serverWorld);
        return worldState.getOrCreateChunkData(chunkPos, world);
    }

    public static void markAsDeadZone(class_1937 world, class_1923 chunkPos, DeadZoneData data) {
        if (world.method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        AetherWorldState worldState = AetherManager.getWorldState(serverWorld);
        worldState.markAsDeadZone(chunkPos, data);
        CHUNK_CACHE.remove(chunkPos);
    }

    public static void removeDeadZone(class_1937 world, class_1923 chunkPos) {
        if (world.method_8608()) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        AetherWorldState worldState = AetherManager.getWorldState(serverWorld);
        worldState.removeDeadZone(chunkPos);
    }

    public static boolean isDeadZone(class_1937 world, class_1923 chunkPos) {
        if (world.method_8608()) {
            return false;
        }
        class_3218 serverWorld = (class_3218)world;
        AetherWorldState worldState = AetherManager.getWorldState(serverWorld);
        return worldState.isDeadZone(chunkPos);
    }

    public static DeadZoneData getDeadZoneData(class_1937 world, class_1923 chunkPos) {
        if (world.method_8608()) {
            return null;
        }
        class_3218 serverWorld = (class_3218)world;
        AetherWorldState worldState = AetherManager.getWorldState(serverWorld);
        return worldState.getDeadZoneData(chunkPos);
    }

    private static AetherWorldState getWorldState(class_3218 world) {
        class_26 persistentStateManager = world.method_17983();
        return (AetherWorldState)persistentStateManager.method_17924(AetherWorldState::fromNbt, AetherWorldState::new, "aspectslib_aether");
    }

    public static Collection<AetherChunkData> getAllChunkData(class_1937 world) {
        if (world.method_8608()) {
            return CHUNK_CACHE.values();
        }
        class_3218 serverWorld = (class_3218)world;
        AetherWorldState worldState = AetherManager.getWorldState(serverWorld);
        return worldState.getAllChunkData();
    }

    public static void saveAllData() {
        if (server != null) {
            for (class_3218 world : server.method_3738()) {
                AetherWorldState worldState = AetherManager.getWorldState(world);
                worldState.method_80();
            }
        }
    }

    public static double getRecoveryRate(class_1937 world) {
        class_2960 dimensionId = world.method_27983().method_29177();
        AetherConfig config = DIMENSION_CONFIGS.get(dimensionId);
        return config != null ? config.recoveryRate : 1.0;
    }

    public static int getPermanentDeadZoneThreshold(class_1937 world) {
        class_2960 dimensionId = world.method_27983().method_29177();
        AetherConfig config = DIMENSION_CONFIGS.get(dimensionId);
        return config != null ? config.permanentDeadZoneThreshold : 10000;
    }

    public static double getTemporaryDeadZoneRecoveryThreshold(class_1937 world) {
        class_2960 dimensionId = world.method_27983().method_29177();
        AetherConfig config = DIMENSION_CONFIGS.get(dimensionId);
        return config != null ? config.temporaryDeadZoneRecoveryThreshold : 0.1;
    }

    public static int getChunkVolume(class_1937 world) {
        class_2960 dimensionId = world.method_27983().method_29177();
        AetherConfig config = DIMENSION_CONFIGS.get(dimensionId);
        return config != null ? config.chunkVolume : 65536;
    }

    public static AetherConfig getDimensionConfig(class_2960 dimensionId) {
        return DIMENSION_CONFIGS.get(dimensionId);
    }

    public static boolean hasDimensionConfig(class_2960 dimensionId) {
        return DIMENSION_CONFIGS.containsKey(dimensionId);
    }

    public static Map<class_2960, AetherConfig> getAllDimensionConfigs() {
        return new ConcurrentHashMap<class_2960, AetherConfig>(DIMENSION_CONFIGS);
    }

    public class_2960 getFabricId() {
        return AspectsLib.identifier("aether");
    }

    public static class AetherConfig {
        public double recoveryRate = 1.0;
        public int permanentDeadZoneThreshold = 10000;
        public double temporaryDeadZoneRecoveryThreshold = 0.1;
        public int chunkVolume = 65536;

        public AetherConfig() {
        }

        public AetherConfig(double recoveryRate, int permanentDeadZoneThreshold, double temporaryDeadZoneRecoveryThreshold, int chunkVolume) {
            this.recoveryRate = recoveryRate;
            this.permanentDeadZoneThreshold = permanentDeadZoneThreshold;
            this.temporaryDeadZoneRecoveryThreshold = temporaryDeadZoneRecoveryThreshold;
            this.chunkVolume = chunkVolume;
        }
    }
}

