/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.api;

import dev.overgrown.aspectslib.api.IAspectDataProvider;
import dev.overgrown.aspectslib.data.Aspect;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.AspectManager;
import dev.overgrown.aspectslib.data.BiomeAspectModifier;
import dev.overgrown.aspectslib.data.BiomeAspectRegistry;
import dev.overgrown.aspectslib.data.BlockAspectRegistry;
import dev.overgrown.aspectslib.data.EntityAspectRegistry;
import dev.overgrown.aspectslib.data.ItemAspectRegistry;
import dev.overgrown.aspectslib.data.ModRegistries;
import dev.overgrown.aspectslib.entity.aura_node.client.AuraNodeVisibilityConfig;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class AspectsAPI {
    public static AspectData getAspectData(class_1799 stack) {
        return ((IAspectDataProvider)stack).aspectslib$getAspectData();
    }

    public static void setAspectData(class_1799 stack, @Nullable AspectData data) {
        ((IAspectDataProvider)stack).aspectslib$setAspectData(data);
    }

    public static boolean addAspect(class_1799 stack, class_2960 aspectId, int amount) {
        Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
        if (aspect == null) {
            return false;
        }
        AspectData currentData = AspectsAPI.getAspectData(stack);
        AspectData.Builder builder = new AspectData.Builder(currentData);
        builder.add(aspectId, amount);
        AspectsAPI.setAspectData(stack, builder.build());
        return true;
    }

    public static boolean addAspectByName(class_1799 stack, String aspectName, int amount) {
        AspectData currentData = AspectsAPI.getAspectData(stack);
        AspectData.Builder builder = new AspectData.Builder(currentData);
        builder.addByName(aspectName, amount);
        AspectsAPI.setAspectData(stack, builder.build());
        return true;
    }

    public static void registerItemAspect(class_1792 item, class_2960 aspectId, int amount) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
        if (aspect != null) {
            Object2IntOpenHashMap aspects = new Object2IntOpenHashMap();
            aspects.put((Object)aspectId, amount);
            ItemAspectRegistry.register(itemId, new AspectData((Object2IntOpenHashMap<class_2960>)aspects));
        }
    }

    public static void registerItemAspectByName(class_1792 item, String aspectName, int amount) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        AspectData.Builder builder = new AspectData.Builder(AspectData.DEFAULT);
        builder.addByName(aspectName, amount);
        ItemAspectRegistry.register(itemId, builder.build());
    }

    public static void registerBlockAspect(class_2248 block, class_2960 aspectId, int amount) {
        class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
        Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
        if (aspect != null) {
            Object2IntOpenHashMap aspects = new Object2IntOpenHashMap();
            aspects.put((Object)aspectId, amount);
            BlockAspectRegistry.register(blockId, new AspectData((Object2IntOpenHashMap<class_2960>)aspects));
        }
    }

    public static void registerEntityAspect(class_1299<?> entityType, class_2960 aspectId, int amount) {
        class_2960 entityId = class_7923.field_41177.method_10221(entityType);
        Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
        if (aspect != null) {
            Object2IntOpenHashMap aspects = new Object2IntOpenHashMap();
            aspects.put((Object)aspectId, amount);
            EntityAspectRegistry.register(entityId, new AspectData((Object2IntOpenHashMap<class_2960>)aspects));
        }
    }

    public static void registerBiomeAspect(class_5321<class_1959> biomeKey, class_2960 aspectId, int amount) {
        Aspect aspect = ModRegistries.ASPECTS.get(aspectId);
        if (aspect != null) {
            Object2IntOpenHashMap aspects = new Object2IntOpenHashMap();
            aspects.put((Object)aspectId, amount);
            BiomeAspectRegistry.register(biomeKey, new AspectData((Object2IntOpenHashMap<class_2960>)aspects));
        }
    }

    public static AspectData getItemAspectData(class_2960 itemId) {
        return ItemAspectRegistry.get(itemId);
    }

    public static AspectData getItemAspectData(class_1792 item) {
        class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
        return ItemAspectRegistry.get(itemId);
    }

    public static AspectData getBlockAspectData(class_2960 blockId) {
        return BlockAspectRegistry.get(blockId);
    }

    public static AspectData getEntityAspectData(class_2960 entityId) {
        return EntityAspectRegistry.get(entityId);
    }

    public static AspectData getBiomeAspectData(class_5321<class_1959> biomeKey) {
        return BiomeAspectModifier.getCombinedBiomeAspects(biomeKey.method_29177());
    }

    public static AspectData getBiomeAspectData(class_2960 biomeId) {
        return BiomeAspectModifier.getCombinedBiomeAspects(biomeId);
    }

    public static Optional<Aspect> getAspect(class_2960 aspectId) {
        return Optional.ofNullable(ModRegistries.ASPECTS.get(aspectId));
    }

    public static Optional<Aspect> getAspectByName(String aspectName) {
        class_2960 aspectId = AspectManager.NAME_TO_ID.get(aspectName);
        return aspectId != null ? AspectsAPI.getAspect(aspectId) : Optional.empty();
    }

    public static AspectData.Builder createAspectDataBuilder() {
        return new AspectData.Builder(AspectData.DEFAULT);
    }

    public static Map<class_2960, Aspect> getAllAspects() {
        return Collections.unmodifiableMap(ModRegistries.ASPECTS);
    }

    public static void addAuraNodeVisibilityCondition(BiPredicate<class_1657, Boolean> condition) {
        AuraNodeVisibilityConfig.addVisibilityCondition(condition);
    }

    public static void setAuraNodesAlwaysVisible(boolean alwaysShow) {
        AuraNodeVisibilityConfig.setAlwaysShow(alwaysShow);
    }
}

