/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.overgrown.aspectslib.corruption.CorruptionAPI;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.class_7924;

public class CorruptionCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"corruption").requires(source -> source.method_9259(2))).executes(CorruptionCommand::checkCurrentChunk)).then(class_2170.method_9247((String)"purify").executes(CorruptionCommand::purifyCurrentChunk))).then(class_2170.method_9247((String)"force").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)1000)).executes(CorruptionCommand::forceCorruption))));
    }

    private static int checkCurrentChunk(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_3218 world = (class_3218)player.method_37908();
        class_1923 chunkPos = player.method_31476();
        class_1959 biome = (class_1959)world.method_23753(player.method_24515()).comp_349();
        class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not determine current biome"));
            return 0;
        }
        boolean isPure = CorruptionAPI.isChunkPure(world, chunkPos);
        boolean isTainted = CorruptionAPI.isChunkTainted(world, chunkPos);
        boolean isCorrupted = CorruptionAPI.isChunkCorrupted(world, chunkPos);
        int vitiumAmount = CorruptionAPI.getVitiumAmount(world, chunkPos);
        String state = isCorrupted ? "\u00a7cCorrupted" : (isTainted ? "\u00a7eTainted" : (isPure ? "\u00a7aPure" : "\u00a77Unknown"));
        source.method_9226(() -> class_2561.method_43470((String)("Chunk: " + chunkPos.toString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("Biome: " + biomeId.toString())), false);
        source.method_9226(() -> class_2561.method_43470((String)("State: " + state)), false);
        source.method_9226(() -> class_2561.method_43470((String)("Vitium: " + vitiumAmount)), false);
        return 1;
    }

    private static int purifyCurrentChunk(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_3218 world = (class_3218)player.method_37908();
        class_1923 chunkPos = player.method_31476();
        class_1959 biome = (class_1959)world.method_23753(player.method_24515()).comp_349();
        class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not determine current biome"));
            return 0;
        }
        int vitiumBefore = CorruptionAPI.getVitiumAmount(world, chunkPos);
        CorruptionAPI.purifyChunk(world, chunkPos);
        int vitiumAfter = CorruptionAPI.getVitiumAmount(world, chunkPos);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aPurified chunk region: " + String.valueOf(chunkPos) + " (biome: " + String.valueOf(biomeId) + ") - Removed " + (vitiumBefore - vitiumAfter) + " Vitium")), true);
        return 1;
    }

    private static int forceCorruption(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        class_3218 world = (class_3218)player.method_37908();
        class_1923 chunkPos = player.method_31476();
        class_1959 biome = (class_1959)world.method_23753(player.method_24515()).comp_349();
        class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Could not determine current biome"));
            return 0;
        }
        CorruptionAPI.forceCorruption(world, chunkPos, amount);
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7cForced corruption in chunk region: " + String.valueOf(chunkPos) + " (biome: " + String.valueOf(biomeId) + ") - Added " + amount + " Vitium")), true);
        return 1;
    }
}

