/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7924;

public class BiomeRegionDetector {
    private static final int MAX_REGION_SIZE = 1024;

    public static Set<class_1923> findConnectedBiomeChunks(class_3218 world, class_1923 startChunk, class_2960 biomeId, int maxRadius) {
        HashSet<class_1923> visited = new HashSet<class_1923>();
        LinkedList<class_1923> queue = new LinkedList<class_1923>();
        queue.add(startChunk);
        visited.add(startChunk);
        while (!queue.isEmpty() && visited.size() < 1024) {
            class_1923 current = (class_1923)queue.poll();
            if (Math.abs(current.field_9181 - startChunk.field_9181) > maxRadius || Math.abs(current.field_9180 - startChunk.field_9180) > maxRadius) continue;
            for (class_1923 neighbor : BiomeRegionDetector.getAdjacentChunks(current)) {
                class_2960 neighborBiomeId;
                if (visited.contains(neighbor) || !world.method_14178().method_12123(neighbor.field_9181, neighbor.field_9180) || !biomeId.equals((Object)(neighborBiomeId = BiomeRegionDetector.getBiomeIdForChunk(world, neighbor)))) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return visited;
    }

    private static List<class_1923> getAdjacentChunks(class_1923 center) {
        return Arrays.asList(new class_1923(center.field_9181 + 1, center.field_9180), new class_1923(center.field_9181 - 1, center.field_9180), new class_1923(center.field_9181, center.field_9180 + 1), new class_1923(center.field_9181, center.field_9180 - 1));
    }

    private static class_2960 getBiomeIdForChunk(class_3218 world, class_1923 chunkPos) {
        class_2338 centerPos = chunkPos.method_8323().method_10069(8, 64, 8);
        class_1959 biome = (class_1959)world.method_23753(centerPos).comp_349();
        return world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
    }
}

