/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectRegistry;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class ChunkAspectStorage
extends class_18 {
    private final Long2ObjectMap<AspectData> chunkAspects = new Long2ObjectOpenHashMap();

    public AspectData getChunkAspects(class_1923 chunkPos, class_2960 biomeId) {
        long key = chunkPos.method_8324();
        AspectData stored = (AspectData)this.chunkAspects.get(key);
        if (stored != null) {
            return stored;
        }
        return BiomeAspectRegistry.get(biomeId);
    }

    public void setChunkAspects(class_1923 chunkPos, AspectData aspects) {
        this.chunkAspects.put(chunkPos.method_8324(), (Object)aspects);
        this.method_80();
    }

    public void modifyChunkAspect(class_1923 chunkPos, class_2960 biomeId, class_2960 aspectId, int delta) {
        if (delta == 0) {
            return;
        }
        long key = chunkPos.method_8324();
        AspectData current = (AspectData)this.chunkAspects.get(key);
        if (current == null) {
            current = BiomeAspectRegistry.get(biomeId);
        }
        AspectData.Builder builder = new AspectData.Builder(current);
        builder.add(aspectId, delta);
        this.chunkAspects.put(key, (Object)builder.build());
        this.method_80();
    }

    public void removeChunkAspects(class_1923 chunkPos) {
        if (this.chunkAspects.remove(chunkPos.method_8324()) != null) {
            this.method_80();
        }
    }

    public class_2487 method_75(class_2487 nbt) {
        class_2499 chunkList = new class_2499();
        for (Long2ObjectMap.Entry entry : this.chunkAspects.long2ObjectEntrySet()) {
            class_2487 chunkNbt = new class_2487();
            chunkNbt.method_10544("Pos", entry.getLongKey());
            AspectData aspects = (AspectData)entry.getValue();
            class_2499 aspectList = new class_2499();
            for (class_2960 aspectId : aspects.getAspectIds()) {
                int amount = aspects.getLevel(aspectId);
                if (amount <= 0) continue;
                class_2487 aspectNbt = new class_2487();
                aspectNbt.method_10582("Id", aspectId.toString());
                aspectNbt.method_10569("Amount", amount);
                aspectList.add((Object)aspectNbt);
            }
            chunkNbt.method_10566("Aspects", (class_2520)aspectList);
            chunkList.add((Object)chunkNbt);
        }
        nbt.method_10566("Chunks", (class_2520)chunkList);
        return nbt;
    }

    public static ChunkAspectStorage fromNbt(class_2487 nbt) {
        ChunkAspectStorage storage = new ChunkAspectStorage();
        if (nbt.method_10573("Chunks", 9)) {
            class_2499 chunkList = nbt.method_10554("Chunks", 10);
            for (int i = 0; i < chunkList.size(); ++i) {
                class_2487 chunkNbt = chunkList.method_10602(i);
                long pos = chunkNbt.method_10537("Pos");
                Object2IntOpenHashMap aspectMap = new Object2IntOpenHashMap();
                if (chunkNbt.method_10573("Aspects", 9)) {
                    class_2499 aspectList = chunkNbt.method_10554("Aspects", 10);
                    for (int j = 0; j < aspectList.size(); ++j) {
                        class_2487 aspectNbt = aspectList.method_10602(j);
                        class_2960 aspectId = class_2960.method_12829((String)aspectNbt.method_10558("Id"));
                        int amount = aspectNbt.method_10550("Amount");
                        if (aspectId == null || amount <= 0) continue;
                        aspectMap.put((Object)aspectId, amount);
                    }
                }
                if (aspectMap.isEmpty()) continue;
                storage.chunkAspects.put(pos, (Object)new AspectData((Object2IntOpenHashMap<class_2960>)aspectMap));
            }
        }
        return storage;
    }
}

