/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.corruption.BiomeRegionDetector;
import dev.overgrown.aspectslib.corruption.CorruptionChunkData;
import dev.overgrown.aspectslib.corruption.CorruptionDataManager;
import dev.overgrown.aspectslib.corruption.CorruptionManager;
import dev.overgrown.aspectslib.data.AspectData;
import java.util.Collection;
import java.util.Set;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7924;

public class CorruptionAPI {
    public static boolean isChunkPure(class_3218 world, class_1923 chunkPos) {
        return CorruptionManager.isChunkPure(world, chunkPos);
    }

    public static boolean isChunkTainted(class_3218 world, class_1923 chunkPos) {
        return CorruptionManager.isChunkTainted(world, chunkPos);
    }

    public static boolean isChunkCorrupted(class_3218 world, class_1923 chunkPos) {
        return CorruptionManager.isChunkCorrupted(world, chunkPos);
    }

    public static void forceCorruption(class_3218 world, class_1923 chunkPos, int vitiumAmount) {
        class_2338 centerPos = chunkPos.method_8323().method_10069(8, 64, 8);
        class_1959 biome = (class_1959)world.method_23753(centerPos).comp_349();
        class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            AspectsLib.LOGGER.warn("Could not determine biome for chunk {}", (Object)chunkPos);
            return;
        }
        Set<class_1923> region = BiomeRegionDetector.findConnectedBiomeChunks(world, chunkPos, biomeId, 32);
        class_2960 vitiumId = AspectsLib.identifier("vitium");
        CorruptionDataManager.modifyRegionAspects(world, region, biomeId, vitiumId, vitiumAmount);
        AspectsLib.LOGGER.info("Forced corruption on chunk region {} (biome {}) by adding {} Vitium", new Object[]{chunkPos, biomeId, vitiumAmount});
    }

    public static void purifyChunk(class_3218 world, class_1923 chunkPos) {
        class_2338 centerPos = chunkPos.method_8323().method_10069(8, 64, 8);
        class_1959 biome = (class_1959)world.method_23753(centerPos).comp_349();
        class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            AspectsLib.LOGGER.warn("Could not determine biome for chunk {}", (Object)chunkPos);
            return;
        }
        Set<class_1923> region = BiomeRegionDetector.findConnectedBiomeChunks(world, chunkPos, biomeId, 32);
        class_2960 vitiumId = AspectsLib.identifier("vitium");
        AspectData currentAspects = CorruptionDataManager.getChunkAspects(world, chunkPos, biomeId);
        int vitiumAmount = currentAspects.getLevel(vitiumId);
        if (vitiumAmount > 0) {
            CorruptionDataManager.modifyRegionAspects(world, region, biomeId, vitiumId, -vitiumAmount);
            AspectsLib.LOGGER.info("Purified chunk region {} (biome {}) by removing {} Vitium", new Object[]{chunkPos, biomeId, vitiumAmount});
        } else {
            AspectsLib.LOGGER.info("Chunk region {} (biome {}) has no Vitium to purify", (Object)chunkPos, (Object)biomeId);
        }
    }

    public static int getVitiumAmount(class_3218 world, class_1923 chunkPos) {
        class_2338 centerPos = chunkPos.method_8323().method_10069(8, 64, 8);
        class_1959 biome = (class_1959)world.method_23753(centerPos).comp_349();
        class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        if (biomeId == null) {
            return 0;
        }
        class_2960 vitiumId = AspectsLib.identifier("vitium");
        AspectData aspects = CorruptionDataManager.getChunkAspects(world, chunkPos, biomeId);
        return aspects.getLevel(vitiumId);
    }

    public static CorruptionChunkData getChunkData(class_3218 world, class_1923 chunkPos) {
        return CorruptionDataManager.getChunkData(world, chunkPos);
    }

    public static Collection<CorruptionChunkData> getTrackedChunks(class_3218 world) {
        return CorruptionDataManager.getAll(world);
    }
}

