/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Locale;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class CorruptionChunkData {
    private final class_1923 chunkPos;
    private Status status = Status.PURE;
    private class_2960 biomeId;
    private long lastUpdatedTick;
    private long lastCorruptedTick;
    private long lastRegenerationTick;
    private long lastCleanTick;
    private int corruptionEvents;
    private int regenerationEvents;
    private int sculkPlacements;
    private final Object2IntOpenHashMap<class_2960> aspectDeltas = new Object2IntOpenHashMap();
    private final Object2IntOpenHashMap<class_2960> aetherConsumed = new Object2IntOpenHashMap();

    public CorruptionChunkData(class_1923 chunkPos) {
        this.chunkPos = chunkPos;
    }

    public class_1923 getChunkPos() {
        return this.chunkPos;
    }

    public Status getStatus() {
        return this.status;
    }

    public class_2960 getBiomeId() {
        return this.biomeId;
    }

    public long getLastUpdatedTick() {
        return this.lastUpdatedTick;
    }

    public long getLastCorruptedTick() {
        return this.lastCorruptedTick;
    }

    public long getLastRegenerationTick() {
        return this.lastRegenerationTick;
    }

    public long getLastCleanTick() {
        return this.lastCleanTick;
    }

    public int getCorruptionEvents() {
        return this.corruptionEvents;
    }

    public int getRegenerationEvents() {
        return this.regenerationEvents;
    }

    public int getSculkPlacements() {
        return this.sculkPlacements;
    }

    public Object2IntOpenHashMap<class_2960> getAspectDeltas() {
        return this.aspectDeltas;
    }

    public Object2IntOpenHashMap<class_2960> getAetherConsumed() {
        return this.aetherConsumed;
    }

    public boolean setStatus(Status newStatus, class_2960 biomeId, long tick) {
        boolean changed = false;
        if (biomeId != null) {
            this.biomeId = biomeId;
        }
        if (this.status != newStatus) {
            Status previous = this.status;
            this.status = newStatus;
            changed = true;
            if (newStatus == Status.CORRUPTED) {
                ++this.corruptionEvents;
                this.lastCorruptedTick = tick;
            }
            if (previous == Status.CORRUPTED && newStatus != Status.CORRUPTED) {
                ++this.regenerationEvents;
                this.lastRegenerationTick = tick;
            }
            if (newStatus == Status.PURE) {
                this.lastCleanTick = tick;
            }
        }
        this.lastUpdatedTick = tick;
        return changed;
    }

    public boolean recordAspectDelta(class_2960 aspectId, int delta, class_2960 biomeId, long tick) {
        int newAmount;
        if (delta == 0) {
            return false;
        }
        boolean changed = false;
        if (biomeId != null) {
            this.biomeId = biomeId;
        }
        if ((newAmount = this.aspectDeltas.getOrDefault((Object)aspectId, 0) + delta) == 0) {
            changed = this.aspectDeltas.containsKey((Object)aspectId);
            this.aspectDeltas.removeInt((Object)aspectId);
        } else {
            this.aspectDeltas.put((Object)aspectId, newAmount);
            changed = true;
        }
        this.lastUpdatedTick = tick;
        return changed;
    }

    public boolean recordAetherConsumption(class_2960 aspectId, int amount, class_2960 biomeId, long tick) {
        if (amount <= 0) {
            return false;
        }
        if (biomeId != null) {
            this.biomeId = biomeId;
        }
        this.aetherConsumed.addTo((Object)aspectId, amount);
        this.lastUpdatedTick = tick;
        return true;
    }

    public boolean recordSculkPlacement(int count, long tick) {
        if (count <= 0) {
            return false;
        }
        this.sculkPlacements += count;
        this.lastUpdatedTick = tick;
        return true;
    }

    public boolean isPrunable() {
        return this.status == Status.PURE && this.aspectDeltas.isEmpty() && this.aetherConsumed.isEmpty() && this.sculkPlacements == 0 && this.corruptionEvents == 0 && this.regenerationEvents == 0;
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("State", this.status.ordinal());
        if (this.biomeId != null) {
            nbt.method_10582("BiomeId", this.biomeId.toString());
        }
        nbt.method_10544("LastUpdated", this.lastUpdatedTick);
        nbt.method_10544("LastCorrupted", this.lastCorruptedTick);
        nbt.method_10544("LastRegeneration", this.lastRegenerationTick);
        nbt.method_10544("LastClean", this.lastCleanTick);
        nbt.method_10569("CorruptionEvents", this.corruptionEvents);
        nbt.method_10569("RegenerationEvents", this.regenerationEvents);
        nbt.method_10569("SculkPlacements", this.sculkPlacements);
        if (!this.aspectDeltas.isEmpty()) {
            class_2499 aspectList = new class_2499();
            for (Object2IntMap.Entry entry : this.aspectDeltas.object2IntEntrySet()) {
                class_2487 aspectNbt = new class_2487();
                aspectNbt.method_10582("Id", ((class_2960)entry.getKey()).toString());
                aspectNbt.method_10569("Delta", entry.getIntValue());
                aspectList.add((Object)aspectNbt);
            }
            nbt.method_10566("AspectDeltas", (class_2520)aspectList);
        }
        if (!this.aetherConsumed.isEmpty()) {
            class_2499 aetherList = new class_2499();
            for (Object2IntMap.Entry entry : this.aetherConsumed.object2IntEntrySet()) {
                class_2487 aetherNbt = new class_2487();
                aetherNbt.method_10582("Id", ((class_2960)entry.getKey()).toString());
                aetherNbt.method_10569("Amount", entry.getIntValue());
                aetherList.add((Object)aetherNbt);
            }
            nbt.method_10566("AetherConsumed", (class_2520)aetherList);
        }
        return nbt;
    }

    public static CorruptionChunkData fromNbt(class_1923 chunkPos, class_2487 nbt) {
        class_2960 aspectId;
        int i;
        CorruptionChunkData data = new CorruptionChunkData(chunkPos);
        data.status = Status.fromOrdinal(nbt.method_10550("State"));
        if (nbt.method_10573("BiomeId", 8)) {
            data.biomeId = class_2960.method_12829((String)nbt.method_10558("BiomeId"));
        }
        data.lastUpdatedTick = nbt.method_10537("LastUpdated");
        data.lastCorruptedTick = nbt.method_10537("LastCorrupted");
        data.lastRegenerationTick = nbt.method_10537("LastRegeneration");
        data.lastCleanTick = nbt.method_10537("LastClean");
        data.corruptionEvents = nbt.method_10550("CorruptionEvents");
        data.regenerationEvents = nbt.method_10550("RegenerationEvents");
        data.sculkPlacements = nbt.method_10550("SculkPlacements");
        if (nbt.method_10573("AspectDeltas", 9)) {
            class_2499 aspectList = nbt.method_10554("AspectDeltas", 10);
            for (i = 0; i < aspectList.size(); ++i) {
                class_2487 aspectNbt = aspectList.method_10602(i);
                aspectId = class_2960.method_12829((String)aspectNbt.method_10558("Id"));
                int delta = aspectNbt.method_10550("Delta");
                if (aspectId == null || delta == 0) continue;
                data.aspectDeltas.put((Object)aspectId, delta);
            }
        }
        if (nbt.method_10573("AetherConsumed", 9)) {
            class_2499 aetherList = nbt.method_10554("AetherConsumed", 10);
            for (i = 0; i < aetherList.size(); ++i) {
                class_2487 aetherNbt = aetherList.method_10602(i);
                aspectId = class_2960.method_12829((String)aetherNbt.method_10558("Id"));
                int amount = aetherNbt.method_10550("Amount");
                if (aspectId == null || amount <= 0) continue;
                data.aetherConsumed.put((Object)aspectId, amount);
            }
        }
        return data;
    }

    public static enum Status {
        PURE,
        TAINTED,
        CORRUPTED,
        REGENERATING;


        public static Status fromOrdinal(int ordinal) {
            Status[] values = Status.values();
            if (ordinal < 0 || ordinal >= values.length) {
                return PURE;
            }
            return values[ordinal];
        }

        public static Status fromString(String name) {
            try {
                return Status.valueOf(name.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                return PURE;
            }
        }
    }
}

