/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.corruption;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.aether.AetherChunkData;
import dev.overgrown.aspectslib.aether.AetherManager;
import dev.overgrown.aspectslib.aether.DeadZoneData;
import dev.overgrown.aspectslib.corruption.BiomeRegionDetector;
import dev.overgrown.aspectslib.corruption.CorruptionChunkData;
import dev.overgrown.aspectslib.corruption.CorruptionDataManager;
import dev.overgrown.aspectslib.data.AspectData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class CorruptionManager {
    public static final class_2960 VITIUM_ID = AspectsLib.identifier("vitium");
    private static final Random RANDOM = new Random();
    private static final int CORRUPTION_CHECK_INTERVAL = 200;
    private static final int ASPECT_CONSUMPTION_INTERVAL = 400;
    private static final int AETHER_CONSUMPTION_INTERVAL = 1200;
    private static final int SCULK_SPREAD_CHANCE = 20;
    private static final int MAX_SCULK_PER_CHUNK = 64;
    private static final double PERMANENT_DEAD_ZONE_CHANCE = 0.1;
    private static final int MAX_REGION_RADIUS = 32;

    public static void initialize() {
        ServerTickEvents.START_SERVER_TICK.register(CorruptionManager::onServerTick);
    }

    private static void onServerTick(MinecraftServer server) {
        long time = server.method_30002().method_8510();
        if (time % 200L != 0L) {
            return;
        }
        for (class_3218 world : server.method_3738()) {
            CorruptionManager.processWorldCorruption(world, time);
        }
    }

    private static void processWorldCorruption(class_3218 world, long currentTime) {
        Set<class_1923> loadedChunks = CorruptionManager.getLoadedChunks(world);
        HashSet<class_1923> processedChunks = new HashSet<class_1923>();
        for (class_1923 chunkPos : loadedChunks) {
            if (processedChunks.contains(chunkPos)) continue;
            class_2338 centerPos = chunkPos.method_8323().method_10069(8, 64, 8);
            class_1959 biome = (class_1959)world.method_23753(centerPos).comp_349();
            class_2960 biomeId = world.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
            if (biomeId == null) continue;
            Set<class_1923> region = BiomeRegionDetector.findConnectedBiomeChunks(world, chunkPos, biomeId, 32);
            processedChunks.addAll(region);
            CorruptionManager.processRegionCorruption(world, biomeId, region, chunkPos, currentTime);
        }
    }

    private static void processRegionCorruption(class_3218 world, class_2960 biomeId, Set<class_1923> region, class_1923 representativeChunk, long currentTime) {
        int currentTotalOtherAspects;
        AspectData currentRegionAspects = CorruptionDataManager.getChunkAspects(world, representativeChunk, biomeId);
        int currentVitiumAmount = currentRegionAspects.getLevel(VITIUM_ID);
        if (currentVitiumAmount == 0) {
            CorruptionManager.updateRegionStatuses(world, region, biomeId, CorruptionChunkData.Status.PURE, currentTime);
            return;
        }
        int baseTotalForComparison = currentTotalOtherAspects = CorruptionManager.calculateTotalOtherAspects(currentRegionAspects);
        if (AspectsLib.LOGGER.isDebugEnabled()) {
            AspectsLib.LOGGER.debug("Region {} aspects - Vitium: {}, Other aspects total: {}", new Object[]{biomeId, currentVitiumAmount, baseTotalForComparison});
            for (class_2960 aspectId : currentRegionAspects.getAspectIds()) {
                int amount = currentRegionAspects.getLevel(aspectId);
                if (aspectId.equals((Object)VITIUM_ID)) continue;
                AspectsLib.LOGGER.debug("  {}: {}", (Object)aspectId, (Object)amount);
            }
        }
        if (currentVitiumAmount > baseTotalForComparison) {
            CorruptionManager.updateRegionStatuses(world, region, biomeId, CorruptionChunkData.Status.CORRUPTED, currentTime);
            AspectsLib.LOGGER.info("Region {} became corrupted! Vitium: {} > Other aspects total: {}", new Object[]{biomeId, currentVitiumAmount, baseTotalForComparison});
            CorruptionManager.processRegionCorruptionEffects(world, region, biomeId, representativeChunk, currentRegionAspects, currentTime);
            if (currentTotalOtherAspects == 0 && currentVitiumAmount > 0 && currentTime % 1200L == 0L) {
                CorruptionManager.processAetherConsumption(world, region, biomeId, currentTime);
            }
        } else {
            CorruptionManager.updateRegionStatuses(world, region, biomeId, CorruptionChunkData.Status.TAINTED, currentTime);
            AspectsLib.LOGGER.debug("Region {} is tainted. Vitium: {} <= Other aspects total: {} (needs to be > {} to corrupt)", new Object[]{biomeId, currentVitiumAmount, baseTotalForComparison, baseTotalForComparison});
        }
    }

    private static void updateRegionStatuses(class_3218 world, Set<class_1923> region, class_2960 biomeId, CorruptionChunkData.Status status, long tick) {
        for (class_1923 chunkPos : region) {
            CorruptionDataManager.updateChunkStatus(world, chunkPos, biomeId, status, tick);
        }
    }

    private static int calculateTotalOtherAspects(AspectData aspects) {
        int total = 0;
        for (class_2960 aspectId : aspects.getAspectIds()) {
            if (aspectId.equals((Object)VITIUM_ID)) continue;
            total += aspects.getLevel(aspectId);
        }
        return total;
    }

    private static void processRegionCorruptionEffects(class_3218 world, Set<class_1923> region, class_2960 biomeId, class_1923 representativeChunk, AspectData currentAspects, long currentTime) {
        if (RANDOM.nextInt(100) < 20) {
            ArrayList<class_1923> regionList = new ArrayList<class_1923>(region);
            class_1923 randomChunk = (class_1923)regionList.get(RANDOM.nextInt(regionList.size()));
            CorruptionManager.spreadSculk(world, randomChunk, currentTime);
        }
        if (currentTime % 400L == 0L) {
            CorruptionManager.consumeRegionAspects(world, region, biomeId, currentAspects).ifPresent(result -> {
                CorruptionDataManager.recordAspectDelta(world, representativeChunk, biomeId, result.aspectId(), -1, currentTime);
                int vitiumDelta = result.vitiumAfter() - result.vitiumBefore();
                if (vitiumDelta != 0) {
                    CorruptionDataManager.recordAspectDelta(world, representativeChunk, biomeId, VITIUM_ID, vitiumDelta, currentTime);
                }
            });
        }
    }

    private static void spreadSculk(class_3218 world, class_1923 chunkPos, long currentTime) {
        int sculkCount = 0;
        for (int i = 0; i < 3 && sculkCount < 64; ++i) {
            int z;
            int x = chunkPos.method_8326() + RANDOM.nextInt(16);
            class_2338 pos = CorruptionManager.findSurfacePosition((class_1937)world, new class_2338(x, 0, z = chunkPos.method_8328() + RANDOM.nextInt(16)));
            if (pos == null || !world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10074()).method_26225()) continue;
            world.method_8501(pos, class_2246.field_37568.method_9564());
            ++sculkCount;
            CorruptionDataManager.recordSculkPlacement(world, chunkPos, 1, currentTime);
            world.method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_37357, class_3419.field_15245, 1.0f, 0.8f + RANDOM.nextFloat() * 0.4f);
            AspectsLib.LOGGER.debug("Placed sculk at {} in chunk {}", (Object)pos, (Object)chunkPos);
        }
    }

    private static class_2338 findSurfacePosition(class_1937 world, class_2338 pos) {
        for (int y = world.method_31600(); y >= world.method_31607(); --y) {
            class_2338 currentPos = new class_2338(pos.method_10263(), y, pos.method_10260());
            if (!world.method_8320(currentPos).method_26225()) continue;
            return currentPos.method_10084();
        }
        return null;
    }

    private static Optional<AspectConsumptionResult> consumeRegionAspects(class_3218 world, Set<class_1923> region, class_2960 biomeId, AspectData currentAspects) {
        ArrayList<class_2960> nonVitiumAspects = new ArrayList<class_2960>();
        for (class_2960 aspectId : currentAspects.getAspectIds()) {
            if (aspectId.equals((Object)VITIUM_ID) || currentAspects.getLevel(aspectId) <= 0) continue;
            nonVitiumAspects.add(aspectId);
        }
        if (nonVitiumAspects.isEmpty()) {
            AspectsLib.LOGGER.debug("No non-Vitium aspects left to consume in region {}", (Object)biomeId);
            return Optional.empty();
        }
        class_2960 targetAspect = (class_2960)nonVitiumAspects.get(RANDOM.nextInt(nonVitiumAspects.size()));
        int currentAmount = currentAspects.getLevel(targetAspect);
        if (currentAmount > 0) {
            int previousVitiumAmount = currentAspects.getLevel(VITIUM_ID);
            CorruptionDataManager.modifyRegionAspects(world, region, biomeId, targetAspect, -1);
            CorruptionDataManager.modifyRegionAspects(world, region, biomeId, VITIUM_ID, 1);
            class_1923 representativeChunk = region.iterator().next();
            AspectData updatedAspects = CorruptionDataManager.getChunkAspects(world, representativeChunk, biomeId);
            int newAmount = updatedAspects.getLevel(targetAspect);
            int newVitiumAmount = updatedAspects.getLevel(VITIUM_ID);
            AspectsLib.LOGGER.info("Vitium consumed 1 {} from region {}. {}: {} -> {}, Vitium: {} -> {}", new Object[]{targetAspect, biomeId, targetAspect, currentAmount, newAmount, previousVitiumAmount, newVitiumAmount});
            if (newAmount <= 0) {
                AspectsLib.LOGGER.info("Aspect {} completely consumed in region {}! Moving to next aspect.", (Object)targetAspect, (Object)biomeId);
            }
            return Optional.of(new AspectConsumptionResult(targetAspect, currentAmount, newAmount, previousVitiumAmount, newVitiumAmount));
        }
        return Optional.empty();
    }

    private static void processAetherConsumption(class_3218 world, Set<class_1923> region, class_2960 biomeId, long currentTime) {
        ArrayList<class_1923> regionList = new ArrayList<class_1923>(region);
        class_1923 targetChunk = (class_1923)regionList.get(RANDOM.nextInt(regionList.size()));
        AetherChunkData aetherData = AetherManager.getAetherData((class_1937)world, targetChunk);
        int totalAether = 0;
        for (class_2960 class_29602 : aetherData.getAspectIds()) {
            totalAether += aetherData.getCurrentAether(class_29602);
        }
        if (totalAether > 0) {
            class_2960 targetAspect = null;
            for (class_2960 aspectId : aetherData.getAspectIds()) {
                if (aetherData.getCurrentAether(aspectId) <= 0) continue;
                targetAspect = aspectId;
                if (aspectId.equals((Object)VITIUM_ID)) continue;
                break;
            }
            if (targetAspect != null && aetherData.harvestAether(targetAspect, 1)) {
                CorruptionDataManager.modifyRegionAspects(world, region, biomeId, VITIUM_ID, 1);
                CorruptionDataManager.recordAetherConsumption(world, targetChunk, biomeId, targetAspect, 1, currentTime);
                CorruptionDataManager.recordAspectDelta(world, targetChunk, biomeId, VITIUM_ID, 1, currentTime);
                AspectsLib.LOGGER.info("Consumed 1 {} Aether from chunk {}, total aether remaining: {}", new Object[]{targetAspect, targetChunk, totalAether - 1});
            }
        } else if (!AetherManager.isDeadZone((class_1937)world, targetChunk)) {
            boolean permanent = RANDOM.nextDouble() < 0.1;
            DeadZoneData deadZoneData = new DeadZoneData(permanent, world.method_8510());
            AetherManager.markAsDeadZone((class_1937)world, targetChunk, deadZoneData);
            CorruptionManager.eraseRegionAspects(world, region, biomeId);
            CorruptionDataManager.updateChunkStatus(world, targetChunk, biomeId, CorruptionChunkData.Status.REGENERATING, currentTime);
            AspectsLib.LOGGER.info("Created {} dead zone at {} in region {}", new Object[]{permanent ? "permanent" : "temporary", targetChunk, biomeId});
        }
    }

    private static void eraseRegionAspects(class_3218 world, Set<class_1923> region, class_2960 biomeId) {
        class_1923 representativeChunk = region.iterator().next();
        AspectData currentAspects = CorruptionDataManager.getChunkAspects(world, representativeChunk, biomeId);
        for (class_2960 aspectId : currentAspects.getAspectIds()) {
            int currentAmount = currentAspects.getLevel(aspectId);
            if (currentAmount <= 0) continue;
            CorruptionDataManager.modifyRegionAspects(world, region, biomeId, aspectId, -currentAmount);
        }
        AspectsLib.LOGGER.info("Erased all aspects from region {}", (Object)biomeId);
    }

    private static Set<class_1923> getLoadedChunks(class_3218 world) {
        HashSet<class_1923> loadedChunks = new HashSet<class_1923>();
        for (class_3222 player : world.method_18456()) {
            class_1923 playerChunk = player.method_31476();
            int viewDistance = world.method_8503().method_3760().method_14568();
            for (int x = -viewDistance; x <= viewDistance; ++x) {
                for (int z = -viewDistance; z <= viewDistance; ++z) {
                    class_1923 chunkPos = new class_1923(playerChunk.field_9181 + x, playerChunk.field_9180 + z);
                    if (!world.method_14178().method_12123(chunkPos.field_9181, chunkPos.field_9180)) continue;
                    loadedChunks.add(chunkPos);
                }
            }
        }
        return loadedChunks;
    }

    public static boolean isChunkCorrupted(class_3218 world, class_1923 chunkPos) {
        CorruptionChunkData data = CorruptionDataManager.getChunkData(world, chunkPos);
        return data != null && data.getStatus() == CorruptionChunkData.Status.CORRUPTED;
    }

    public static boolean isChunkTainted(class_3218 world, class_1923 chunkPos) {
        CorruptionChunkData data = CorruptionDataManager.getChunkData(world, chunkPos);
        return data != null && data.getStatus() == CorruptionChunkData.Status.TAINTED;
    }

    public static boolean isChunkPure(class_3218 world, class_1923 chunkPos) {
        CorruptionChunkData data = CorruptionDataManager.getChunkData(world, chunkPos);
        return data == null || data.getStatus() == CorruptionChunkData.Status.PURE;
    }

    private record AspectConsumptionResult(class_2960 aspectId, int previousAmount, int newAmount, int vitiumBefore, int vitiumAfter) {
    }
}

