/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectRegistry;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class BiomeAspectModifier {
    private static final Map<class_2960, AspectData> biomeModifications = new HashMap<class_2960, AspectData>();

    public static void addBiomeModification(class_2960 biomeId, class_2960 aspectId, int amount) {
        if (amount == 0) {
            return;
        }
        AspectData current = biomeModifications.get(biomeId);
        Object2IntOpenHashMap updatedMap = current != null ? new Object2IntOpenHashMap(current.getMap()) : new Object2IntOpenHashMap();
        int newAmount = updatedMap.getOrDefault((Object)aspectId, 0) + amount;
        if (newAmount == 0) {
            updatedMap.removeInt((Object)aspectId);
        } else {
            updatedMap.put((Object)aspectId, newAmount);
        }
        if (updatedMap.isEmpty()) {
            biomeModifications.remove(biomeId);
        } else {
            biomeModifications.put(biomeId, new AspectData((Object2IntOpenHashMap<class_2960>)new Object2IntOpenHashMap((Object2IntMap)updatedMap)));
        }
    }

    public static void drainAllAspects(class_2960 biomeId, int amount) {
        AspectData currentBiomeAspects = BiomeAspectRegistry.get(biomeId);
        if (!currentBiomeAspects.isEmpty()) {
            AspectData.Builder builder = new AspectData.Builder(currentBiomeAspects);
            for (class_2960 aspectId : currentBiomeAspects.getAspectIds()) {
                int currentAmount = currentBiomeAspects.getLevel(aspectId);
                if (currentAmount <= 0) continue;
                builder.set(aspectId, Math.max(0, currentAmount - amount));
            }
            BiomeAspectRegistry.update(biomeId, builder.build());
        }
    }

    public static AspectData getModifiedBiomeAspects(class_2960 biomeId, AspectData original) {
        AspectData modification = biomeModifications.get(biomeId);
        if (modification != null && !modification.isEmpty()) {
            AspectData.Builder builder = new AspectData.Builder(original);
            for (class_2960 aspectId : modification.getAspectIds()) {
                builder.add(aspectId, modification.getLevel(aspectId));
            }
            return builder.build();
        }
        return original;
    }

    public static void clearModifications() {
        biomeModifications.clear();
    }

    public static AspectData getCombinedBiomeAspects(class_2960 biomeId) {
        AspectData original = BiomeAspectRegistry.get(biomeId);
        AspectData modification = biomeModifications.get(biomeId);
        if (modification == null || modification.isEmpty()) {
            return original;
        }
        AspectData.Builder builder = new AspectData.Builder(original);
        for (class_2960 aspectId : modification.getAspectIds()) {
            int modAmount = modification.getLevel(aspectId);
            if (modAmount == 0) continue;
            builder.add(aspectId, modAmount);
        }
        return builder.build();
    }

    public static void applyModificationsToRegistry() {
        for (Map.Entry<class_2960, AspectData> entry : biomeModifications.entrySet()) {
            class_2960 biomeId = entry.getKey();
            AspectData modification = entry.getValue();
            AspectData original = BiomeAspectRegistry.get(biomeId);
            AspectData.Builder builder = new AspectData.Builder(original);
            for (class_2960 aspectId : modification.getAspectIds()) {
                int modAmount = modification.getLevel(aspectId);
                if (modAmount == 0) continue;
                builder.add(aspectId, modAmount);
            }
            BiomeAspectRegistry.update(biomeId, builder.build());
        }
        BiomeAspectModifier.clearModifications();
        AspectsLib.LOGGER.info("Applied biome aspect modifications to registry");
    }
}

