/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import dev.overgrown.aspectslib.data.AspectData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class BiomeAspectRegistry {
    private static final HashMap<class_5321<class_1959>, AspectData> keyToAspect = new HashMap();
    private static final HashMap<class_2960, AspectData> idToAspect = new HashMap();

    public static AspectData register(class_5321<class_1959> key, AspectData aspect) {
        if (keyToAspect.containsKey(key)) {
            AspectData existing = keyToAspect.get(key);
            AspectData combined = existing.addAspect(aspect);
            keyToAspect.put(key, combined);
            return combined;
        }
        keyToAspect.put(key, aspect);
        return aspect;
    }

    public static AspectData register(class_2960 id, AspectData aspect) {
        if (idToAspect.containsKey(id)) {
            AspectData existing = idToAspect.get(id);
            AspectData combined = existing.addAspect(aspect);
            idToAspect.put(id, combined);
            return combined;
        }
        idToAspect.put(id, aspect);
        return aspect;
    }

    public static void update(class_5321<class_1959> key, AspectData aspect) {
        keyToAspect.put(key, aspect);
    }

    public static void update(class_2960 id, AspectData aspect) {
        idToAspect.put(id, aspect);
    }

    protected static void remove(class_5321<class_1959> key) {
        keyToAspect.remove(key);
    }

    protected static void remove(class_2960 id) {
        idToAspect.remove(id);
    }

    public static int size() {
        return keyToAspect.size() + idToAspect.size();
    }

    public static Stream<class_5321<class_1959>> biomeKeys() {
        return keyToAspect.keySet().stream();
    }

    public static Stream<class_2960> identifiers() {
        return idToAspect.keySet().stream();
    }

    public static Set<Map.Entry<class_5321<class_1959>, AspectData>> biomeEntries() {
        return keyToAspect.entrySet();
    }

    public static Set<Map.Entry<class_2960, AspectData>> entries() {
        return idToAspect.entrySet();
    }

    public static List<AspectData> values() {
        ArrayList<AspectData> combined = new ArrayList<AspectData>();
        combined.addAll(keyToAspect.values());
        combined.addAll(idToAspect.values());
        return combined;
    }

    public static AspectData get(class_5321<class_1959> key) {
        AspectData keyData = keyToAspect.get(key);
        if (keyData != null && !keyData.isEmpty()) {
            return keyData;
        }
        class_2960 biomeId = key.method_29177();
        AspectData idData = idToAspect.get(biomeId);
        if (idData != null && !idData.isEmpty()) {
            return idData;
        }
        return AspectData.DEFAULT;
    }

    public static AspectData get(class_2960 id) {
        AspectData data = idToAspect.get(id);
        if (data != null && !data.isEmpty()) {
            return data;
        }
        for (Map.Entry<class_5321<class_1959>, AspectData> entry : keyToAspect.entrySet()) {
            if (!entry.getKey().method_29177().equals((Object)id)) continue;
            return entry.getValue();
        }
        return AspectData.DEFAULT;
    }

    public static class_5321<class_1959> getKey(AspectData aspect) {
        Optional<Map.Entry> entryOptional = keyToAspect.entrySet().stream().filter(aspectEntry -> Objects.equals(aspectEntry.getValue(), aspect)).findFirst();
        if (entryOptional.isPresent()) {
            return (class_5321)entryOptional.get().getKey();
        }
        throw new IllegalArgumentException("Could not get registry key from aspect data '" + aspect.toString() + "', as it was not registered!");
    }

    public static class_2960 getId(AspectData aspect) {
        Optional<Map.Entry> entryOptional = idToAspect.entrySet().stream().filter(aspectEntry -> Objects.equals(aspectEntry.getValue(), aspect)).findFirst();
        if (entryOptional.isPresent()) {
            return (class_2960)entryOptional.get().getKey();
        }
        throw new IllegalArgumentException("Could not get identifier from aspect data '" + aspect.toString() + "', as it was not registered!");
    }

    public static boolean contains(class_5321<class_1959> key) {
        return keyToAspect.containsKey(key) || idToAspect.containsKey(key.method_29177());
    }

    public static boolean contains(class_2960 id) {
        return idToAspect.containsKey(id);
    }

    public static void clear() {
        keyToAspect.clear();
        idToAspect.clear();
    }

    public static void reset() {
        BiomeAspectRegistry.clear();
    }
}

