/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.data;

import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.ItemAspectRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2960;

public class BlockAspectRegistry {
    private static final HashMap<class_2960, AspectData> idToAspect = new HashMap();

    public static AspectData register(class_2960 id, AspectData aspect) {
        if (idToAspect.containsKey(id)) {
            AspectData existing = idToAspect.get(id);
            existing.addAspect(aspect);
            return aspect;
        }
        idToAspect.put(id, aspect);
        return aspect;
    }

    public static void update(class_2960 id, AspectData aspect) {
        if (idToAspect.containsKey(id)) {
            AspectData old = idToAspect.get(id);
            idToAspect.remove(id);
        }
        BlockAspectRegistry.register(id, aspect);
    }

    protected static void remove(class_2960 id) {
        idToAspect.remove(id);
    }

    public static int size() {
        return idToAspect.size();
    }

    public static Stream<class_2960> identifiers() {
        return idToAspect.keySet().stream();
    }

    public static Set<Map.Entry<class_2960, AspectData>> entries() {
        return idToAspect.entrySet();
    }

    public static List<AspectData> values() {
        return idToAspect.values().stream().toList();
    }

    public static AspectData get(class_2960 id) {
        AspectData blockData = idToAspect.get(id);
        if (blockData != null) {
            return blockData;
        }
        AspectData itemData = ItemAspectRegistry.get(id);
        if (itemData != null && !itemData.isEmpty()) {
            return itemData;
        }
        return AspectData.DEFAULT;
    }

    public static class_2960 getId(AspectData aspect) {
        Optional<Map.Entry> entryOptional = idToAspect.entrySet().stream().filter(aspectEntry -> Objects.equals(aspectEntry.getValue(), aspect)).findFirst();
        if (entryOptional.isPresent()) {
            return (class_2960)entryOptional.get().getKey();
        }
        throw new IllegalArgumentException("Could not get identifier from aspect data '" + aspect.toString() + "', as it was not registered!");
    }

    public static boolean contains(class_2960 id) {
        return idToAspect.containsKey(id);
    }

    public static void clear() {
        idToAspect.clear();
    }

    public static void reset() {
        BlockAspectRegistry.clear();
    }
}

