/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.entity.aura_node;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BiomeAspectModifier;
import dev.overgrown.aspectslib.data.BiomeAspectRegistry;
import dev.overgrown.aspectslib.resonance.ResonanceCalculator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class AuraNodeEntity
extends class_1297 {
    private final Map<class_2960, Float> regenAccumulators = new HashMap<class_2960, Float>();
    private static final class_2940<Integer> NODE_TYPE = class_2945.method_12791(AuraNodeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_2487> ASPECTS_NBT = class_2945.method_12791(AuraNodeEntity.class, (class_2941)class_2943.field_13318);
    public static final class_2960 FAMES_ASPECT = AspectsLib.identifier("fames");
    public static final class_2960 VITIUM_ASPECT = AspectsLib.identifier("vitium");
    private Map<class_2960, AspectState> aspects = new HashMap<class_2960, AspectState>();
    private int instabilityCounter = 0;
    private int hungerCounter = 0;
    private int sinisterCounter = 0;

    public AuraNodeEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
        this.field_5960 = true;
        this.method_5684(true);
    }

    protected void method_5693() {
        this.field_6011.method_12784(NODE_TYPE, (Object)NodeType.NORMAL.ordinal());
        this.field_6011.method_12784(ASPECTS_NBT, (Object)new class_2487());
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            this.regenerateAspects();
            this.removeDrainedAspects();
            if (this.aspects.isEmpty()) {
                return;
            }
            switch (this.getNodeType().ordinal()) {
                case 2: {
                    this.handleSinisterBehavior();
                    break;
                }
                case 4: {
                    this.handleHungryBehavior();
                    break;
                }
                case 3: {
                    this.handleUnstableBehavior();
                }
            }
            if (this.field_6012 % 20 == 0) {
                this.updateTrackedAspects();
            }
        }
    }

    public int getRenderColour() {
        return -5609899;
    }

    private void regenerateAspects() {
        float BASE_REGEN_RATE = 5.0E-5f;
        switch (this.getNodeType().ordinal()) {
            case 0: 
            case 1: {
                this.regenerateStandard(5.0E-5f);
                break;
            }
            case 2: {
                this.regenerateSinister(5.0E-5f);
                break;
            }
            case 3: {
                this.regenerateUnstable(5.0E-5f);
                break;
            }
            case 4: {
                this.regenerateHungry(5.0E-5f);
            }
        }
    }

    private void regenerateStandard(float baseRate) {
        for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
            this.regenerateAspect(entry.getKey(), entry.getValue(), baseRate);
        }
    }

    private void regenerateSinister(float baseRate) {
        for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
            float rate = baseRate;
            if (entry.getKey().equals((Object)VITIUM_ASPECT)) {
                rate *= 1.5f;
            }
            this.regenerateAspect(entry.getKey(), entry.getValue(), rate);
        }
        ++this.sinisterCounter;
        if (this.sinisterCounter >= 100) {
            AspectData currentBiomeAspects;
            this.sinisterCounter = 0;
            class_6880 biomeEntry = this.method_37908().method_23753(this.method_24515());
            class_2960 biomeId = biomeEntry.method_40230().map(class_5321::method_29177).orElse(null);
            if (biomeId != null && !(currentBiomeAspects = BiomeAspectRegistry.get(biomeId)).isEmpty()) {
                AspectData.Builder builder = new AspectData.Builder(currentBiomeAspects);
                builder.add(VITIUM_ASPECT, 10);
                BiomeAspectRegistry.update(biomeId, builder.build());
            }
        }
    }

    private void regenerateUnstable(float baseRate) {
        for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
            this.regenerateAspect(entry.getKey(), entry.getValue(), baseRate * 0.8f);
        }
    }

    private void regenerateHungry(float baseRate) {
        AspectState famesState = this.aspects.get(FAMES_ASPECT);
        if (famesState == null) {
            return;
        }
        if (famesState.current < famesState.original) {
            totalConsumed = 0.0f;
            ArrayList<class_2960> toRemove = new ArrayList<class_2960>();
            for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
                if (entry.getKey().equals((Object)FAMES_ASPECT)) continue;
                AspectState state = entry.getValue();
                if (state.current <= 0) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                float consumeAmount = (float)state.original * baseRate * 4.0f;
                float available = Math.min(consumeAmount, (float)state.current);
                state.current -= (int)available;
                totalConsumed += available;
                if (state.current > 0) continue;
                toRemove.add(entry.getKey());
            }
            if (totalConsumed > 0.0f) {
                famesState.current = (int)Math.min((float)famesState.original, (float)famesState.current + totalConsumed);
            }
            for (class_2960 id : toRemove) {
                this.aspects.remove(id);
            }
        } else {
            totalConsumed = 0.0f;
            ArrayList<class_2960> toRemove = new ArrayList<class_2960>();
            for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
                if (entry.getKey().equals((Object)FAMES_ASPECT)) continue;
                AspectState state = entry.getValue();
                if (state.current <= 0) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                float consumeAmount = (float)state.original * baseRate * 8.0f;
                float available = Math.min(consumeAmount, (float)state.current);
                state.current -= (int)available;
                totalConsumed += available;
                if (state.current > 0) continue;
                toRemove.add(entry.getKey());
            }
            if (totalConsumed > 0.0f) {
                famesState.original += (int)totalConsumed;
                famesState.current = famesState.original;
            }
            for (class_2960 id : toRemove) {
                this.aspects.remove(id);
            }
        }
        if (this.aspects.size() == 1 && this.aspects.containsKey(FAMES_ASPECT) && famesState.current >= famesState.original) {
            float consumeAmount = (float)famesState.original * baseRate * 2.0f;
            famesState.current = Math.max(0, famesState.current - (int)consumeAmount);
            if (famesState.current <= 0) {
                this.aspects.remove(FAMES_ASPECT);
            }
        }
    }

    private void regenerateAspect(class_2960 aspectId, AspectState state, float rate) {
        if (state.current >= state.original) {
            return;
        }
        float accumulator = this.regenAccumulators.getOrDefault(aspectId, Float.valueOf(0.0f)).floatValue();
        float regenThisTick = (float)state.original * rate;
        int toAdd = (int)(accumulator += regenThisTick);
        if (toAdd > 0) {
            int newCurrent = state.current + toAdd;
            if (newCurrent > state.original) {
                toAdd = state.original - state.current;
                newCurrent = state.original;
            }
            state.current = newCurrent;
            accumulator -= (float)toAdd;
            AspectsLib.LOGGER.debug("Regenerated {}: {}/{} (+{})", new Object[]{aspectId, state.current, state.original, toAdd});
        }
        this.regenAccumulators.put(aspectId, Float.valueOf(accumulator));
    }

    private void removeDrainedAspects() {
        ArrayList<class_2960> toRemove = new ArrayList<class_2960>();
        for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
            if (entry.getValue().current > 0) continue;
            toRemove.add(entry.getKey());
        }
        for (class_2960 id : toRemove) {
            this.aspects.remove(id);
        }
    }

    private void handleSinisterBehavior() {
        ++this.sinisterCounter;
        if (this.sinisterCounter >= 100) {
            this.sinisterCounter = 0;
            class_6880 biomeEntry = this.method_37908().method_23753(this.method_24515());
            class_2960 biomeId = biomeEntry.method_40230().map(class_5321::method_29177).orElse(null);
            if (biomeId != null) {
                BiomeAspectModifier.addBiomeModification(biomeId, VITIUM_ASPECT, 10);
                AspectsLib.LOGGER.debug("Sinister node corrupting biome {} at {}", (Object)biomeId, (Object)this.method_24515());
            }
        }
    }

    private void handleHungryBehavior() {
        ++this.hungerCounter;
        if (this.hungerCounter >= 200) {
            this.hungerCounter = 0;
            class_6880 biomeEntry = this.method_37908().method_23753(this.method_24515());
            class_2960 biomeId = biomeEntry.method_40230().map(class_5321::method_29177).orElse(null);
            if (this.aspects.size() > 1) {
                ArrayList<class_2960> nonFamesAspects = new ArrayList<class_2960>();
                for (class_2960 id : this.aspects.keySet()) {
                    if (id.equals((Object)FAMES_ASPECT)) continue;
                    nonFamesAspects.add(id);
                }
                if (!nonFamesAspects.isEmpty()) {
                    class_2960 target = (class_2960)nonFamesAspects.get(this.method_37908().method_8409().method_43048(nonFamesAspects.size()));
                    AspectState state = this.aspects.get(target);
                    int consumeAmount = Math.max(1, state.current / 10);
                    state.current -= consumeAmount;
                    if (state.current <= 0 && this.method_37908().method_8409().method_43057() < 0.1f) {
                        this.aspects.remove(target);
                    }
                }
            } else if (this.aspects.containsKey(FAMES_ASPECT) && biomeId != null) {
                AspectData currentBiomeAspects = BiomeAspectRegistry.get(biomeId);
                if (!currentBiomeAspects.isEmpty()) {
                    AspectData.Builder builder = new AspectData.Builder(AspectData.DEFAULT);
                    for (class_2960 aspectId : currentBiomeAspects.getAspectIds()) {
                        int currentAmount = currentBiomeAspects.getLevel(aspectId);
                        if (currentAmount <= 0) continue;
                        builder.add(aspectId, -Math.min(5, currentAmount));
                    }
                    AspectsLib.LOGGER.debug("Hungry node draining environment at {}", (Object)this.method_24515());
                }
                AspectState famesState = this.aspects.get(FAMES_ASPECT);
                if (famesState.current > 0) {
                    famesState.current = Math.max(0, famesState.current - 10);
                    if (famesState.current <= 0) {
                        this.method_31472();
                    }
                }
            }
        }
    }

    private void handleUnstableBehavior() {
        if (this.field_6012 % 100 == 0) {
            Object2IntOpenHashMap aspectMap = new Object2IntOpenHashMap();
            for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
                aspectMap.put((Object)entry.getKey(), entry.getValue().current);
            }
            ResonanceCalculator.ResonanceResult result = ResonanceCalculator.calculate(new AspectData((Object2IntOpenHashMap<class_2960>)aspectMap));
            if (result.barrierCost() > 0.0) {
                this.instabilityCounter += (int)Math.ceil(result.barrierCost());
                AspectsLib.LOGGER.debug("Unstable node instability: {}", (Object)this.instabilityCounter);
                if (this.instabilityCounter >= 100) {
                    this.method_37908().method_8537((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 3.0f, false, class_1937.class_7867.field_40888);
                    this.method_31472();
                }
            }
        }
    }

    private void updateTrackedAspects() {
        class_2487 aspectsNbt = new class_2487();
        for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
            class_2487 stateNbt = new class_2487();
            stateNbt.method_10569("Original", entry.getValue().original);
            stateNbt.method_10569("Current", entry.getValue().current);
            aspectsNbt.method_10566(entry.getKey().toString(), (class_2520)stateNbt);
        }
        this.field_6011.method_12778(ASPECTS_NBT, (Object)aspectsNbt);
    }

    public void method_5749(class_2487 nbt) {
        this.setNodeType(NodeType.values()[nbt.method_10571("NodeType")]);
        this.aspects.clear();
        class_2499 aspectsList = nbt.method_10554("Aspects", 10);
        for (class_2520 element : aspectsList) {
            class_2487 aspectNbt = (class_2487)element;
            class_2960 id = new class_2960(aspectNbt.method_10558("Id"));
            int original = aspectNbt.method_10550("Original");
            int current = aspectNbt.method_10550("Current");
            AspectState state = new AspectState(original);
            state.current = current;
            this.aspects.put(id, state);
        }
        this.instabilityCounter = nbt.method_10550("Instability");
        this.hungerCounter = nbt.method_10550("HungerCounter");
    }

    public void method_5652(class_2487 nbt) {
        nbt.method_10567("NodeType", (byte)this.getNodeType().ordinal());
        class_2499 aspectsList = new class_2499();
        for (Map.Entry<class_2960, AspectState> entry : this.aspects.entrySet()) {
            class_2487 aspectNbt = new class_2487();
            aspectNbt.method_10582("Id", entry.getKey().toString());
            aspectNbt.method_10569("Original", entry.getValue().original);
            aspectNbt.method_10569("Current", entry.getValue().current);
            aspectsList.add((Object)aspectNbt);
        }
        nbt.method_10566("Aspects", (class_2520)aspectsList);
        nbt.method_10569("Instability", this.instabilityCounter);
        nbt.method_10569("HungerCounter", this.hungerCounter);
    }

    protected void readCustomDataFromTrackedData() {
        this.setNodeType(NodeType.values()[(Integer)this.field_6011.method_12789(NODE_TYPE)]);
        class_2487 aspectsNbt = (class_2487)this.field_6011.method_12789(ASPECTS_NBT);
        this.aspects.clear();
        for (String key : aspectsNbt.method_10541()) {
            class_2960 id = new class_2960(key);
            class_2487 stateNbt = aspectsNbt.method_10562(key);
            int original = stateNbt.method_10550("Original");
            int current = stateNbt.method_10550("Current");
            this.aspects.put(id, new AspectState(original){
                {
                    this.current = this.current;
                }
            });
        }
    }

    public NodeType getNodeType() {
        return NodeType.values()[(Integer)this.field_6011.method_12789(NODE_TYPE)];
    }

    public void setNodeType(NodeType type) {
        this.field_6011.method_12778(NODE_TYPE, (Object)type.ordinal());
    }

    public Map<class_2960, AspectState> getAspects() {
        return Collections.unmodifiableMap(this.aspects);
    }

    public void setAspects(Map<class_2960, AspectState> aspects) {
        this.aspects = new HashMap<class_2960, AspectState>(aspects);
        this.updateTrackedAspects();
    }

    public void initializeAspects(class_5819 random) {
        this.aspects.clear();
        switch (this.getNodeType().ordinal()) {
            case 1: {
                class_2960 aspect = this.getRandomAspect(random, 0.95f);
                this.aspects.put(aspect, new AspectState(random.method_43048(100) + 50));
                break;
            }
            case 4: {
                this.aspects.put(FAMES_ASPECT, new AspectState(random.method_43048(100) + 50));
                if (!random.method_43056()) break;
                this.aspects.put(this.getRandomAspect(random, 0.9f), new AspectState(random.method_43048(100) + 50));
                break;
            }
            default: {
                int count = random.method_43048(4) + 1;
                for (int i = 0; i < count; ++i) {
                    class_2960 newAspect = this.getRandomAspect(random, 0.8f);
                    this.aspects.put(newAspect, new AspectState(random.method_43048(100) + 50));
                }
            }
        }
        this.updateTrackedAspects();
    }

    private class_2960 getRandomAspect(class_5819 random, float primalChance) {
        List<class_2960> primal = Arrays.asList(AspectsLib.identifier("aer"), AspectsLib.identifier("aqua"), AspectsLib.identifier("ignis"), AspectsLib.identifier("ordo"), AspectsLib.identifier("perditio"), AspectsLib.identifier("terra"));
        List<class_2960> secondary = Arrays.asList(AspectsLib.identifier("gelum"), AspectsLib.identifier("lux"), AspectsLib.identifier("metallum"), AspectsLib.identifier("mortuus"), AspectsLib.identifier("motus"), AspectsLib.identifier("permutatio"), AspectsLib.identifier("potentia"), AspectsLib.identifier("vacuos"), AspectsLib.identifier("victus"), AspectsLib.identifier("vitreus"));
        List<class_2960> tertiary = Arrays.asList(AspectsLib.identifier("bestia"), AspectsLib.identifier("fames"), AspectsLib.identifier("exanimis"), AspectsLib.identifier("herba"), AspectsLib.identifier("instrumentum"), AspectsLib.identifier("praecantatio"), AspectsLib.identifier("spiritus"), AspectsLib.identifier("tenebrae"), AspectsLib.identifier("vinculum"), AspectsLib.identifier("volatus"));
        List<class_2960> quaternary = Arrays.asList(AspectsLib.identifier("alienis"), AspectsLib.identifier("alkimia"), AspectsLib.identifier("auram"), AspectsLib.identifier("aversion"), AspectsLib.identifier("cognitio"), AspectsLib.identifier("desiderium"), AspectsLib.identifier("fabrico"), AspectsLib.identifier("humanus"), AspectsLib.identifier("machina"), AspectsLib.identifier("praemunio"), AspectsLib.identifier("sensus"), AspectsLib.identifier("vitium"));
        if (random.method_43057() < primalChance && !primal.isEmpty()) {
            return primal.get(random.method_43048(primal.size()));
        }
        float roll = random.method_43057();
        if (roll < 0.6f && !secondary.isEmpty()) {
            return secondary.get(random.method_43048(secondary.size()));
        }
        if (roll < 0.9f && !tertiary.isEmpty()) {
            return tertiary.get(random.method_43048(tertiary.size()));
        }
        if (!quaternary.isEmpty()) {
            return quaternary.get(random.method_43048(quaternary.size()));
        }
        return !primal.isEmpty() ? primal.get(random.method_43048(primal.size())) : AspectsLib.identifier("aer");
    }

    public boolean method_5862() {
        return false;
    }

    public static enum NodeType {
        NORMAL,
        PURE,
        SINISTER,
        UNSTABLE,
        HUNGRY;

    }

    public static class AspectState {
        public int original;
        public int current;

        public AspectState(int original) {
            this.original = original;
            this.current = original;
        }

        public void regen(float amount) {
            if (this.current < this.original) {
                this.current = Math.min(this.original, this.current + (int)((float)this.original * amount));
            }
        }
    }
}

