/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.networking;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.data.Aspect;
import dev.overgrown.aspectslib.data.AspectManager;
import dev.overgrown.aspectslib.data.ModRegistries;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class SyncAspectIdentifierPacket {
    public static final class_2960 ID = AspectsLib.identifier("sync_aspect_packet");

    public static void writeNameMap(class_2540 buf, Map<String, class_2960> nameMap) {
        buf.writeInt(nameMap.size());
        for (Map.Entry<String, class_2960> entry : nameMap.entrySet()) {
            buf.method_10814(entry.getKey());
            buf.method_10812(entry.getValue());
        }
    }

    public static void writeAspectData(class_2540 buf, Map<class_2960, Aspect> aspectMap) {
        buf.writeInt(aspectMap.size());
        for (Map.Entry<class_2960, Aspect> entry : aspectMap.entrySet()) {
            buf.method_10812(entry.getKey());
            Aspect.PACKET_CODEC.encode(buf, entry.getValue());
        }
    }

    public static void writeFullData(class_2540 buf, Map<String, class_2960> nameMap, Map<class_2960, Aspect> aspectMap) {
        SyncAspectIdentifierPacket.writeNameMap(buf, nameMap);
        SyncAspectIdentifierPacket.writeAspectData(buf, aspectMap);
    }

    public static Map<String, class_2960> readNameMap(class_2540 buf) {
        int size = buf.readInt();
        HashMap<String, class_2960> map = new HashMap<String, class_2960>();
        for (int i = 0; i < size; ++i) {
            String key = buf.method_19772();
            class_2960 value = buf.method_10810();
            map.put(key, value);
        }
        return map;
    }

    public static Map<class_2960, Aspect> readAspectData(class_2540 buf) {
        int size = buf.readInt();
        HashMap<class_2960, Aspect> map = new HashMap<class_2960, Aspect>();
        for (int i = 0; i < size; ++i) {
            class_2960 id = buf.method_10810();
            Aspect aspect = Aspect.PACKET_CODEC.decode(buf);
            map.put(id, aspect);
        }
        return map;
    }

    public static void sendFullData(class_3222 player, Map<String, class_2960> nameMap, Map<class_2960, Aspect> aspectMap) {
        class_2540 buf = PacketByteBufs.create();
        SyncAspectIdentifierPacket.writeFullData(buf, nameMap, aspectMap);
        ServerPlayNetworking.send((class_3222)player, (class_2960)ID, (class_2540)buf);
    }

    public static void sendAllData(class_3222 player) {
        AspectsLib.LOGGER.debug("Sending {} aspects and {} name mappings to client", (Object)ModRegistries.ASPECTS.size(), (Object)AspectManager.NAME_TO_ID.size());
        SyncAspectIdentifierPacket.sendFullData(player, AspectManager.NAME_TO_ID, ModRegistries.ASPECTS);
    }
}

