/*
 * Decompiled with CFR 0.152.
 */
package dev.overgrown.aspectslib.recipe;

import dev.overgrown.aspectslib.AspectsLib;
import dev.overgrown.aspectslib.data.AspectData;
import dev.overgrown.aspectslib.data.BlockAspectRegistry;
import dev.overgrown.aspectslib.data.ItemAspectRegistry;
import dev.overgrown.aspectslib.recipe.RecipeAspectConfig;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1874;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3920;
import net.minecraft.class_3956;
import net.minecraft.class_3975;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class RecipeAspectCalculator {
    private final RecipeAspectConfig config;
    private final MinecraftServer server;
    private final class_1863 recipeManager;
    private final Map<class_2960, AspectData> calculatedAspects = new ConcurrentHashMap<class_2960, AspectData>();
    private final Map<class_2960, RecipeNode> recipeGraph = new ConcurrentHashMap<class_2960, RecipeNode>();
    private final Set<class_2960> baseItems = ConcurrentHashMap.newKeySet();
    private final Set<class_2960> processingItems = ConcurrentHashMap.newKeySet();
    private final Map<class_2960, Integer> itemDepths = new ConcurrentHashMap<class_2960, Integer>();

    public RecipeAspectCalculator(MinecraftServer server) {
        this.config = RecipeAspectConfig.getInstance();
        this.server = server;
        this.recipeManager = server.method_3772();
    }

    public void calculateAllAspects() {
        long startTime = System.currentTimeMillis();
        AspectsLib.LOGGER.info("Starting recipe-based aspect calculation...");
        this.clearCalculatedData();
        this.identifyBaseItems();
        this.buildRecipeGraph();
        this.detectAndBreakCycles();
        this.calculateDepths();
        this.propagateAspects();
        this.applyCalculatedAspects();
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        String message = String.format("Recipe aspect calculation completed in %d ms. Processed %d items, %d recipes.", duration, this.calculatedAspects.size(), this.recipeGraph.size());
        AspectsLib.LOGGER.info(message);
        for (class_3222 player : this.server.method_3760().method_14571()) {
            player.method_7353((class_2561)class_2561.method_43470((String)("\u00a7a[AspectsLib] " + message)), false);
        }
    }

    private void clearCalculatedData() {
        this.calculatedAspects.clear();
        this.recipeGraph.clear();
        this.baseItems.clear();
        this.processingItems.clear();
        this.itemDepths.clear();
    }

    private void identifyBaseItems() {
        int checked = 0;
        for (class_1792 item : class_7923.field_41178) {
            class_1747 blockItem;
            class_2248 block;
            class_2960 blockId;
            AspectData blockAspects;
            if (item == class_1802.field_8162) continue;
            class_2960 itemId = class_7923.field_41178.method_10221((Object)item);
            AspectData existingAspects = ItemAspectRegistry.get(itemId);
            if ((existingAspects == null || existingAspects.isEmpty()) && item instanceof class_1747 && (blockAspects = BlockAspectRegistry.get(blockId = class_7923.field_41175.method_10221((Object)(block = (blockItem = (class_1747)item).method_7711())))) != null && !blockAspects.isEmpty()) {
                existingAspects = blockAspects;
            }
            ++checked;
            if (existingAspects == null || existingAspects.isEmpty()) continue;
            this.baseItems.add(itemId);
            this.calculatedAspects.put(itemId, existingAspects);
        }
        AspectsLib.LOGGER.info("Identified {} base items with predefined aspects out of {} checked", (Object)this.baseItems.size(), (Object)checked);
    }

    private void buildRecipeGraph() {
        Collection allRecipes = this.recipeManager.method_8126();
        for (class_1860 recipe : allRecipes) {
            if (!this.isValidRecipe(recipe)) continue;
            try {
                class_1799 output = recipe.method_8110((class_5455)this.server.method_30611());
                if (output == null || output.method_7960()) continue;
                class_2960 outputId = class_7923.field_41178.method_10221((Object)output.method_7909());
                RecipeNode node = this.recipeGraph.computeIfAbsent(outputId, RecipeNode::new);
                ArrayList<class_2960> ingredientIds = new ArrayList<class_2960>();
                HashMap<class_2960, Integer> ingredientCounts = new HashMap<class_2960, Integer>();
                if (recipe instanceof class_1869) {
                    class_1869 shaped = (class_1869)recipe;
                    this.extractIngredientsFromShaped(shaped, ingredientIds, ingredientCounts);
                } else if (recipe instanceof class_1867) {
                    class_1867 shapeless = (class_1867)recipe;
                    this.extractIngredientsFromShapeless(shapeless, ingredientIds, ingredientCounts);
                } else if (recipe instanceof class_3861 || recipe instanceof class_3859 || recipe instanceof class_3862 || recipe instanceof class_3920) {
                    this.extractIngredientsFromCooking(recipe, ingredientIds, ingredientCounts);
                } else if (recipe instanceof class_3975) {
                    class_3975 stonecutting = (class_3975)recipe;
                    this.extractIngredientsFromStonecutting(stonecutting, ingredientIds, ingredientCounts);
                }
                if (ingredientIds.isEmpty()) continue;
                RecipeEntry entry = new RecipeEntry(recipe, ingredientIds, ingredientCounts, output.method_7947());
                node.recipes.add(entry);
                for (class_2960 ingredientId : ingredientIds) {
                    node.dependencies.add(ingredientId);
                    RecipeNode ingredientNode = this.recipeGraph.computeIfAbsent(ingredientId, RecipeNode::new);
                    ingredientNode.dependents.add(outputId);
                }
            }
            catch (Exception e) {
                AspectsLib.LOGGER.debug("Error processing recipe {}: {}", (Object)recipe.method_8114(), (Object)e.getMessage());
            }
        }
        AspectsLib.LOGGER.info("Built recipe graph with {} nodes", (Object)this.recipeGraph.size());
    }

    private boolean isValidRecipe(class_1860<?> recipe) {
        return recipe instanceof class_1869 || recipe instanceof class_1867 || recipe instanceof class_3861 || recipe instanceof class_3859 || recipe instanceof class_3862 || recipe instanceof class_3920 || recipe instanceof class_3975;
    }

    private void extractIngredientsFromShaped(class_1869 recipe, List<class_2960> ids, Map<class_2960, Integer> counts) {
        for (class_1856 ingredient : recipe.method_8117()) {
            this.extractIngredient(ingredient, ids, counts);
        }
    }

    private void extractIngredientsFromShapeless(class_1867 recipe, List<class_2960> ids, Map<class_2960, Integer> counts) {
        for (class_1856 ingredient : recipe.method_8117()) {
            this.extractIngredient(ingredient, ids, counts);
        }
    }

    private void extractIngredientsFromCooking(class_1860<?> recipe, List<class_2960> ids, Map<class_2960, Integer> counts) {
        if (recipe instanceof class_1874) {
            class_1874 cooking = (class_1874)recipe;
            this.extractIngredient((class_1856)cooking.method_8117().get(0), ids, counts);
        }
    }

    private void extractIngredientsFromStonecutting(class_3975 recipe, List<class_2960> ids, Map<class_2960, Integer> counts) {
        this.extractIngredient((class_1856)recipe.method_8117().get(0), ids, counts);
    }

    private void extractIngredient(class_1856 ingredient, List<class_2960> ids, Map<class_2960, Integer> counts) {
        if (ingredient == null || ingredient.method_8103()) {
            return;
        }
        class_1799[] stacks = ingredient.method_8105();
        if (stacks.length == 0) {
            return;
        }
        class_2960 bestItemId = null;
        double lowestAspectValue = Double.MAX_VALUE;
        boolean hasAnyAspects = false;
        for (class_1799 stack : stacks) {
            if (stack == null || stack.method_7960()) continue;
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            AspectData existingAspects = this.getItemAspects(itemId);
            if (existingAspects != null && !existingAspects.isEmpty()) {
                hasAnyAspects = true;
                double totalValue = existingAspects.calculateTotalRU();
                if (!(totalValue < lowestAspectValue)) continue;
                lowestAspectValue = totalValue;
                bestItemId = itemId;
                continue;
            }
            if (hasAnyAspects || bestItemId != null) continue;
            bestItemId = itemId;
        }
        if (bestItemId != null) {
            ids.add(bestItemId);
            counts.merge(bestItemId, 1, Integer::sum);
        } else if (stacks.length > 0 && stacks[0] != null && !stacks[0].method_7960()) {
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stacks[0].method_7909());
            ids.add(itemId);
            counts.merge(itemId, 1, Integer::sum);
        }
    }

    private AspectData getItemAspects(class_2960 itemId) {
        class_1747 blockItem;
        class_2248 block;
        class_2960 blockId;
        AspectData blockAspects;
        AspectData cached = this.calculatedAspects.get(itemId);
        if (cached != null) {
            return cached;
        }
        AspectData registryAspects = ItemAspectRegistry.get(itemId);
        if (registryAspects != null && !registryAspects.isEmpty()) {
            return registryAspects;
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
        if (item instanceof class_1747 && (blockAspects = BlockAspectRegistry.get(blockId = class_7923.field_41175.method_10221((Object)(block = (blockItem = (class_1747)item).method_7711())))) != null && !blockAspects.isEmpty()) {
            return blockAspects;
        }
        return AspectData.DEFAULT;
    }

    private void detectAndBreakCycles() {
        HashSet<class_2960> visited = new HashSet<class_2960>();
        HashSet<class_2960> recursionStack = new HashSet<class_2960>();
        ArrayList<List<class_2960>> cycles = new ArrayList<List<class_2960>>();
        for (class_2960 class_29602 : this.recipeGraph.keySet()) {
            if (visited.contains(class_29602)) continue;
            this.detectCyclesDFS(class_29602, visited, recursionStack, new ArrayList<class_2960>(), cycles);
        }
        if (!cycles.isEmpty()) {
            AspectsLib.LOGGER.info("Detected {} cycles in recipe graph", (Object)cycles.size());
            for (List list : cycles) {
                this.breakCycle(list);
            }
        }
    }

    private boolean detectCyclesDFS(class_2960 nodeId, Set<class_2960> visited, Set<class_2960> recursionStack, List<class_2960> path, List<List<class_2960>> cycles) {
        visited.add(nodeId);
        recursionStack.add(nodeId);
        path.add(nodeId);
        RecipeNode node = this.recipeGraph.get(nodeId);
        if (node != null) {
            for (class_2960 dependent : node.dependents) {
                int cycleStart;
                if (!visited.contains(dependent)) {
                    if (!this.detectCyclesDFS(dependent, visited, recursionStack, path, cycles)) continue;
                    return true;
                }
                if (!recursionStack.contains(dependent) || (cycleStart = path.indexOf(dependent)) == -1) continue;
                ArrayList<class_2960> cycle = new ArrayList<class_2960>(path.subList(cycleStart, path.size()));
                cycles.add(cycle);
            }
        }
        path.remove(path.size() - 1);
        recursionStack.remove(nodeId);
        return false;
    }

    private void breakCycle(List<class_2960> cycle) {
        RecipeNode node;
        class_2960 weakestLink = null;
        int minBaseDistance = Integer.MAX_VALUE;
        for (class_2960 itemId : cycle) {
            int distance = this.calculateDistanceToBase(itemId, new HashSet<class_2960>());
            if (distance >= minBaseDistance) continue;
            minBaseDistance = distance;
            weakestLink = itemId;
        }
        if (weakestLink != null && (node = this.recipeGraph.get(weakestLink)) != null) {
            node.recipes.clear();
            node.dependencies.clear();
            AspectsLib.LOGGER.debug("Broke cycle at item: {}", (Object)weakestLink);
        }
    }

    private int calculateDistanceToBase(class_2960 itemId, Set<class_2960> visited) {
        if (this.baseItems.contains(itemId)) {
            return 0;
        }
        if (visited.contains(itemId)) {
            return Integer.MAX_VALUE;
        }
        visited.add(itemId);
        RecipeNode node = this.recipeGraph.get(itemId);
        if (node == null || node.dependencies.isEmpty()) {
            return Integer.MAX_VALUE;
        }
        int minDistance = Integer.MAX_VALUE;
        for (class_2960 dep : node.dependencies) {
            int distance = this.calculateDistanceToBase(dep, new HashSet<class_2960>(visited));
            if (distance == Integer.MAX_VALUE) continue;
            minDistance = Math.min(minDistance, distance + 1);
        }
        return minDistance;
    }

    private void calculateDepths() {
        LinkedList<class_2960> queue = new LinkedList<class_2960>(this.baseItems);
        for (class_2960 baseItem : this.baseItems) {
            this.itemDepths.put(baseItem, 0);
        }
        while (!queue.isEmpty()) {
            class_2960 current = (class_2960)queue.poll();
            RecipeNode node = this.recipeGraph.get(current);
            if (node == null) continue;
            int currentDepth = this.itemDepths.getOrDefault(current, 0);
            for (class_2960 dependent : node.dependents) {
                int newDepth = currentDepth + 1;
                Integer existingDepth = this.itemDepths.get(dependent);
                if (existingDepth != null && newDepth >= existingDepth) continue;
                this.itemDepths.put(dependent, newDepth);
                if (newDepth >= this.config.getMaxDepth()) continue;
                queue.offer(dependent);
            }
        }
    }

    private void propagateAspects() {
        HashMap<Integer, List> itemsByDepth = new HashMap<Integer, List>();
        for (Map.Entry<class_2960, Integer> entry : this.itemDepths.entrySet()) {
            itemsByDepth.computeIfAbsent(entry.getValue(), k -> new ArrayList()).add(entry.getKey());
        }
        ArrayList sortedDepths = new ArrayList(itemsByDepth.keySet());
        Collections.sort(sortedDepths);
        AtomicInteger processedCount = new AtomicInteger(0);
        int totalItems = this.recipeGraph.size();
        for (Integer depth : sortedDepths) {
            List itemsAtDepth = (List)itemsByDepth.get(depth);
            for (class_2960 itemId : itemsAtDepth) {
                if (this.baseItems.contains(itemId)) continue;
                this.calculateItemAspects(itemId);
                int count = processedCount.incrementAndGet();
                if (count % 100 != 0) continue;
                AspectsLib.LOGGER.debug("Processed {}/{} items", (Object)count, (Object)totalItems);
            }
        }
        for (class_2960 itemId : this.recipeGraph.keySet()) {
            if (this.calculatedAspects.containsKey(itemId)) continue;
            this.calculateItemAspects(itemId);
        }
    }

    private synchronized AspectData calculateItemAspects(class_2960 itemId) {
        AspectData existing = this.calculatedAspects.get(itemId);
        if (existing != null) {
            return existing;
        }
        if (this.processingItems.contains(itemId)) {
            return AspectData.DEFAULT;
        }
        this.processingItems.add(itemId);
        RecipeNode node = this.recipeGraph.get(itemId);
        if (node == null || node.recipes.isEmpty()) {
            this.processingItems.remove(itemId);
            return AspectData.DEFAULT;
        }
        AspectData bestAspects = null;
        double bestValue = Double.MAX_VALUE;
        RecipeEntry bestRecipe = null;
        for (RecipeEntry recipeEntry : node.recipes) {
            AspectData recipeAspects = this.calculateRecipeAspects(recipeEntry);
            if (recipeAspects == null || recipeAspects.isEmpty()) continue;
            double totalValue = recipeAspects.calculateTotalRU();
            if (bestAspects != null && !(totalValue < bestValue)) continue;
            bestAspects = recipeAspects;
            bestValue = totalValue;
            bestRecipe = recipeEntry;
        }
        if (bestAspects != null) {
            this.calculatedAspects.put(itemId, bestAspects);
            node.cachedAspects = bestAspects;
        }
        this.processingItems.remove(itemId);
        return bestAspects != null ? bestAspects : AspectData.DEFAULT;
    }

    private AspectData calculateRecipeAspects(RecipeEntry recipeEntry) {
        Object2IntOpenHashMap combinedAspects = new Object2IntOpenHashMap();
        for (Map.Entry<class_2960, Integer> ingredient : recipeEntry.ingredientCounts.entrySet()) {
            class_2960 ingredientId = ingredient.getKey();
            int count = ingredient.getValue();
            AspectData ingredientAspects = this.calculatedAspects.get(ingredientId);
            if (ingredientAspects == null) {
                ingredientAspects = this.getItemAspects(ingredientId);
            }
            if (ingredientAspects == null || ingredientAspects.isEmpty()) continue;
            for (Map.Entry aspectEntry : ingredientAspects.getMap().entrySet()) {
                int totalAmount = (Integer)aspectEntry.getValue() * count;
                combinedAspects.merge((Object)((class_2960)aspectEntry.getKey()), totalAmount, Integer::sum);
            }
        }
        if (combinedAspects.isEmpty()) {
            return AspectData.DEFAULT;
        }
        double lossFactor = recipeEntry.type == class_3956.field_17545 ? this.config.getCraftingLoss() : (recipeEntry.type == class_3956.field_17546 || recipeEntry.type == class_3956.field_17547 || recipeEntry.type == class_3956.field_17548 || recipeEntry.type == class_3956.field_17549 ? this.config.getSmeltingLoss() : (recipeEntry.type == class_3956.field_25388 ? this.config.getSmithingLoss() : (recipeEntry.type == class_3956.field_17641 ? this.config.getStonecuttingLoss() : this.config.getCraftingLoss())));
        for (class_2960 aspectId : combinedAspects.keySet()) {
            int originalValue = combinedAspects.getInt((Object)aspectId);
            double calculation = (double)originalValue * lossFactor / (double)recipeEntry.outputCount;
            int adjustedValue = (int)Math.ceil(calculation);
            int finalValue = Math.max(1, adjustedValue);
            combinedAspects.put((Object)aspectId, finalValue);
        }
        return new AspectData((Object2IntOpenHashMap<class_2960>)combinedAspects);
    }

    private void applyCalculatedAspects() {
        int updated = 0;
        for (Map.Entry<class_2960, AspectData> entry : this.calculatedAspects.entrySet()) {
            class_1792 class_17922;
            class_2960 itemId = entry.getKey();
            AspectData aspects = entry.getValue();
            if (this.baseItems.contains(itemId) || aspects == null || aspects.isEmpty()) continue;
            ItemAspectRegistry.update(itemId, aspects);
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemId);
            if (item != null && (class_17922 = item.method_7854().method_7909()) instanceof class_1747) {
                class_1747 blockItem = (class_1747)class_17922;
                class_2248 block = blockItem.method_7711();
                class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
                BlockAspectRegistry.update(blockId, aspects);
            }
            ++updated;
        }
        AspectsLib.LOGGER.info("Applied calculated aspects to {} items", (Object)updated);
    }

    private static class RecipeNode {
        final class_2960 itemId;
        final Set<RecipeEntry> recipes = ConcurrentHashMap.newKeySet();
        final Set<class_2960> dependencies = ConcurrentHashMap.newKeySet();
        final Set<class_2960> dependents = ConcurrentHashMap.newKeySet();
        volatile AspectData cachedAspects = null;
        volatile boolean isProcessing = false;
        volatile boolean isProcessed = false;
        volatile int depth = 0;

        RecipeNode(class_2960 itemId) {
            this.itemId = itemId;
        }
    }

    private static class RecipeEntry {
        final class_1860<?> recipe;
        final List<class_2960> ingredients;
        final Map<class_2960, Integer> ingredientCounts;
        final int outputCount;
        final class_3956<?> type;

        RecipeEntry(class_1860<?> recipe, List<class_2960> ingredients, Map<class_2960, Integer> counts, int outputCount) {
            this.recipe = recipe;
            this.ingredients = ingredients;
            this.ingredientCounts = counts;
            this.outputCount = outputCount;
            this.type = recipe.method_17716();
        }
    }
}

