/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.widget;

import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.text.ModText;
import dev.nymnux.rhizome.util.render.HudRenderUtil;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.jetbrains.annotations.Nullable;

public class ModColorSlider
extends class_339 {
    private static final class_2960 ALPHA_GRID = class_2960.method_60655((String)"rhizome", (String)"textures/gui/alpha_grid.png");
    private double sldH;
    private double sldS;
    private double sldB;
    private double sldA;
    private final Consumer<Integer> apply;
    private final int defaultColor;
    private int focusedSlider = -1;

    public ModColorSlider(int width, int color2, Consumer<Integer> apply, int defaultColor) {
        this(width, color2, apply, defaultColor, (class_2561)null);
    }

    public ModColorSlider(int width, int color2, Consumer<Integer> apply, int defaultColor, ModText message2) {
        this(width, color2, apply, defaultColor, message2.getText());
    }

    public ModColorSlider(int width, int color2, Consumer<Integer> apply, int defaultColor, @Nullable class_2561 message2) {
        super(0, 0, Math.max(width, 67), 33, (class_2561)class_2561.method_43473());
        this.parseRGBA(color2);
        this.apply = apply;
        this.defaultColor = defaultColor;
        if (message2 != null) {
            this.method_47400(class_7919.method_47407((class_2561)message2));
        }
    }

    private void setValueFromMouse(int sliderIndex, double mouseX) {
        if (sliderIndex == -1) {
            return;
        }
        double value = (mouseX - (double)this.method_46426() - 34.0 - 2.0) / (double)(this.method_25368() - 34 - 4 - 2);
        value = class_3532.method_15350((double)value, (double)0.0, (double)1.0);
        switch (sliderIndex) {
            case 0: {
                this.sldH = value;
                break;
            }
            case 1: {
                this.sldS = value;
                break;
            }
            case 2: {
                this.sldB = value;
                break;
            }
            case 3: {
                this.sldA = value;
            }
        }
        this.apply.accept(this.getRGBA());
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (!this.field_22763 || !this.field_22764) {
            return false;
        }
        switch (button) {
            case 0: {
                this.focusedSlider = this.getHoveredSlider(mouseX, mouseY);
                this.setValueFromMouse(this.focusedSlider, mouseX);
                if (this.isSquareButtonHovered(mouseX, mouseY)) {
                    this.parseRGBA(-11910870);
                    this.apply.accept(-11910870);
                    ModScreen.playModButtonDownSound();
                }
                return true;
            }
            case 2: {
                this.parseRGBA(this.defaultColor);
                this.apply.accept(this.defaultColor);
                ModScreen.playModButtonDownSound();
                return true;
            }
        }
        return false;
    }

    protected void method_25349(double mouseX, double mouseY, double deltaX, double deltaY) {
        this.setValueFromMouse(this.focusedSlider, mouseX);
    }

    public void method_25357(double mouseX, double mouseY) {
        if (this.focusedSlider == -1) {
            return;
        }
        ModScreen.playModButtonDownSound();
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        context.method_25290(class_10799.field_56883, ALPHA_GRID, this.method_46426(), this.method_46427(), 0.0f, 0.0f, 33, 33, 2, 2);
        int sliderX = this.method_46426() + 34;
        int sliderHY = this.method_46427() + 1;
        int sliderSY = this.method_46427() + 9;
        int sliderBY = this.method_46427() + 17;
        int sliderAY = this.method_46427() + 25;
        int sliderWidth = this.method_25368() - 34;
        int gradiantStartX = sliderX + 2;
        int gradiantWidth = sliderWidth - 3 - 2;
        int colorHL = 0;
        int colorHR = 0;
        for (int i = 0; i < gradiantWidth; ++i) {
            int rgb = Color.HSBtoRGB((float)i / (float)gradiantWidth, 0.6666667f, 1.0f);
            HudRenderUtil.fill(context, gradiantStartX + i, sliderHY, 1, 7, rgb);
            if (i == 0) {
                colorHL = rgb;
            }
            if (i != gradiantWidth - 1) continue;
            colorHR = rgb;
        }
        HudRenderUtil.fill(context, sliderX, sliderHY, 2, 7, colorHL);
        HudRenderUtil.fill(context, sliderX + sliderWidth - 3, sliderHY, 3, 7, colorHR);
        int colorSL = 0;
        int colorSR = 0;
        for (int i = 0; i < gradiantWidth; ++i) {
            int rgb = Color.HSBtoRGB((float)this.sldH, (float)i / (float)gradiantWidth, (float)this.sldB);
            HudRenderUtil.fill(context, gradiantStartX + i, sliderSY, 1, 7, rgb);
            if (i == 0) {
                colorSL = rgb;
            }
            if (i != gradiantWidth - 1) continue;
            colorSR = rgb;
        }
        HudRenderUtil.fill(context, sliderX, sliderSY, 2, 7, colorSL);
        HudRenderUtil.fill(context, sliderX + sliderWidth - 3, sliderSY, 3, 7, colorSR);
        int colorBL = 0;
        int colorBR = 0;
        for (int i = 0; i < gradiantWidth; ++i) {
            int rgb = Color.HSBtoRGB((float)this.sldH, (float)this.sldS, (float)i / (float)gradiantWidth);
            HudRenderUtil.fill(context, gradiantStartX + i, sliderBY, 1, 7, rgb);
            if (i == 0) {
                colorBL = rgb;
            }
            if (i != gradiantWidth - 1) continue;
            colorBR = rgb;
        }
        HudRenderUtil.fill(context, sliderX, sliderBY, 2, 7, colorBL);
        HudRenderUtil.fill(context, sliderX + sliderWidth - 3, sliderBY, 3, 7, colorBR);
        int sliderColor = -2013265920;
        int sliderColorHovered = -2000830785;
        HudRenderUtil.fill(context, sliderX, sliderAY, sliderWidth, 7, this.getHoveredSlider(mouseX, mouseY) == 3 ? sliderColorHovered : sliderColor);
        int hX = (int)((double)(this.method_46426() + 34) + this.sldH * (double)(this.method_25368() - 34 - 4 - 2));
        int sX = (int)((double)(this.method_46426() + 34) + this.sldS * (double)(this.method_25368() - 34 - 4 - 2));
        int bX = (int)((double)(this.method_46426() + 34) + this.sldB * (double)(this.method_25368() - 34 - 4 - 2));
        int aX = (int)((double)(this.method_46426() + 34) + this.sldA * (double)(this.method_25368() - 34 - 4 - 2));
        int handleColor = -1;
        HudRenderUtil.fill(context, hX, this.method_46427() + 1, 6, 8, handleColor);
        HudRenderUtil.fill(context, sX, this.method_46427() + 9, 6, 8, handleColor);
        HudRenderUtil.fill(context, bX, this.method_46427() + 17, 6, 8, handleColor);
        HudRenderUtil.fill(context, aX, this.method_46427() + 25, 6, 8, handleColor);
        HudRenderUtil.fill(context, this.method_46426(), this.method_46427(), 33, 33, this.getRGBA());
    }

    protected void method_47399(class_6382 builder) {
        this.method_37021(builder);
    }

    private boolean isSquareButtonHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + 33) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + 33);
    }

    private int getHoveredSlider(double mouseX, double mouseY) {
        if (mouseX < (double)(this.method_46426() + 34) || mouseX >= (double)this.method_55442()) {
            return -1;
        }
        if (mouseY >= (double)(this.method_46427() + 1) && mouseY < (double)(this.method_46427() + 8)) {
            return 0;
        }
        if (mouseY >= (double)(this.method_46427() + 9) && mouseY < (double)(this.method_46427() + 16)) {
            return 1;
        }
        if (mouseY >= (double)(this.method_46427() + 17) && mouseY < (double)(this.method_46427() + 24)) {
            return 2;
        }
        if (mouseY >= (double)(this.method_46427() + 25) && mouseY < (double)(this.method_46427() + 32)) {
            return 3;
        }
        return -1;
    }

    private int getRGBA() {
        int v = Color.HSBtoRGB((float)this.sldH, (float)this.sldS, (float)this.sldB);
        int a = (int)(this.sldA * 255.0);
        return a << 24 | v & 0xFFFFFF;
    }

    private void parseRGBA(int rgba) {
        Color v = new Color(rgba, true);
        this.sldA = (float)v.getAlpha() / 255.0f;
        float[] hsb = Color.RGBtoHSB(v.getRed(), v.getGreen(), v.getBlue(), null);
        this.sldH = hsb[0];
        this.sldS = hsb[1];
        this.sldB = hsb[2];
    }
}

