/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.event;

import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.ClientTask;
import dev.nymnux.rhizome.module.event.EventClock;
import dev.nymnux.rhizome.module.event.ScheduledTask;
import java.util.ArrayList;
import java.util.List;

public class Scheduler
implements ModModule {
    private final List<ScheduledTask> scheduledTasksStart = new ArrayList<ScheduledTask>();
    private final List<ScheduledTask> scheduledTasksEnd = new ArrayList<ScheduledTask>();
    private final List<EventClock> eventClocksStart = new ArrayList<EventClock>();
    private final List<EventClock> eventClocksEnd = new ArrayList<EventClock>();
    private final List<ScheduledTask> scheduledTasksStartToAdd = new ArrayList<ScheduledTask>();
    private final List<ScheduledTask> scheduledTasksEndToAdd = new ArrayList<ScheduledTask>();
    private final List<EventClock> eventClocksStartToAdd = new ArrayList<EventClock>();
    private final List<EventClock> eventClocksEndToAdd = new ArrayList<EventClock>();

    public void addScheduledTaskStart(ModModule owner, int delay, ClientTask task) {
        this.addScheduledTaskStart(new ScheduledTask(owner, delay, task));
    }

    public void addScheduledTaskStart(ScheduledTask scheduledTask) {
        if (this.scheduledTasksStart.contains(scheduledTask) || this.scheduledTasksStartToAdd.contains(scheduledTask)) {
            return;
        }
        this.scheduledTasksStartToAdd.add(scheduledTask);
    }

    public void removeScheduledTaskStart(ScheduledTask scheduledTask) {
        this.scheduledTasksStart.remove(scheduledTask);
    }

    public void clearScheduledTasksStart(ModModule owner) {
        this.scheduledTasksStart.removeIf(scheduledTask -> scheduledTask.owner == owner);
    }

    public void addEventClockStart(ModModule owner, int interval, int life, ClientTask task) {
        this.addEventClockStart(new EventClock(owner, interval, life, task));
    }

    public void addEventClockStart(EventClock eventClock) {
        if (this.eventClocksStart.contains(eventClock) || this.eventClocksStartToAdd.contains(eventClock)) {
            return;
        }
        this.eventClocksStartToAdd.add(eventClock);
    }

    public void removeEventClockStart(EventClock eventClock) {
        this.eventClocksStart.remove(eventClock);
    }

    public void clearEventClocksStart(ModModule owner) {
        this.eventClocksStart.removeIf(eventClock -> eventClock.owner == owner);
    }

    public void addScheduledTaskEnd(ModModule owner, int delay, ClientTask task) {
        this.addScheduledTaskEnd(new ScheduledTask(owner, delay, task));
    }

    public void addScheduledTaskEnd(ScheduledTask scheduledTask) {
        if (this.scheduledTasksEnd.contains(scheduledTask) || this.scheduledTasksEndToAdd.contains(scheduledTask)) {
            return;
        }
        this.scheduledTasksEndToAdd.add(scheduledTask);
    }

    public void removeScheduledTaskEnd(ScheduledTask scheduledTask) {
        this.scheduledTasksEnd.remove(scheduledTask);
    }

    public void clearScheduledTasksEnd(ModModule owner) {
        this.scheduledTasksEnd.removeIf(scheduledTask -> scheduledTask.owner == owner);
    }

    public void addEventClockEnd(ModModule owner, int interval, int life, ClientTask task) {
        this.addEventClockEnd(new EventClock(owner, interval, life, task));
    }

    public void addEventClockEnd(EventClock eventClock) {
        if (this.eventClocksEnd.contains(eventClock) || this.eventClocksEndToAdd.contains(eventClock)) {
            return;
        }
        this.eventClocksEndToAdd.add(eventClock);
    }

    public void removeEventClockEnd(EventClock eventClock) {
        this.eventClocksEnd.remove(eventClock);
    }

    public void clearEventClocksEnd(ModModule owner) {
        this.eventClocksEnd.removeIf(eventClock -> eventClock.owner == owner);
    }

    public boolean hasScheduledTaskStart(ScheduledTask scheduledTask) {
        return this.scheduledTasksStart.contains(scheduledTask) || this.scheduledTasksStartToAdd.contains(scheduledTask);
    }

    public boolean hasScheduledTaskEnd(ScheduledTask scheduledTask) {
        return this.scheduledTasksEnd.contains(scheduledTask) || this.scheduledTasksEndToAdd.contains(scheduledTask);
    }

    public boolean hasEventClockStart(EventClock eventClock) {
        return this.eventClocksStart.contains(eventClock) || this.eventClocksStartToAdd.contains(eventClock);
    }

    public boolean hasEventClockEnd(EventClock eventClock) {
        return this.eventClocksEnd.contains(eventClock) || this.eventClocksEndToAdd.contains(eventClock);
    }

    @Override
    public void onClientTickStart(ClientContext ctx) {
        this.scheduledTasksStart.addAll(this.scheduledTasksStartToAdd);
        this.eventClocksStart.addAll(this.eventClocksStartToAdd);
        this.scheduledTasksStartToAdd.clear();
        this.eventClocksStartToAdd.clear();
        this.scheduledTasksStart.removeIf(scheduledTask -> scheduledTask.finished);
        this.eventClocksStart.removeIf(eventClock -> !eventClock.active);
        for (ScheduledTask scheduledTask2 : this.scheduledTasksStart) {
            this.onScheduledTask(ctx, scheduledTask2);
        }
        for (EventClock eventClock2 : this.eventClocksStart) {
            this.onEventClock(ctx, eventClock2);
        }
    }

    @Override
    public void onClientTickEnd(ClientContext ctx) {
        this.scheduledTasksEnd.addAll(this.scheduledTasksEndToAdd);
        this.eventClocksEnd.addAll(this.eventClocksEndToAdd);
        this.scheduledTasksEndToAdd.clear();
        this.eventClocksEndToAdd.clear();
        this.scheduledTasksEnd.removeIf(scheduledTask -> scheduledTask.finished);
        this.eventClocksEnd.removeIf(eventClock -> !eventClock.active);
        for (ScheduledTask scheduledTask2 : this.scheduledTasksEnd) {
            this.onScheduledTask(ctx, scheduledTask2);
        }
        for (EventClock eventClock2 : this.eventClocksEnd) {
            this.onEventClock(ctx, eventClock2);
        }
    }

    private void onScheduledTask(ClientContext ctx, ScheduledTask scheduledTask) {
        --scheduledTask.timer;
        if (scheduledTask.timer <= 0) {
            scheduledTask.task.run(ctx);
            scheduledTask.finished = true;
        }
    }

    private void onEventClock(ClientContext ctx, EventClock eventClock) {
        --eventClock.lifeTimer;
        if (eventClock.lifeTimer > 0) {
            return;
        }
        eventClock.task.run(ctx);
        if (eventClock.currentLife > 0) {
            --eventClock.currentLife;
        }
        if (eventClock.currentLife == 0) {
            eventClock.active = false;
            return;
        }
        eventClock.lifeTimer = eventClock.interval;
    }

    public boolean hasTasks() {
        return !this.scheduledTasksStart.isEmpty() || !this.scheduledTasksEnd.isEmpty() || !this.eventClocksStart.isEmpty() || !this.eventClocksEnd.isEmpty();
    }

    public void cancelAllTasks() {
        this.scheduledTasksStart.clear();
        this.scheduledTasksEnd.clear();
        this.eventClocksStart.clear();
        this.eventClocksEnd.clear();
    }
}

