/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.skyblock.diana;

import dev.nymnux.rhizome.module.event.ClientContext;
import java.util.Collection;
import java.util.List;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class BurrowDeducer {
    public static Vector3d deduceBurrow(ClientContext ctx, List<Vector3d> particles) {
        try {
            double t2;
            double t1;
            PolynomialCurveFitter xFitter = PolynomialCurveFitter.create((int)3);
            PolynomialCurveFitter yFitter = PolynomialCurveFitter.create((int)3);
            PolynomialCurveFitter zFitter = PolynomialCurveFitter.create((int)3);
            WeightedObservedPoints xPoints = new WeightedObservedPoints();
            WeightedObservedPoints yPoints = new WeightedObservedPoints();
            WeightedObservedPoints zPoints = new WeightedObservedPoints();
            for (int t = 0; t < particles.size(); ++t) {
                Vector3d p = particles.get(t);
                xPoints.add((double)t, p.x);
                yPoints.add((double)t, p.y);
                zPoints.add((double)t, p.z);
            }
            double[] xCoeffs = xFitter.fit((Collection)xPoints.toList());
            double[] yCoeffs = yFitter.fit((Collection)yPoints.toList());
            double[] zCoeffs = zFitter.fit((Collection)zPoints.toList());
            PolynomialFunction xFunction = new PolynomialFunction(xCoeffs);
            PolynomialFunction yFunction = new PolynomialFunction(yCoeffs);
            PolynomialFunction zFunction = new PolynomialFunction(zCoeffs);
            Vector3d asymptoteVector = new Vector3d(xCoeffs[3], yCoeffs[3], zCoeffs[3]);
            double t0 = -100.0;
            Vector3d p0 = new Vector3d(xFunction.value(t0), yFunction.value(t0), zFunction.value(t0));
            double[] wCoeffs = new double[4];
            double[] xCoeffs_ = (double[])xCoeffs.clone();
            double[] yCoeffs_ = (double[])yCoeffs.clone();
            double[] zCoeffs_ = (double[])zCoeffs.clone();
            xCoeffs_[0] = xCoeffs_[0] - p0.x;
            yCoeffs_[0] = yCoeffs_[0] - p0.y;
            zCoeffs_[0] = zCoeffs_[0] - p0.z;
            int i = 0;
            while (i < xCoeffs_.length) {
                int n = i++;
                xCoeffs_[n] = xCoeffs_[n] * asymptoteVector.x;
            }
            i = 0;
            while (i < yCoeffs_.length) {
                int n = i++;
                yCoeffs_[n] = yCoeffs_[n] * asymptoteVector.y;
            }
            i = 0;
            while (i < zCoeffs_.length) {
                int n = i++;
                zCoeffs_[n] = zCoeffs_[n] * asymptoteVector.z;
            }
            for (i = 0; i < wCoeffs.length; ++i) {
                wCoeffs[i] = (xCoeffs_[i] + yCoeffs_[i] + zCoeffs_[i]) / asymptoteVector.lengthSquared();
            }
            double b = wCoeffs[2] * 2.0;
            double a = wCoeffs[3] * 3.0;
            double c = wCoeffs[1] * 1.0;
            double delta = b * b - 4.0 * a * c;
            if (delta < 0.0) {
                t1 = -b / (2.0 * a);
                t2 = -b / (2.0 * a);
            } else {
                t1 = (-b + Math.sqrt(delta)) / (2.0 * a);
                t2 = (-b - Math.sqrt(delta)) / (2.0 * a);
            }
            Vector3d p1 = new Vector3d(xFunction.value(t1), yFunction.value(t1), zFunction.value(t1));
            Vector3d p2 = new Vector3d(xFunction.value(t2), yFunction.value(t2), zFunction.value(t2));
            Vector3d playerPos = new Vector3d(ctx.player.method_23317(), ctx.player.method_23318(), ctx.player.method_23321());
            double d1 = p1.distance((Vector3dc)playerPos);
            double d2 = p2.distance((Vector3dc)playerPos);
            return d1 > d2 ? p1 : p2;
        }
        catch (Exception ignored) {
            return new Vector3d();
        }
    }
}

