/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.skyblock.diana;

import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.SimpleEvents;
import dev.nymnux.rhizome.module.modules.event.function.FunctionKeyDispatcher;
import dev.nymnux.rhizome.module.modules.event.function.FunctionModes;
import dev.nymnux.rhizome.module.modules.skyblock.diana.BurrowDeducer;
import dev.nymnux.rhizome.module.modules.skyblock.diana.Warp;
import dev.nymnux.rhizome.util.render.HudRenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_332;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class DianaBurrow
implements ModModule {
    private static final int DEDUCE_COOLDOWN = 3000;
    private static final int MAX_PARTICLE_DISTANCE = 3;
    private static final int MAX_PLAYER_DISTANCE = 5;
    private static final int LEAST_ACCURACY_PARTICLE_SIZE = 8;
    private static final List<Warp> warps = new ArrayList<Warp>();
    private static final List<Vector3d> particlePosBuffer = new ArrayList<Vector3d>();
    private static class_2338 deducedBurrow = null;
    private static boolean isDeducing = false;
    private static long lastDeduceTime = 0L;

    private void onItemUse(ClientContext ctx, class_1799 itemStack) {
        if (!DianaBurrow.isEnabled()) {
            return;
        }
        if (!DianaBurrow.isSpade(itemStack)) {
            return;
        }
        if (System.currentTimeMillis() - lastDeduceTime < 3000L) {
            return;
        }
        lastDeduceTime = System.currentTimeMillis();
        particlePosBuffer.clear();
        deducedBurrow = null;
        isDeducing = true;
    }

    private void onParticle(ClientContext ctx, class_2675 packet) {
        if (!DianaBurrow.isEnabled()) {
            return;
        }
        if (!isDeducing) {
            return;
        }
        if (!packet.method_11551().method_10295().equals(class_2398.field_11223) || packet.method_11545() != 2 || packet.method_11543() != -0.5f) {
            return;
        }
        Vector3d currParticlePos = new Vector3d(packet.method_11544(), packet.method_11547(), packet.method_11546());
        Vector3d playerEyePos = new Vector3d(ctx.player.method_23317(), ctx.player.method_23320(), ctx.player.method_23321());
        if (particlePosBuffer.isEmpty()) {
            if (currParticlePos.distance((Vector3dc)playerEyePos) < 5.0) {
                particlePosBuffer.add(currParticlePos);
            }
            return;
        }
        double distanceToLast = particlePosBuffer.getLast().distance((Vector3dc)currParticlePos);
        if (distanceToLast > 3.0 || distanceToLast == 0.0) {
            return;
        }
        particlePosBuffer.add(currParticlePos);
        if (particlePosBuffer.size() >= 8) {
            Vector3d v = BurrowDeducer.deduceBurrow(ctx, particlePosBuffer);
            deducedBurrow = class_2338.method_49637((double)v.x, (double)(v.y + 0.5), (double)v.z);
            isDeducing = false;
        }
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        if (deducedBurrow == null) {
            return;
        }
        class_243 pos = deducedBurrow.method_46558();
        int distance = (int)ctx.player.method_19538().method_1022(pos);
        String text = distance + " m";
        Vector2d screenPos = HudRenderUtil.getAlwaysOnScreenPos(ctx, pos, tickDelta);
        HudRenderUtil.drawText(ctx, drawContext, (class_2561)class_2561.method_43470((String)text), screenPos.x, screenPos.y, ModConfig.getInstance().cfgDianaBurrow.textScale, -1, true, true, true);
    }

    public static void onFunctionKey(ClientContext ctx) {
    }

    public static void updateWarps() {
        boolean[] warpUnlocked = ModConfig.getInstance().cfgDianaBurrow.warpUnlocked;
        warps.clear();
        for (int i = 0; i < Warp.values().length; ++i) {
            if (!warpUnlocked[i]) continue;
            warps.add(Warp.values()[i]);
        }
    }

    @Override
    public void onClientWorldJoinEnd(ClientContext ctx) {
        if (!DianaBurrow.isEnabled()) {
            return;
        }
        DianaBurrow.reset();
    }

    public DianaBurrow() {
        SimpleEvents.ITEM_USE.register(this::onItemUse);
        SimpleEvents.PARTICLE.register(this::onParticle);
    }

    public static void reset() {
        particlePosBuffer.clear();
        deducedBurrow = null;
        isDeducing = false;
        lastDeduceTime = 0L;
    }

    private static boolean isSpade(class_1799 itemStack) {
        return itemStack.method_7964().getString().contains("Spade");
    }

    private static boolean isEnabled() {
        return FunctionKeyDispatcher.getMode() == FunctionModes.DIANA_BURROW;
    }

    @Override
    public void init() {
        DianaBurrow.updateWarps();
    }
}

