/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.array;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SimpleQueue<T> {
    private final Deque<T> queue;
    private final int capacity;

    public SimpleQueue(int capacity) {
        this.queue = new ArrayDeque<T>(capacity);
        this.capacity = capacity;
    }

    public void push(T element) {
        if (this.queue.size() == this.capacity) {
            this.queue.removeLast();
        }
        this.queue.addFirst(element);
    }

    public T popOldest() {
        return this.queue.removeLast();
    }

    public void removeIf(Predicate<T> predicate) {
        this.queue.removeIf(predicate);
    }

    public Iterable<T> iterable(boolean reversed) {
        return reversed ? this.queue.reversed() : this.queue;
    }

    public void forEach(Consumer<T> consumer) {
        this.queue.forEach(consumer);
    }

    public int getSize() {
        return this.queue.size();
    }

    public void clear() {
        this.queue.clear();
    }

    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    public boolean contains(T element) {
        return this.queue.contains(element);
    }
}

