/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.math;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class HistoryBuffer<T> {
    private final Deque<T> buffer;
    private final int size;

    public HistoryBuffer(int size) {
        this.buffer = new ArrayDeque<T>(size);
        this.size = size;
    }

    public void removeIf(Predicate<T> predicate) {
        this.buffer.removeIf(predicate);
    }

    public void add(T element) {
        if (this.buffer.size() == this.size) {
            this.buffer.removeLast();
        }
        this.buffer.addFirst(element);
    }

    public void remove(T element) {
        this.buffer.remove(element);
    }

    public Iterable<T> getBuffer() {
        return this.buffer;
    }

    public Iterable<T> getBufferReversed() {
        return this.buffer.reversed();
    }

    public void forEach(Consumer<T> consumer) {
        this.buffer.forEach(consumer);
    }

    public Optional<T> getLatest() {
        if (this.buffer.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.buffer.getFirst());
    }

    public int getBufferSize() {
        return this.buffer.size();
    }

    public void clear() {
        this.buffer.clear();
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public boolean contains(T element) {
        return this.buffer.contains(element);
    }
}

