/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.color;

import dev.nymnux.rhizome.util.color.ModColor;
import dev.nymnux.rhizome.util.string.StringUtil;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_2561;

public class ColorUtil {
    public static final char FORMAT_SYMBOL = '\u00a7';
    public static final char LEGAL_FORMAT_SYMBOL = '&';
    public static final List<Character> FORMAT_CODE = List.of(Character.valueOf('0'), Character.valueOf('1'), Character.valueOf('2'), Character.valueOf('3'), Character.valueOf('4'), Character.valueOf('5'), Character.valueOf('6'), Character.valueOf('7'), Character.valueOf('8'), Character.valueOf('9'), Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('d'), Character.valueOf('e'), Character.valueOf('f'), Character.valueOf('k'), Character.valueOf('l'), Character.valueOf('m'), Character.valueOf('n'), Character.valueOf('o'), Character.valueOf('r'));

    public static int[] gradient(int startColor, int endColor, int steps) {
        if (steps < 2) {
            steps = 2;
        }
        int[] colors = new int[steps];
        int startRed = startColor >> 16 & 0xFF;
        int startGreen = startColor >> 8 & 0xFF;
        int startBlue = startColor & 0xFF;
        int endRed = endColor >> 16 & 0xFF;
        int endGreen = endColor >> 8 & 0xFF;
        int endBlue = endColor & 0xFF;
        int redDiff = endRed - startRed;
        int greenDiff = endGreen - startGreen;
        int blueDiff = endBlue - startBlue;
        for (int i = 0; i < steps; ++i) {
            int red = startRed + redDiff * i / (steps - 1);
            int green = startGreen + greenDiff * i / (steps - 1);
            int blue = startBlue + blueDiff * i / (steps - 1);
            colors[i] = new ModColor(red, green, blue, 255).getValue();
        }
        return colors;
    }

    public static class_2561 getFormatCodePreview() {
        StringBuilder sb = new StringBuilder();
        for (char c : FORMAT_CODE) {
            if (c == 'k') {
                sb.append('\u00a7').append(c).append('&').append('\u00a7').append("r").append(c).append(' ');
                continue;
            }
            sb.append('\u00a7').append(c).append('&').append(c).append('\u00a7').append("r ");
        }
        return class_2561.method_43470((String)sb.toString());
    }

    public static String parseFormat(String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                if (i + 1 >= text.length()) break;
                char next = text.charAt(i + 1);
                if (FORMAT_CODE.contains(Character.valueOf(next))) {
                    sb.append('\u00a7').append(next);
                    ++i;
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static Color color(int color2) {
        return new Color(color2, true);
    }

    public static int getBackgroundColorByOpacity(int opacity) {
        return new ModColor(0, 0, 0, opacity).getValue();
    }

    public static String style(Object ... code) {
        StringBuilder s = new StringBuilder();
        for (Object o : code) {
            if (!(o instanceof Number) && !(o instanceof String) && !(o instanceof Character)) continue;
            s.append('\u00a7').append(o);
        }
        return s.toString();
    }

    public static int mapRGB(int channel) {
        return (channel %= 256) < 0 ? channel + 256 : channel;
    }

    public static int mapRGB(String s) {
        return ColorUtil.mapRGB(StringUtil.getInt(s));
    }

    public static int buildRGB(int r, int g, int b, int a) {
        Color color2 = new Color(r, g, b, a);
        return color2.getRGB();
    }
}

