/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.string;

import dev.nymnux.rhizome.config.string.StringHolder;
import dev.nymnux.rhizome.module.event.ClientContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_151;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class StringUtil {
    public static final Pattern DOUBLE_PATTERN = Pattern.compile("[-+]?\\d+(\\.\\d+)?");
    public static final String WAYPOINT_COORD_DELIMITER = "(,|\uff0c|\\s|,\\s|\uff0c\\s|\u202f|,\u202f|\uff0c\u202f)";
    public static final Pattern WAYPOINT_COORD_PATTERN = Pattern.compile("^[-+]?\\d+(,|\uff0c|\\s|,\\s|\uff0c\\s|\u202f|,\u202f|\uff0c\u202f)[-+]?\\d+(,|\uff0c|\\s|,\\s|\uff0c\\s|\u202f|,\u202f|\uff0c\u202f)[-+]?\\d+\\s*$");

    public static List<String> getIdsFromStringHolders(List<StringHolder> stringHolders) {
        return stringHolders.stream().map(s -> s.str).toList();
    }

    public static int getExtendedTextWidth(ClientContext ctx, String text) {
        return StringUtil.getTextWidth(ctx, text) + StringUtil.getOneCharTextWidth(ctx);
    }

    public static int getOneCharTextWidth(ClientContext ctx) {
        return StringUtil.getTextWidth(ctx, "0");
    }

    public static int getTextWidth(ClientContext ctx, String text) {
        return ctx.client.field_1772.method_1727(text);
    }

    public static Optional<class_2382> parseWaypointCoord(String str) {
        Matcher matcher = WAYPOINT_COORD_PATTERN.matcher(str);
        if (matcher.find()) {
            str = str.replaceAll(WAYPOINT_COORD_DELIMITER, " ");
            str = str.replaceAll("\\s+", " ");
            String[] split = str.split(" ");
            return Optional.of(new class_2382(StringUtil.getInt(split[0]), StringUtil.getInt(split[1]), StringUtil.getInt(split[2])));
        }
        return Optional.empty();
    }

    public static List<Double> getDoublesFromString(String str) {
        ArrayList<Double> doubles = new ArrayList<Double>();
        Matcher matcher = DOUBLE_PATTERN.matcher(str);
        while (matcher.find()) {
            doubles.add(Double.parseDouble(matcher.group()));
        }
        return doubles;
    }

    public static String getFileNameWithOutSuffix(String fileName) {
        int lastIndexOfDot = fileName.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            fileName = fileName.substring(0, lastIndexOfDot);
        }
        return fileName;
    }

    public static String getAltChatText(String text, List<String> symbols, int maxLength) {
        if (symbols.isEmpty()) {
            return text;
        }
        Random random = new Random();
        int length = random.nextInt(maxLength + 1);
        if (length == 0) {
            length = 1;
        }
        StringBuilder altChat = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            altChat.append(symbols.get(random.nextInt(symbols.size())));
        }
        int pos = random.nextInt(length);
        altChat.insert(pos, text);
        return altChat.toString();
    }

    public static int getIntWithLimit(String str, Predicate<Integer> range, int defaultValue) {
        int value = StringUtil.getInt(str);
        if (range.test(value)) {
            return value;
        }
        return defaultValue;
    }

    public static int getInt(String str) {
        return StringUtil.getInt(str, 0);
    }

    public static int getInt(String str, int defaultValue) {
        if (StringUtil.isInteger(str)) {
            return Integer.parseInt(str);
        }
        return defaultValue;
    }

    public static double getDouble(String str) {
        return StringUtil.getDouble(str, 0.0);
    }

    public static double getDouble(String str, double defaultValue) {
        if (StringUtil.isDouble(str)) {
            return Double.parseDouble(str);
        }
        return defaultValue;
    }

    @Nullable
    public static class_2960 getIdByString(String id) {
        String[] parts = id.split(":");
        try {
            if (parts.length == 1 && !parts[0].isEmpty()) {
                return class_2960.method_60655((String)"minecraft", (String)parts[0]);
            }
            if (parts.length == 2 && !parts[1].isEmpty()) {
                return class_2960.method_60655((String)"minecraft", (String)parts[1]);
            }
        }
        catch (class_151 class_1512) {
            // empty catch block
        }
        return null;
    }

    public static String getUniqueId(String id, List<String> existedId) {
        int suffix = 1;
        Object uniqueId = id;
        while (true) {
            boolean contained = false;
            for (String s : existedId) {
                if (!s.equals(uniqueId)) continue;
                contained = true;
                break;
            }
            if (!contained) {
                return uniqueId;
            }
            uniqueId = id + "_" + suffix;
            ++suffix;
        }
    }

    public static boolean matchString(String strSearch, String strCandidate) {
        String[] words1 = strSearch.toLowerCase().split(" ");
        String[] words2 = strCandidate.toLowerCase().split(" ");
        for (String s1 : words1) {
            boolean isContain = false;
            for (String s2 : words2) {
                if (!s2.contains(s1)) continue;
                isContain = true;
                break;
            }
            if (isContain) continue;
            return false;
        }
        return true;
    }

    public static boolean isDouble(String str) {
        try {
            Double.parseDouble(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

