/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.screens;

import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.string.StringUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_342;

public class ScreenSearchList
extends ModScreen {
    private class_342 txtSearch;
    private ModButton[] lstItems;
    private List<String> idData;
    private List<String> displayData;
    private int scrollY = 0;
    private final IdGetter idGetter;
    private final SelectedItemSetter selectedItemSetter;
    private final Runnable reload;

    public ScreenSearchList(ClientContext ctx, IdGetter idGetter, SelectedItemSetter selectedItemSetter, Runnable reload) {
        super(ctx);
        this.idGetter = idGetter;
        this.selectedItemSetter = selectedItemSetter;
        this.reload = reload;
    }

    @Override
    protected void method_25426() {
        this.idData = this.idGetter.getIds();
        this.displayData = new ArrayList<String>();
        this.lstItems = new ModButton[10];
        int panelWidth = 200;
        ModPanel panel = this.createPanel(ModScreen.InnerPosition.CENTER, panelWidth, ScreenSearchList.calcHeight(11));
        this.txtSearch = ScreenSearchList.buildTextField(this.ctx, panelWidth - 18, RhiTexts.common.message.search, "", (String s) -> this.matchItems());
        panel.addDrawableChild((class_339)this.txtSearch);
        panel.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.reload, btn -> {
            this.reload.run();
            this.reloadItemData();
            this.txtSearch.method_1852("");
            this.matchItems();
        }), panelWidth - 15, 0);
        for (int i = 0; i < 10; ++i) {
            this.lstItems[i] = new ModButton(200, (class_2561)class_2561.method_43473(), button -> this.selectedItemSetter.setSelectedItem(button.method_25369().getString()));
            panel.addDrawableChild((class_339)this.lstItems[i]);
        }
        this.addPanel(panel);
        super.method_25426();
        this.reloadItemData();
    }

    private void matchItems() {
        this.displayData.clear();
        for (String str : this.idData) {
            if (!StringUtil.matchString(this.txtSearch.method_1882(), str)) continue;
            this.displayData.add(str);
        }
        this.scrollY = 0;
        this.updateDisplayItems();
    }

    private void reloadItemData() {
        this.idData = this.idGetter.getIds();
        this.displayData.clear();
        this.displayData.addAll(this.idData);
        this.scrollY = 0;
        this.updateDisplayItems();
    }

    private void updateDisplayItems() {
        int i;
        for (i = 0; i < 10; ++i) {
            this.lstItems[i].method_25355(RhiTexts.common.icon.none.getText());
        }
        if (this.displayData.size() <= 10) {
            for (i = 0; i < this.displayData.size(); ++i) {
                this.lstItems[i].method_25355((class_2561)class_2561.method_43470((String)this.displayData.get(i)));
            }
        } else {
            for (i = 0; i < 10; ++i) {
                this.lstItems[i].method_25355((class_2561)class_2561.method_43470((String)this.displayData.get(this.scrollY + i)));
            }
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.displayData.size() > 10 && verticalAmount != 0.0) {
            if (verticalAmount > 0.0) {
                if (this.scrollY > 0) {
                    --this.scrollY;
                }
            } else if (this.scrollY < this.displayData.size() - 10) {
                ++this.scrollY;
            }
            this.updateDisplayItems();
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    public static interface IdGetter {
        public List<String> getIds();
    }

    public static interface SelectedItemSetter {
        public void setSelectedItem(String var1);
    }
}

