/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen;

import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.config.color.CfgColorGui;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.screen.container.group.ModDirectionButton;
import dev.nymnux.rhizome.gui.screen.screens.ScreenIndex;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.ClientTask;
import dev.nymnux.rhizome.module.modules.keybind.KeyBindManager;
import dev.nymnux.rhizome.sound.ModSounds;
import dev.nymnux.rhizome.text.ModText;
import dev.nymnux.rhizome.text.ModuleButtonText;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.math.SimpleVec2i;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.function.Consumer;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7529;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModScreen
extends class_437 {
    public static final int X = 3;
    public static final int Y = 3;
    public static final int WIDGET_WIDTH = 15;
    public static final int WIDGET_HEIGHT = 15;
    public static final int WIDGET_GAP = 3;
    public static final int GRID_WIDTH = 18;
    public static final int GRID_HEIGHT = 18;
    private static final int BG_PADDING = 2;
    private static final int CLOSE_SAFE_PADDING = 10;
    private static final Stack<ModScreen> screenStack = new Stack();
    protected final ClientContext ctx;
    private final List<ModPanel> root = new ArrayList<ModPanel>();
    private final List<class_342> textFieldWidgets = new ArrayList<class_342>();
    @Nullable
    private ScreenInitializer initializer = null;
    @Nullable
    private ClientTask customOnRemove = null;
    private boolean shouldCloseOnEmptyClick = true;

    public static class_7919 buildHintTooltip(List<class_2561> hints) {
        return ModScreen.buildHintTooltip(hints, true);
    }

    public static void appendHintTooltip(class_5250 origin, List<class_2561> hints) {
        ModScreen.appendHintTooltip(origin, hints, true);
    }

    public static class_7919 buildHintTooltip(List<class_2561> hints, boolean middleClickToHideHint) {
        class_5250 tooltip = class_2561.method_43473();
        for (int i = 0; i < hints.size(); ++i) {
            if (i != 0) {
                tooltip.method_27693("\n");
            }
            tooltip.method_10852((class_2561)class_2561.method_43470((String)hints.get(i).getString()).method_27692(class_124.field_1063));
        }
        if (middleClickToHideHint) {
            tooltip.method_27693("\n");
            tooltip.method_10852((class_2561)class_2561.method_43470((String)RhiTexts.common.message.middle_click_to_hide_hint.getString()).method_27692(class_124.field_1063));
        }
        return class_7919.method_47407((class_2561)tooltip);
    }

    public static void appendHintTooltip(class_5250 origin, List<class_2561> hints, boolean middleClickToHideHint) {
        for (class_2561 hint : hints) {
            origin.method_27693("\n");
            origin.method_10852((class_2561)class_2561.method_43470((String)hint.getString()).method_27692(class_124.field_1063));
        }
        if (middleClickToHideHint) {
            origin.method_27693("\n");
            origin.method_10852((class_2561)class_2561.method_43470((String)RhiTexts.common.message.middle_click_to_hide_hint.getString()).method_27692(class_124.field_1063));
        }
    }

    public static class_7842 buildTextWidget(ClientContext ctx, int width, class_2561 text) {
        return ModScreen.buildTextWidget(ctx, width, text, null, TextAlign.CENTER);
    }

    public static class_7842 buildTextWidget(ClientContext ctx, int width, ModText text) {
        return ModScreen.buildTextWidget(ctx, width, text.getText(), null, TextAlign.CENTER);
    }

    public static class_7842 buildTextWidget(ClientContext ctx, int width, ModText text, @Nullable ModText tooltip) {
        return ModScreen.buildTextWidget(ctx, width, text.getText(), tooltip != null ? tooltip.getText() : null, TextAlign.CENTER);
    }

    public static class_7842 buildTextWidget(ClientContext ctx, int width, class_2561 text, @Nullable class_2561 tooltip, TextAlign textAlign) {
        class_7842 txt = new class_7842(width, 15, text, ctx.client.field_1772);
        if (tooltip != null) {
            txt.method_47400(class_7919.method_47407((class_2561)tooltip));
        }
        switch (textAlign.ordinal()) {
            case 0: {
                txt.method_48596();
                break;
            }
            case 2: {
                txt.method_48599();
            }
        }
        return txt;
    }

    public static class_342 buildTextField(ClientContext ctx, int width, String text, Consumer<String> onChanged) {
        return ModScreen.buildTextField(ctx, width, (class_2561)null, null, text, onChanged);
    }

    public static class_342 buildTextField(ClientContext ctx, int width, @NotNull class_2561 placeHolder, String text, Consumer<String> onChanged) {
        return ModScreen.buildTextField(ctx, width, placeHolder, null, text, onChanged);
    }

    public static class_342 buildTextField(ClientContext ctx, int width, @NotNull ModText placeHolder, String text, Consumer<String> onChanged) {
        return ModScreen.buildTextField(ctx, width, placeHolder.getText(), null, text, onChanged);
    }

    public static class_342 buildTextField(ClientContext ctx, int width, @Nullable class_2561 placeHolder, @Nullable class_2561 tooltip, String text, Consumer<String> onChanged) {
        class_342 txt = new class_342(ctx.client.field_1772, 0, 0, width, 15, (class_2561)class_2561.method_43473());
        txt.method_1880(64);
        if (placeHolder != null) {
            txt.method_47404(placeHolder);
        }
        if (tooltip != null) {
            txt.method_47400(class_7919.method_47407((class_2561)tooltip));
        }
        txt.method_1852(text);
        txt.method_1863(onChanged);
        return txt;
    }

    public static class_342 buildTextField(ClientContext ctx, int width, @NotNull ModText placeHolder, @NotNull ModText tooltip, String text, Consumer<String> onChanged) {
        return ModScreen.buildTextField(ctx, width, placeHolder.getText(), tooltip.getText(), text, onChanged);
    }

    public static void setMouseClickTooltip(ModButton button, ModuleButtonText text) {
        if (!button.hasClickAction()) {
            return;
        }
        class_5250 tooltip = class_2561.method_43473();
        tooltip.method_27693(text.name.getString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1065));
        if (!text.lc.isEmpty()) {
            tooltip.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            tooltip.method_10852((class_2561)class_2561.method_43470((String)RhiTexts.common.message.left_click.getString()).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10862(class_2583.field_24360.method_10977(class_124.field_1076)));
            tooltip.method_10852((class_2561)class_2561.method_43470((String)text.lc.getString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
        }
        if (!text.rc.isEmpty()) {
            tooltip.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            tooltip.method_10852((class_2561)class_2561.method_43470((String)RhiTexts.common.message.right_click.getString()).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10862(class_2583.field_24360.method_10977(class_124.field_1054)));
            tooltip.method_10852((class_2561)class_2561.method_43470((String)text.rc.getString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
        }
        if (!text.mc.isEmpty()) {
            tooltip.method_10852((class_2561)class_2561.method_43470((String)"\n"));
            tooltip.method_10852((class_2561)class_2561.method_43470((String)RhiTexts.common.message.middle_click.getString()).method_10852((class_2561)class_2561.method_43470((String)": ")).method_10862(class_2583.field_24360.method_10977(class_124.field_1075)));
            tooltip.method_10852((class_2561)class_2561.method_43470((String)text.mc.getString()).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)));
        }
        button.method_47400(class_7919.method_47407((class_2561)tooltip));
    }

    public static void openScreen(ClientContext ctx, @NotNull ScreenInitializer initializer) {
        ModScreen screen2 = new ModScreen(ctx);
        screen2.setInitializer(initializer);
        ModScreen.openScreen(screen2);
    }

    public static void openScreen(@Nullable ModScreen screen2) {
        class_310.method_1551().method_1507((class_437)screen2);
        if (screen2 != null) {
            KeyBindManager.syncMoveControlKeyBindState(screen2.ctx);
            screenStack.push(screen2);
        }
    }

    public static void closeScreen() {
        class_310 client = class_310.method_1551();
        if (screenStack.isEmpty()) {
            client.method_1507(null);
            return;
        }
        screenStack.pop();
        if (!screenStack.isEmpty() && !(screenStack.peek() instanceof ScreenIndex)) {
            client.method_1507((class_437)screenStack.peek());
        } else {
            client.method_1507(null);
        }
    }

    public static void clearScreen() {
        while (screenStack.size() > 1) {
            screenStack.pop().method_25432();
        }
        class_310.method_1551().method_1507(null);
    }

    public static Stack<ModScreen> getScreenStack() {
        return screenStack;
    }

    public static SimpleVec2i getScreenCenter() {
        SimpleVec2i screenSize = ModScreen.getScreenSize();
        return new SimpleVec2i(screenSize.m / 2, screenSize.n / 2);
    }

    public static SimpleVec2i getScreenSize() {
        class_1041 window = class_310.method_1551().method_22683();
        return new SimpleVec2i(window.method_4486(), window.method_4502());
    }

    public static int calcLength(int grindCount, int length, int gap) {
        if (grindCount <= 0) {
            return 0;
        }
        return length + (length + gap) * (grindCount - 1);
    }

    public static void playModButtonDownSound() {
        ClientContext.getContext().ifPresent(ctx -> ctx.player.method_43077(ModSounds.MOD_BUTTON_CLICK));
    }

    public static int calcWidth(int grindCount) {
        return ModScreen.calcLength(grindCount, 15, 3);
    }

    public static int calcHeight(int grindCount) {
        return ModScreen.calcLength(grindCount, 15, 3);
    }

    public static void mixinMinecraftClient$setScreen() {
    }

    public ModScreen(ClientContext ctx) {
        super((class_2561)class_2561.method_43473());
        this.ctx = ctx;
    }

    public ModPanel createPanel(InnerPosition pos, int width, int height) {
        int x;
        SimpleVec2i screenSize = ModScreen.getScreenSize();
        return new ModPanel(this.ctx, x, switch (pos.ordinal()) {
            case 1 -> {
                x = 3;
                yield 3;
            }
            case 2 -> {
                x = 3;
                yield screenSize.n / 2 - height / 2;
            }
            case 3 -> {
                x = 3;
                yield screenSize.n - height - 3;
            }
            case 4 -> {
                x = screenSize.m - width - 3;
                yield 3;
            }
            case 5 -> {
                x = screenSize.m - width - 3;
                yield screenSize.n / 2 - height / 2;
            }
            case 6 -> {
                x = screenSize.m - width - 3;
                yield screenSize.n - height - 3;
            }
            case 7 -> {
                x = screenSize.m / 2 - width / 2;
                yield 3;
            }
            case 8 -> {
                x = screenSize.m / 2 - width / 2;
                yield screenSize.n - height - 3;
            }
            default -> {
                x = screenSize.m / 2 - width / 2;
                yield screenSize.n / 2 - height / 2;
            }
        }, width, height);
    }

    public ModPanel appendPanel(ModPanel reference, OuterPosition pos, int width, int height, boolean padding) {
        return this.appendPanel(reference, pos, width, height, 2 * (padding ? 3 : 2));
    }

    public ModPanel appendPanel(ModPanel reference, OuterPosition pos, int width, int height, int padding) {
        int x;
        if (padding < 4) {
            padding = 4;
        }
        return new ModPanel(this.ctx, x, switch (pos.ordinal()) {
            case 0 -> {
                x = reference.x - width - padding;
                yield reference.y;
            }
            case 1 -> {
                x = reference.x - width - padding;
                yield reference.y + reference.height / 2 - height / 2;
            }
            case 2 -> {
                x = reference.x - width - padding;
                yield reference.y + reference.height - height;
            }
            case 5 -> {
                x = reference.x + reference.width + padding;
                yield reference.y;
            }
            case 6 -> {
                x = reference.x + reference.width + padding;
                yield reference.y + reference.height / 2 - height / 2;
            }
            case 7 -> {
                x = reference.x + reference.width + padding;
                yield reference.y + reference.height - height;
            }
            case 10 -> {
                x = reference.x;
                yield reference.y - height - padding;
            }
            case 11 -> {
                x = reference.x + reference.width / 2 - width / 2;
                yield reference.y - height - padding;
            }
            case 12 -> {
                x = reference.x + reference.width - width;
                yield reference.y - height - padding;
            }
            case 13 -> {
                x = reference.x;
                yield reference.y + reference.height + padding;
            }
            case 14 -> {
                x = reference.x + reference.width / 2 - width / 2;
                yield reference.y + reference.height + padding;
            }
            case 15 -> {
                x = reference.x + reference.width - width;
                yield reference.y + reference.height + padding;
            }
            case 3 -> {
                x = reference.x - width - padding;
                yield reference.y - height - padding;
            }
            case 8 -> {
                x = reference.x + reference.width + padding;
                yield reference.y - height - padding;
            }
            case 4 -> {
                x = reference.x - width - padding;
                yield reference.y + reference.height + padding;
            }
            case 9 -> {
                x = reference.x + reference.width + padding;
                yield reference.y + reference.height + padding;
            }
            default -> {
                x = 0;
                yield 0;
            }
        }, width, height);
    }

    public void addPanel(ModPanel panel) {
        this.root.add(panel);
    }

    public boolean allowMoveControl() {
        return !(this.method_25399() instanceof class_342) && !(this.method_25399() instanceof class_7529) && !(this.method_25399() instanceof ModDirectionButton);
    }

    public void setShouldCloseOnEmptyClick(boolean shouldCloseOnEmptyClick) {
        this.shouldCloseOnEmptyClick = shouldCloseOnEmptyClick;
    }

    public void setInitializer(@NotNull ScreenInitializer initializer) {
        this.initializer = initializer;
    }

    public void setCustomOnRemove(@NotNull ClientTask customOnRemove) {
        this.customOnRemove = customOnRemove;
    }

    protected void method_25426() {
        if (this.initializer != null) {
            this.initializer.init(this);
        }
        for (ModPanel modPanel : this.root) {
            for (class_339 child : modPanel.children) {
                this.method_37063((class_364)child);
                if (!(child instanceof class_342)) continue;
                class_342 txt = (class_342)child;
                this.textFieldWidgets.add(txt);
            }
        }
    }

    protected void method_41843() {
        this.root.clear();
        this.textFieldWidgets.clear();
        super.method_41843();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.drawBackGround(context, mouseX, mouseY, delta);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void drawBackGround(class_332 context, int mouseX, int mouseY, float delta) {
        CfgColorGui config2 = ModConfig.getInstance().cfgColorGui;
        for (ModPanel modPanel : this.root) {
            if (!modPanel.shouldDrawBackGround) continue;
            context.method_25294(modPanel.x - 2, modPanel.y - 2, modPanel.x + modPanel.width + 2, modPanel.y + modPanel.height + 2, config2.panelBg);
        }
        for (class_342 txtI : this.textFieldWidgets) {
            if (!txtI.method_1885()) continue;
            int i = txtI.method_25370() ? config2.txtFocusedBGBorder : config2.txtUnFocusedBGBorder;
            int j = config2.txtBG;
            context.method_25294(txtI.method_46426() - 1, txtI.method_46427() - 1, txtI.method_46426() + txtI.method_25368() + 1, txtI.method_46427() + txtI.method_25364() + 1, i);
            context.method_25294(txtI.method_46426(), txtI.method_46427(), txtI.method_46426() + txtI.method_25368(), txtI.method_46427() + txtI.method_25364(), j);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int p = 10;
        boolean hovered = false;
        for (ModPanel modPanel : this.root) {
            if (!(mouseX >= (double)(modPanel.x - p)) || !(mouseX <= (double)(modPanel.x + modPanel.width + p)) || !(mouseY >= (double)(modPanel.y - p)) || !(mouseY <= (double)(modPanel.y + modPanel.height + p))) continue;
            hovered = true;
            break;
        }
        if (!hovered && this.shouldCloseOnEmptyClick) {
            if (button == 0) {
                this.method_25419();
            } else if (button == 1) {
                ModScreen.clearScreen();
                this.method_25419();
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25419() {
        ModScreen.closeScreen();
    }

    public void method_25432() {
        this.onRemove();
        super.method_25432();
    }

    public void onRemove() {
        if (this.customOnRemove != null) {
            this.customOnRemove.run(this.ctx);
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public static enum TextAlign {
        LEFT,
        CENTER,
        RIGHT;

    }

    public static interface ScreenInitializer {
        public void init(ModScreen var1);
    }

    public static enum InnerPosition {
        CENTER,
        LEFT_TOP,
        LEFT_MIDDLE,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_MIDDLE,
        RIGHT_BOTTOM,
        TOP_MIDDLE,
        BOTTOM_MIDDLE;

    }

    public static enum OuterPosition {
        LEFT_TOP,
        LEFT_MIDDLE,
        LEFT_BOTTOM,
        CORNER_LEFT_TOP,
        CORNER_LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_MIDDLE,
        RIGHT_BOTTOM,
        CORNER_RIGHT_TOP,
        CORNER_RIGHT_BOTTOM,
        TOP_LEFT,
        TOP_MIDDLE,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_MIDDLE,
        BOTTOM_RIGHT;

    }
}

