/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.screens;

import dev.nymnux.rhizome.config.CfgSimpleWarpMenu;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.gui.widget.ModColorSlider;
import dev.nymnux.rhizome.gui.widget.ModIntegerSlider;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.ChatUtil;
import dev.nymnux.rhizome.util.math.SimpleVec2i;
import dev.nymnux.rhizome.util.render.HudRenderUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_7919;

public class ScreenSimpleWarpMenu
extends ModScreen {
    private static final Island PRIVATE_ISLAND = new Island("private_island", 252, 145, 24, 50);
    private static final Island SKYBLOCK_HUB = new Island("skyblock_hub", 128, 84, 124, 110);
    private static final Island DUNGEON_HUB = new Island("dungeon_hub", 282, 134, 42, 56);
    private static final Island THE_BARN = new Island("the_barn", 210, 53, 33, 32);
    private static final Island MUSHROOM_DESERT = new Island("mushroom_desert", 206, 1, 52, 52);
    private static final Island THE_PARK = new Island("the_park", 65, 139, 60, 55);
    private static final Island GALATEA = new Island("galatea", 1, 140, 62, 52);
    private static final Island GOLD_MINE = new Island("gold_mine", 160, 46, 33, 33);
    private static final Island DEEP_CAVERNS = new Island("deep_caverns", 165, 1, 40, 39);
    private static final Island DWARVEN_MINES = new Island("dwarven_mines", 254, 1, 78, 56);
    private static final Island SPIDERS_DEN = new Island("spiders_den", 85, 85, 68, 59);
    private static final Island THE_END = new Island("the_end", 1, 70, 84, 70);
    private static final Island CRIMSON_ISLE = new Island("crimson_isle", 63, 1, 101, 87);
    private static final Island THE_RIFT = new Island("the_rift", 1, 1, 64, 69);
    private static final Island BACKWATER_BAYOU = new Island("backwater_bayou", 232, 84, 28, 25);
    private static final Island JERRYS_WORKSHOP = new Island("jerrys_workshop", 266, 66, 60, 56);
    private static final List<Island> ISLANDS;
    private static final class_2960 BACKGROUND;
    private static final int MENU_WIDTH = 333;
    private static final int MENU_HEIGHT = 195;
    private static final int ANCHOR_LENGTH = 16;
    private ModPanel panel = null;
    private final List<ModButton> buttons = new ArrayList<ModButton>();
    private boolean configMode = false;

    public ScreenSimpleWarpMenu(ClientContext ctx) {
        super(ctx);
    }

    public ScreenSimpleWarpMenu(ClientContext ctx, boolean configMode) {
        super(ctx);
        this.configMode = configMode;
    }

    @Override
    protected void method_25426() {
        if (this.configMode) {
            this.initInConfigMode();
            return;
        }
        this.buttons.clear();
        this.panel = this.createPanel(ModScreen.InnerPosition.CENTER, 333, 195);
        this.panel.move(0, ModConfig.getInstance().cfgSimpleWarpMenu.offsetY);
        for (Island island : ISLANDS) {
            for (Anchor anchor : island.anchors) {
                ModButton btn = new ModButton(16, (class_2561)class_2561.method_43473(), button -> {
                    ChatUtil.sendChatMessage(this.ctx, anchor.cmd);
                    ScreenSimpleWarpMenu.clearScreen();
                }, button -> {
                    ChatUtil.sendChatMessage(this.ctx, anchor.cmd);
                    ScreenSimpleWarpMenu.clearScreen();
                });
                btn.method_53533(16);
                btn.setDrawBG(false);
                btn.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)anchor.name).method_10862(class_2583.field_24360.method_10977(class_124.field_1068)).method_27693("\n").method_10852((class_2561)class_2561.method_43470((String)anchor.cmd).method_10862(class_2583.field_24360.method_10977(class_124.field_1080)))));
                this.panel.addDrawableChild((class_339)btn, island.x + anchor.x, island.y + anchor.y);
                this.buttons.add(btn);
            }
        }
        this.panel.setShouldDrawBackGround(false);
        this.addPanel(this.panel);
        int panelConfigWidth = 15;
        ModPanel panelConfig = this.createPanel(ModScreen.InnerPosition.RIGHT_TOP, panelConfigWidth, ScreenSimpleWarpMenu.calcHeight(1));
        panelConfig.addDrawableChild((class_339)new ModButton(panelConfigWidth, RhiTexts.common.icon.config, button -> ScreenSimpleWarpMenu.openScreen(new ScreenSimpleWarpMenu(this.ctx, true))));
        this.addPanel(panelConfig);
        super.method_25426();
    }

    private void initInConfigMode() {
        int panelMainWidth = 200;
        ModPanel panelMain = this.createPanel(ModScreen.InnerPosition.LEFT_MIDDLE, panelMainWidth, ScreenSimpleWarpMenu.calcHeight(13));
        CfgSimpleWarpMenu config2 = ModConfig.getInstance().cfgSimpleWarpMenu;
        panelMain.addDrawableChild(new ModColorSlider(panelMainWidth, config2.bgColor, integer1 -> {
            config2.bgColor = integer1;
        }, -2171170, RhiTexts.screen.simple_warp_menu_config.bg_color));
        panelMain.addDrawableChild(new ModColorSlider(panelMainWidth, config2.islandColor, integer1 -> {
            config2.islandColor = integer1;
        }, -10158080, RhiTexts.screen.simple_warp_menu_config.island_color));
        panelMain.addDrawableChild(new ModColorSlider(panelMainWidth, config2.anchorBoardColor, integer1 -> {
            config2.anchorBoardColor = integer1;
        }, -572662307, RhiTexts.screen.simple_warp_menu_config.anchor_board_color));
        panelMain.addDrawableChild(new ModColorSlider(panelMainWidth, config2.anchorHoveredColor, integer -> {
            config2.anchorHoveredColor = integer;
        }, -1311780913, RhiTexts.screen.simple_warp_menu_config.anchor_hovered_color));
        panelMain.addDrawableChild((class_339)new ModIntegerSlider(panelMainWidth, RhiTexts.screen.simple_warp_menu_config.bg_offset_x, config2.bgOffsetX, -64, 0, mappedValue -> {
            config2.bgOffsetX = mappedValue;
        }));
        panelMain.addDrawableChild((class_339)new ModIntegerSlider(panelMainWidth, RhiTexts.screen.simple_warp_menu_config.bg_offset_y, config2.bgOffsetY, -64, 0, mappedValue -> {
            config2.bgOffsetY = mappedValue;
        }));
        panelMain.addDrawableChild((class_339)new ModIntegerSlider(panelMainWidth, RhiTexts.screen.simple_warp_menu_config.bg_width, config2.bgWidth, 333, 666, mappedValue -> {
            config2.bgWidth = mappedValue;
        }));
        panelMain.addDrawableChild((class_339)new ModIntegerSlider(panelMainWidth, RhiTexts.screen.simple_warp_menu_config.bg_height, config2.bgHeight, 195, 390, mappedValue -> {
            config2.bgHeight = mappedValue;
        }));
        panelMain.addDrawableChild((class_339)new ModIntegerSlider(panelMainWidth, RhiTexts.screen.simple_warp_menu_config.offset_y, config2.offsetY, -64, 64, mappedValue -> {
            config2.offsetY = mappedValue;
        }));
        this.addPanel(panelMain);
        super.method_25426();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.configMode) {
            this.renderInConfigMode(context, mouseX, mouseY, delta);
            return;
        }
        CfgSimpleWarpMenu config2 = ModConfig.getInstance().cfgSimpleWarpMenu;
        if (this.panel != null) {
            ScreenSimpleWarpMenu.drawBackground(context, this.panel.x + config2.bgOffsetX, this.panel.y + config2.bgOffsetY);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.panel == null) {
            return;
        }
        int x = this.panel.x;
        int y = this.panel.y;
        ScreenSimpleWarpMenu.drawIslandsAndAnchorBoards(context, x, y);
        for (ModButton button : this.buttons) {
            if (!button.method_49606()) continue;
            ScreenSimpleWarpMenu.drawHoveredAnchorBackground(context, button.method_46426(), button.method_46427());
        }
        ScreenSimpleWarpMenu.drawAnchorIcons(context, x, y);
    }

    private void renderInConfigMode(class_332 context, int mouseX, int mouseY, float delta) {
        CfgSimpleWarpMenu config2 = ModConfig.getInstance().cfgSimpleWarpMenu;
        SimpleVec2i screenSize = ScreenSimpleWarpMenu.getScreenSize();
        int x = screenSize.m - 333 - 32;
        int y = screenSize.n / 2 - 97 + config2.offsetY;
        ScreenSimpleWarpMenu.drawBackground(context, x + config2.bgOffsetX, y + config2.bgOffsetY);
        ScreenSimpleWarpMenu.drawIslandsAndAnchorBoards(context, x, y);
        int goldMineX = x + ScreenSimpleWarpMenu.GOLD_MINE.x + ScreenSimpleWarpMenu.GOLD_MINE.anchors.getFirst().x;
        int goldMineY = y + ScreenSimpleWarpMenu.GOLD_MINE.y + ScreenSimpleWarpMenu.GOLD_MINE.anchors.getFirst().y;
        ScreenSimpleWarpMenu.drawHoveredAnchorBackground(context, goldMineX, goldMineY);
        ScreenSimpleWarpMenu.drawAnchorIcons(context, x, y);
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private static void drawBackground(class_332 context, int x, int y) {
        CfgSimpleWarpMenu config2 = ModConfig.getInstance().cfgSimpleWarpMenu;
        context.method_25291(class_10799.field_56883, BACKGROUND, x, y, 0.0f, 0.0f, config2.bgWidth, config2.bgHeight, config2.bgWidth, config2.bgHeight, config2.bgColor);
    }

    private static void drawIslandsAndAnchorBoards(class_332 context, int x, int y) {
        CfgSimpleWarpMenu config2 = ModConfig.getInstance().cfgSimpleWarpMenu;
        for (Island island : ISLANDS) {
            int islandX = x + island.x;
            int islandY = y + island.y;
            context.method_25291(class_10799.field_56883, island.map, islandX, islandY, 0.0f, 0.0f, island.width, island.height, island.width, island.height, config2.islandColor);
            for (Anchor anchor : island.anchors) {
                int anchorX = x + island.x + anchor.x;
                int anchorY = y + island.y + anchor.y;
                int boardColor = config2.anchorBoardColor;
                HudRenderUtil.fill(context, anchorX, anchorY - 1, 16, 1, boardColor);
                HudRenderUtil.fill(context, anchorX, anchorY + 16, 16, 1, boardColor);
                HudRenderUtil.fill(context, anchorX - 1, anchorY, 1, 16, boardColor);
                HudRenderUtil.fill(context, anchorX + 16, anchorY, 1, 16, boardColor);
            }
        }
    }

    private static void drawHoveredAnchorBackground(class_332 context, int x, int y) {
        CfgSimpleWarpMenu config2 = ModConfig.getInstance().cfgSimpleWarpMenu;
        HudRenderUtil.fill(context, x, y, 16, 16, config2.anchorHoveredColor);
    }

    private static void drawAnchorIcons(class_332 context, int x, int y) {
        for (Island island : ISLANDS) {
            for (Anchor anchor : island.anchors) {
                int anchorX = x + island.x + anchor.x;
                int anchorY = y + island.y + anchor.y;
                context.method_25290(class_10799.field_56883, anchor.icon, anchorX, anchorY, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }

    static {
        PRIVATE_ISLAND.add("Private Island", "/is", "private_island", 3, 4);
        PRIVATE_ISLAND.add("Garden", "/warp garden", "garden", 4, 30);
        SKYBLOCK_HUB.add("SkyBlock Hub", "/hub", "skyblock_hub", 74, 36);
        SKYBLOCK_HUB.add("Castle", "/warp castle", "castle", 13, 74);
        SKYBLOCK_HUB.add("Elizabeth", "/warp elizabeth", "elizabeth", 73, 14);
        SKYBLOCK_HUB.add("Sirius' Shack", "/warp da", "sirius_shack", 90, 90);
        SKYBLOCK_HUB.add("Crypts", "/warp crypt", "crypts", 29, 33);
        SKYBLOCK_HUB.add("Museum", "/warp museum", "museum", 51, 77);
        SKYBLOCK_HUB.add("Taylor's Shop", "/warp taylor", "taylors_shop", 96, 50);
        SKYBLOCK_HUB.add("Wizard Tower", "/warp wiz", "wizard_tower", 77, 69);
        SKYBLOCK_HUB.add("Carnival", "/warp carnival", "carnival", 34, 58);
        SKYBLOCK_HUB.add("Trading Center", "/warp stonks", "trading_center", 52, 38);
        DUNGEON_HUB.add("Dungeon Hub", "/warp dh", "dungeon_hub", 23, 14);
        THE_BARN.add("The Barn", "/warp barn", "the_barn", 7, 7);
        MUSHROOM_DESERT.add("Mushroom Desert", "/warp desert", "mushroom_desert", 27, 27);
        MUSHROOM_DESERT.add("Trapper's Den", "/warp trapper", "trappers_den", 10, 8);
        THE_PARK.add("The Park", "/warp park", "the_park", 42, 16);
        THE_PARK.add("Jungle", "/warp jungle", "jungle", 2, 5);
        THE_PARK.add("Howling Cave", "/warp howl", "howling_cave", 23, 7);
        GALATEA.add("Galatea", "/warp galatea", "galatea", 38, 18);
        GALATEA.add("Murkwater Loch", "/warp loch", "murkwater_loch", 13, 13);
        GOLD_MINE.add("Gold Mine", "/warp gold", "gold_mine", 7, 10);
        DEEP_CAVERNS.add("Deep Caverns", "/warp deep", "deep_caverns", 12, 15);
        DWARVEN_MINES.add("Dwarven Mines", "/warp mines", "dwarven_mines", 10, 13);
        DWARVEN_MINES.add("Forge", "/warp forge", "forge", 10, 34);
        DWARVEN_MINES.add("Base Camp", "/warp base", "base_camp", 31, 36);
        DWARVEN_MINES.add("Crystal Hollows", "/warp crystals", "crystal_hollows", 31, 15);
        DWARVEN_MINES.add("Crystal Nucleus", "/warp cn", "crystal_nucleus", 58, 4);
        SPIDERS_DEN.add("Spider's Den", "/warp spider", "spiders_den", 22, 36);
        SPIDERS_DEN.add("Top of Nest", "/warp top", "top_of_nest", 44, 5);
        SPIDERS_DEN.add("Arachne's Sanctuary", "/warp arachne", "arachnes_sanctuary", 13, 15);
        THE_END.add("The End", "/warp end", "the_end", 49, 36);
        THE_END.add("Dragon's Nest", "/warp drag", "dragons_nest", 13, 27);
        THE_END.add("Void Sepulture", "/warp void", "void_sepulture", 38, 13);
        CRIMSON_ISLE.add("Crimson Isle", "/warp nether", "crimson_isle", 42, 58);
        CRIMSON_ISLE.add("Forgotten Skull", "/warp kuudra", "forgotten_skull", 42, 12);
        CRIMSON_ISLE.add("The Wasteland", "/warp wasteland", "the_wasteland", 29, 36);
        CRIMSON_ISLE.add("Dragontail", "/warp dragontail", "dragontail", 10, 22);
        CRIMSON_ISLE.add("Scarleton", "/warp scarleton", "scarleton", 80, 22);
        CRIMSON_ISLE.add("Smoldering Tomb", "/warp smold", "smoldering_tomb", 58, 36);
        THE_RIFT.add("Wizard Tower", "/warp rift", "rift", 16, 31);
        BACKWATER_BAYOU.add("Backwater Bayou", "/warp bayou", "backwater_bayou", 8, 4);
        JERRYS_WORKSHOP.add("Jerry's Workshop", "/warp jerry", "jerrys_workshop", 23, 20);
        ISLANDS = List.of(PRIVATE_ISLAND, SKYBLOCK_HUB, DUNGEON_HUB, THE_BARN, MUSHROOM_DESERT, THE_PARK, GALATEA, GOLD_MINE, DEEP_CAVERNS, DWARVEN_MINES, SPIDERS_DEN, THE_END, CRIMSON_ISLE, THE_RIFT, BACKWATER_BAYOU, JERRYS_WORKSHOP);
        BACKGROUND = class_2960.method_60655((String)"rhizome", (String)"textures/skyblock/simple_warp_menu/map_background.png");
    }

    private static class Island {
        public int x;
        public int y;
        public int width;
        public int height;
        public List<Anchor> anchors = new ArrayList<Anchor>();
        public class_2960 map;

        public Island(String map, int x, int y, int width, int height) {
            this.map = class_2960.method_60655((String)"rhizome", (String)("textures/skyblock/simple_warp_menu/island/" + map + ".png"));
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void add(String name, String cmd, String icon2, int x, int y) {
            this.anchors.add(new Anchor(name, cmd, icon2, x, y));
        }
    }

    private static class Anchor {
        public int x;
        public int y;
        public String name;
        public String cmd;
        public class_2960 icon;

        public Anchor(String name, String cmd, String icon2, int x, int y) {
            this.name = name;
            this.cmd = cmd;
            this.icon = class_2960.method_60655((String)"rhizome", (String)("textures/skyblock/simple_warp_menu/anchor/" + icon2 + ".png"));
            this.x = x;
            this.y = y;
        }
    }
}

