/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.event;

import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.callbacks.ArmorStandTextUpdate;
import dev.nymnux.rhizome.module.event.callbacks.ArmorStandUpdate;
import dev.nymnux.rhizome.module.event.callbacks.ChatTrigger;
import dev.nymnux.rhizome.module.event.callbacks.EntityDestroy;
import dev.nymnux.rhizome.module.event.callbacks.EntitySpawn;
import dev.nymnux.rhizome.module.event.callbacks.ItemUse;
import dev.nymnux.rhizome.module.event.callbacks.Particle;
import dev.nymnux.rhizome.module.event.callbacks.ServerTick;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_6373;

public class SimpleEvents {
    public static final SimpleEvent<EntitySpawn> ENTITY_SPAWN = new SimpleEvent();
    public static final SimpleEvent<EntityDestroy> ENTITY_DESTROY = new SimpleEvent();
    public static final SimpleEvent<ChatTrigger> CHAT_TRIGGER = new SimpleEvent();
    public static final SimpleEvent<ArmorStandUpdate> ARMOR_STAND_UPDATE = new SimpleEvent();
    public static final SimpleEvent<ArmorStandTextUpdate> ARMOR_STAND_TEXT_UPDATE = new SimpleEvent();
    public static final SimpleEvent<Particle> PARTICLE = new SimpleEvent();
    public static final SimpleEvent<ServerTick> SERVER_TICK = new SimpleEvent();
    public static final SimpleEvent<ItemUse> ITEM_USE = new SimpleEvent();

    public static void onEntitySpawn(ClientContext ctx, class_1297 entity) {
        ENTITY_SPAWN.getCallbacks().forEach(callback -> callback.onEntitySpawn(ctx, entity));
    }

    public static void onEntityDestroy(ClientContext ctx, class_1297 entity) {
        ENTITY_DESTROY.getCallbacks().forEach(callback -> callback.onEntityDestroy(ctx, entity));
    }

    public static void onChatTrigger(ClientContext ctx, class_2561 raw, String message2) {
        CHAT_TRIGGER.getCallbacks().forEach(callback -> callback.onChatTrigger(ctx, raw, message2));
    }

    public static void onArmorStandUpdate(ClientContext ctx, class_1531 armorStand) {
        ARMOR_STAND_UPDATE.getCallbacks().forEach(callback -> callback.onArmorStandUpdate(ctx, armorStand));
    }

    public static void onArmorStandTextUpdate(ClientContext ctx, class_1531 armorStand, class_2561 raw, String text) {
        ARMOR_STAND_TEXT_UPDATE.getCallbacks().forEach(callback -> callback.onArmorStandTextUpdate(ctx, armorStand, raw, text));
    }

    public static void onParticle(ClientContext ctx, class_2675 packet) {
        PARTICLE.getCallbacks().forEach(callback -> callback.onParticle(ctx, packet));
    }

    public static void onServerTick(ClientContext ctx, class_6373 packet) {
        SERVER_TICK.getCallbacks().forEach(callback -> callback.onServerTick(ctx, packet));
    }

    public static void onItemUse(ClientContext ctx, class_1799 itemStack) {
        ITEM_USE.getCallbacks().forEach(callback -> callback.onItemUse(ctx, itemStack));
    }

    public static class SimpleEvent<F> {
        private final List<F> callbacks = new ArrayList<F>();

        public void register(F callback) {
            this.callbacks.add(callback);
        }

        public List<F> getCallbacks() {
            return this.callbacks;
        }
    }
}

