/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.test;

import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.widget.ModDoubleSlider;
import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.SimpleEvents;
import dev.nymnux.rhizome.module.modules.keybind.KeyBindManager;
import dev.nymnux.rhizome.util.render.HudRenderUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_332;
import net.minecraft.class_339;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.joml.Vector2d;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public class ModTest
implements ModModule {
    private static final int TEST_KEY_CODE = 74;
    private static final int LEFT_KEY_CODE = 263;
    private static final int RIGHT_KEY_CODE = 262;
    private static boolean testKeyDownPre = false;
    private static boolean leftKeyDownPre = false;
    private static boolean rightKeyDownPre = false;
    private static final List<Vector3d> particlePosBuffer = new ArrayList<Vector3d>();
    private static boolean newParticle = false;
    private static PolynomialFunction xFunction = null;
    private static PolynomialFunction yFunction = null;
    private static PolynomialFunction zFunction = null;
    private static double t = 0.0;

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        if (xFunction == null || yFunction == null || zFunction == null) {
            return;
        }
        for (int i = -400; i <= 400; ++i) {
            double t = (double)i / 2.0;
            class_243 v1 = new class_243(xFunction.value(t), yFunction.value(t), zFunction.value(t));
            class_243 v2 = new class_243(xFunction.value(t + 0.5), yFunction.value(t + 0.5), zFunction.value(t + 0.5));
            if (!HudRenderUtil.canSeeOnScreen(ctx, v1, tickDelta) || !HudRenderUtil.canSeeOnScreen(ctx, v2, tickDelta)) continue;
            Vector2d screenPos1 = HudRenderUtil.getAlwaysOnScreenPos(ctx, v1, tickDelta);
            Vector2d screenPos2 = HudRenderUtil.getAlwaysOnScreenPos(ctx, v2, tickDelta);
            float scaleFactor = ClientContext.getScaleFactor(ctx);
            float x1 = (float)(screenPos1.x / (double)scaleFactor);
            float y1 = (float)(screenPos1.y / (double)scaleFactor);
            float x2 = (float)(screenPos2.x / (double)scaleFactor);
            float y2 = (float)(screenPos2.y / (double)scaleFactor);
            HudRenderUtil.drawLine(drawContext, new class_241(x1, y1), new class_241(x2, y2), -1, -1, 1.0f);
        }
    }

    private void onParticle(ClientContext ctx, class_2675 packet) {
        if (!newParticle) {
            return;
        }
        if (!packet.method_11551().method_10295().equals(class_2398.field_11223) || packet.method_11545() != 2 || packet.method_11543() != -0.5f) {
            return;
        }
        Vector3d currParticlePos = new Vector3d(packet.method_11544(), packet.method_11547(), packet.method_11546());
        Vector3d playerEyePos = new Vector3d(ctx.player.method_23317(), ctx.player.method_23320(), ctx.player.method_23321());
        if (particlePosBuffer.isEmpty()) {
            if (currParticlePos.distance((Vector3dc)playerEyePos) < 5.0) {
                particlePosBuffer.add(currParticlePos);
            }
            return;
        }
        double distanceToLast = particlePosBuffer.getLast().distance((Vector3dc)currParticlePos);
        if (distanceToLast > 3.0 || distanceToLast == 0.0) {
            return;
        }
        particlePosBuffer.add(currParticlePos);
        if (particlePosBuffer.size() >= 8) {
            PolynomialCurveFitter xFitter = PolynomialCurveFitter.create((int)3);
            PolynomialCurveFitter yFitter = PolynomialCurveFitter.create((int)3);
            PolynomialCurveFitter zFitter = PolynomialCurveFitter.create((int)3);
            WeightedObservedPoints xPoints = new WeightedObservedPoints();
            WeightedObservedPoints yPoints = new WeightedObservedPoints();
            WeightedObservedPoints zPoints = new WeightedObservedPoints();
            for (int t = 0; t < particlePosBuffer.size(); ++t) {
                Vector3d p = particlePosBuffer.get(t);
                xPoints.add((double)t, p.x);
                yPoints.add((double)t, p.y);
                zPoints.add((double)t, p.z);
            }
            double[] xCoeffs = xFitter.fit((Collection)xPoints.toList());
            double[] yCoeffs = yFitter.fit((Collection)yPoints.toList());
            double[] zCoeffs = zFitter.fit((Collection)zPoints.toList());
            xFunction = new PolynomialFunction(xCoeffs);
            yFunction = new PolynomialFunction(yCoeffs);
            zFunction = new PolynomialFunction(zCoeffs);
            newParticle = false;
        }
    }

    private static void onTest(ClientContext ctx) {
    }

    private static void onLeft(ClientContext ctx) {
    }

    private static void onRight(ClientContext ctx) {
    }

    @Override
    public void onClientTickStart(ClientContext ctx) {
        if (ModTest.isTestKeyDown() && !testKeyDownPre) {
            ModTest.onTest(ctx);
        }
        if (ModTest.isLeftKeyDown() && !leftKeyDownPre) {
            ModTest.onLeft(ctx);
        }
        if (ModTest.isRightKeyDown() && !rightKeyDownPre) {
            ModTest.onRight(ctx);
        }
    }

    @Override
    public void onClientTickEnd(ClientContext ctx) {
        testKeyDownPre = ModTest.isTestKeyDown();
        leftKeyDownPre = ModTest.isLeftKeyDown();
        rightKeyDownPre = ModTest.isRightKeyDown();
    }

    private static boolean isTestKeyDown() {
        return KeyBindManager.isKeyDown(74);
    }

    private static boolean isLeftKeyDown() {
        return KeyBindManager.isKeyDown(263);
    }

    private static boolean isRightKeyDown() {
        return KeyBindManager.isKeyDown(262);
    }

    public ModTest() {
        SimpleEvents.PARTICLE.register(this::onParticle);
    }

    private static /* synthetic */ void lambda$onTest$1(ModScreen scn) {
        ModPanel panel = scn.createPanel(ModScreen.InnerPosition.CENTER, 300, 15);
        panel.addDrawableChild((class_339)new ModDoubleSlider(300, (class_2561)class_2561.method_43470((String)"t"), t, 0.0, 100.0, mappedValue -> {
            t = mappedValue;
        }));
        scn.addPanel(panel);
    }
}

