/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.color;

public class ModColor {
    private int r;
    private int g;
    private int b;
    private int a;

    public ModColor(int value) {
        this.a = value >> 24 & 0xFF;
        this.r = value >> 16 & 0xFF;
        this.g = value >> 8 & 0xFF;
        this.b = value & 0xFF;
    }

    public ModColor(int r, int g, int b, int a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public int getValue() {
        return (this.a & 0xFF) << 24 | (this.r & 0xFF) << 16 | (this.g & 0xFF) << 8 | this.b & 0xFF;
    }

    public int getR() {
        return this.r;
    }

    public int getG() {
        return this.g;
    }

    public int getB() {
        return this.b;
    }

    public int getA() {
        return this.a;
    }

    public float getRF() {
        return (float)this.getR() / 255.0f;
    }

    public float getGF() {
        return (float)this.getG() / 255.0f;
    }

    public float getBF() {
        return (float)this.getB() / 255.0f;
    }

    public float getAF() {
        return (float)this.getA() / 255.0f;
    }

    public ModColor setR(int r) {
        this.r = r;
        return this;
    }

    public ModColor setG(int g) {
        this.g = g;
        return this;
    }

    public ModColor setB(int b) {
        this.b = b;
        return this;
    }

    public ModColor setA(int a) {
        this.a = a;
        return this;
    }
}

