/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.math;

import dev.nymnux.rhizome.util.string.StringUtil;
import java.util.Optional;
import java.util.regex.Pattern;

public class SimpleCalculator {
    private static final Pattern EXP_PATTERN = Pattern.compile("^\\d+(\\.\\d+)?[+\\-*/]\\d+(\\.\\d+)?$");

    public static Optional<CalculationRecord> calcExpression(String expression) {
        if (!EXP_PATTERN.matcher(expression = expression.replaceAll("\\s", "")).matches()) {
            return Optional.empty();
        }
        int operator = expression.contains("+") ? 43 : (expression.contains("-") ? 45 : (expression.contains("*") ? 42 : 47));
        String[] split = expression.split("[+\\-*/]");
        double a = StringUtil.getDouble(split[0]);
        double b = StringUtil.getDouble(split[1]);
        return switch (operator) {
            case 43 -> Optional.of(new CalculationRecord(a, b, '+', a + b));
            case 45 -> Optional.of(new CalculationRecord(a, b, '-', a - b));
            case 42 -> Optional.of(new CalculationRecord(a, b, '\u00d7', a * b));
            case 47 -> Optional.of(new CalculationRecord(a, b, '\u00f7', a / b));
            default -> Optional.empty();
        };
    }

    public record CalculationRecord(double a, double b, char operator, double result) {
    }
}

