/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.container.group;

import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.config.color.CfgColorGui;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.mixin.accessor.ScreenAccessor;
import dev.nymnux.rhizome.util.io.KeyBindUtil;
import dev.nymnux.rhizome.util.math.Vec2i;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModDirectionButton
extends class_4185 {
    private static final int SMALL_STEP = 1;
    private static final int BIG_STEP = 5;
    private static final int BUTTON_SIZE = 5;
    private final Vec2i pos;
    private final boolean allowNeg;
    @Nullable
    private Runnable onKeyPressJump = null;
    @Nullable
    private Runnable onKeyPressSprint = null;

    public ModDirectionButton(Vec2i pos) {
        this(pos, false);
    }

    public ModDirectionButton(Vec2i pos, boolean allowNeg) {
        super(0, 0, 15, 15, (class_2561)class_2561.method_43473(), button -> {}, class_4185.field_40754);
        this.pos = pos;
        this.allowNeg = allowNeg;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_49606() && (button == 2 || button == 1)) {
            class_437 currentScreen;
            if (button == 2) {
                this.pos.reset();
            }
            if ((currentScreen = class_310.method_1551().field_1755) != null && ((ScreenAccessor)currentScreen).rhizome$getChildren().contains((Object)this)) {
                currentScreen.method_25395((class_364)this);
            }
        }
        if (!this.isValidClick(button) || !this.isBtnHovered(mouseX, mouseY)) {
            return super.method_25402(mouseX, mouseY, button);
        }
        ModScreen.playModButtonDownSound();
        Vec2i modifier = new Vec2i(0, 0);
        if (this.isBtnUpHovered(mouseX, mouseY)) {
            modifier.n = -this.getStep(button);
        }
        if (this.isBtnDownHovered(mouseX, mouseY)) {
            modifier.n = this.getStep(button);
        }
        if (this.isBtnLeftHovered(mouseX, mouseY)) {
            modifier.m = -this.getStep(button);
        }
        if (this.isBtnRightHovered(mouseX, mouseY)) {
            modifier.m = this.getStep(button);
        }
        this.applyModifier(modifier);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        class_315 options = class_310.method_1551().field_1690;
        Vec2i modifier = new Vec2i(0, 0);
        if (KeyBindUtil.isKeyOrMouseDown(options.field_1894)) {
            modifier.n = -this.getStep();
        }
        if (KeyBindUtil.isKeyOrMouseDown(options.field_1913)) {
            modifier.m = -this.getStep();
        }
        if (KeyBindUtil.isKeyOrMouseDown(options.field_1881)) {
            modifier.n = this.getStep();
        }
        if (KeyBindUtil.isKeyOrMouseDown(options.field_1849)) {
            modifier.m = this.getStep();
        }
        this.applyModifier(modifier);
        if (KeyBindUtil.isKeyOrMouseDown(options.field_1903) && this.onKeyPressJump != null) {
            this.onKeyPressJump.run();
        }
        if (KeyBindUtil.isKeyOrMouseDown(options.field_1867) && this.onKeyPressSprint != null) {
            this.onKeyPressSprint.run();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.method_25370()) {
            context.method_49601(this.method_46426() - 1, this.method_46427() - 1, 17, 17, -1);
        }
        CfgColorGui config2 = ModConfig.getInstance().cfgColorGui;
        context.method_25294(this.method_46426() + 5, this.method_46427(), this.method_46426() + 10, this.method_46427() + 5, this.isBtnUpHovered(mouseX, mouseY) ? config2.buttonColorHovered : config2.buttonColor);
        context.method_25294(this.method_46426() + 5, this.method_46427() + 10, this.method_46426() + 10, this.method_46427() + 15, this.isBtnDownHovered(mouseX, mouseY) ? config2.buttonColorHovered : config2.buttonColor);
        context.method_25294(this.method_46426(), this.method_46427() + 5, this.method_46426() + 5, this.method_46427() + 10, this.isBtnLeftHovered(mouseX, mouseY) ? config2.buttonColorHovered : config2.buttonColor);
        context.method_25294(this.method_46426() + 10, this.method_46427() + 5, this.method_46426() + 15, this.method_46427() + 10, this.isBtnRightHovered(mouseX, mouseY) ? config2.buttonColorHovered : config2.buttonColor);
    }

    public void setOnKeyPressJump(@NotNull Runnable onKeyPressJump) {
        this.onKeyPressJump = onKeyPressJump;
    }

    public void setOnKeyPressSprint(@NotNull Runnable onKeyPressSprint) {
        this.onKeyPressSprint = onKeyPressSprint;
    }

    private void applyModifier(Vec2i modifier) {
        if (modifier.m == 0 && modifier.n == 0) {
            return;
        }
        this.pos.m = !this.allowNeg && this.pos.m + modifier.m < 0 ? 0 : (this.pos.m += modifier.m);
        this.pos.n = !this.allowNeg && this.pos.n + modifier.n < 0 ? 0 : (this.pos.n += modifier.n);
    }

    private boolean isBtnUpHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + 5) && mouseX < (double)(this.method_46426() + 10) && mouseY >= (double)this.method_46427() && mouseY < (double)(this.method_46427() + 5);
    }

    private boolean isBtnDownHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + 5) && mouseX < (double)(this.method_46426() + 10) && mouseY >= (double)(this.method_46427() + 10) && mouseY < (double)(this.method_46427() + 15);
    }

    private boolean isBtnLeftHovered(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseX < (double)(this.method_46426() + 5) && mouseY >= (double)(this.method_46427() + 5) && mouseY < (double)(this.method_46427() + 10);
    }

    private boolean isBtnRightHovered(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() + 10) && mouseX < (double)(this.method_46426() + 15) && mouseY >= (double)(this.method_46427() + 5) && mouseY < (double)(this.method_46427() + 10);
    }

    private boolean isBtnHovered(double mouseX, double mouseY) {
        return this.isBtnUpHovered(mouseX, mouseY) || this.isBtnDownHovered(mouseX, mouseY) || this.isBtnLeftHovered(mouseX, mouseY) || this.isBtnRightHovered(mouseX, mouseY);
    }

    private boolean isValidClick(int mouseButton) {
        return mouseButton == 0 || mouseButton == 1;
    }

    public int getStep() {
        return KeyBindUtil.isShiftDown() ? 5 : 1;
    }

    private int getStep(int mouseButton) {
        return mouseButton == 0 ? 1 : 5;
    }

    public void method_25354(class_1144 soundManager) {
    }
}

