/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.container.list;

import dev.nymnux.rhizome.config.CfgChatMacro;
import dev.nymnux.rhizome.config.CfgRareEvent;
import dev.nymnux.rhizome.config.CfgSimpleChatTrigger;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.config.string.StringHolder;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.screen.container.list.adapter.DataGenerator;
import dev.nymnux.rhizome.gui.screen.container.list.adapter.EntryWidgetsProvider;
import dev.nymnux.rhizome.gui.screen.container.list.adapter.custom.ChatMacroConfigWidgetsProvider;
import dev.nymnux.rhizome.gui.screen.container.list.adapter.custom.RareEventConfigWidgetsProvider;
import dev.nymnux.rhizome.gui.screen.container.list.adapter.custom.SimpleChatTriggerConfigWidgetsProvider;
import dev.nymnux.rhizome.gui.screen.container.list.adapter.custom.StringEntryWidgetsProvider;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.SoundUtil;
import dev.nymnux.rhizome.util.color.ColorUtil;
import dev.nymnux.rhizome.util.render.RenderUtil;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ScreenEntryList<T>
extends ModScreen {
    private static final int DEFAULT_ROW_COUNT = 10;
    private final List<T> data;
    private final int panelWidth;
    private final int rowCount;
    private final boolean alignRight;
    private final EntryWidgetsProvider<T> entryWidgetsProvider;
    private final DataGenerator<T> dataGenerator;
    private int scrollDataOffset;
    @Nullable
    private ScreenRenderer customScreenRenderer = null;

    public static ScreenEntryList<CfgRareEvent> rareEventConfigScreen(ClientContext ctx) {
        RareEventConfigWidgetsProvider entryWidgetsProvider = new RareEventConfigWidgetsProvider(ctx);
        int panelWidth = ScreenEntryList.calcPanelWidth(entryWidgetsProvider, CfgRareEvent::new);
        List<CfgRareEvent> data = ModConfig.getInstance().cfgRareEvents;
        return new ScreenEntryList<CfgRareEvent>(ctx, panelWidth, false, data, entryWidgetsProvider, CfgRareEvent::new);
    }

    public static ScreenEntryList<CfgSimpleChatTrigger> simpleChatTriggerConfigScreen(ClientContext ctx) {
        SimpleChatTriggerConfigWidgetsProvider entryWidgetsProvider = new SimpleChatTriggerConfigWidgetsProvider(ctx);
        int panelWidth = ScreenEntryList.calcPanelWidth(entryWidgetsProvider, CfgSimpleChatTrigger::new);
        List<CfgSimpleChatTrigger> data = ModConfig.getInstance().cfgSimpleChatTriggerList;
        ScreenEntryList<CfgSimpleChatTrigger> screenEntryList = new ScreenEntryList<CfgSimpleChatTrigger>(ctx, panelWidth, false, data, entryWidgetsProvider, CfgSimpleChatTrigger::new);
        screenEntryList.setCustomScreenRenderer((context, mouseX, mouseY, delta) -> {
            context.method_27535(ctx.client.field_1772, ColorUtil.getFormatCodePreview(), 3, 23, -1);
            context.method_27535(ctx.client.field_1772, SoundUtil.getSoundNamePreview(), 3, 33, -1);
        });
        return screenEntryList;
    }

    public static ScreenEntryList<CfgChatMacro> chatMacroConfigScreen(ClientContext ctx) {
        ChatMacroConfigWidgetsProvider entryWidgetsProvider = new ChatMacroConfigWidgetsProvider(ctx);
        int panelWidth = ScreenEntryList.calcPanelWidth(entryWidgetsProvider, CfgChatMacro::new);
        List<CfgChatMacro> data = ModConfig.getInstance().cfgChatMacroList;
        ScreenEntryList<CfgChatMacro> screenEntryList = new ScreenEntryList<CfgChatMacro>(ctx, panelWidth, true, data, entryWidgetsProvider, CfgChatMacro::new);
        screenEntryList.setCustomScreenRenderer((context, mouseX, mouseY, delta) -> {
            for (CfgChatMacro chatMacro : data) {
                int x = 3 + 18 * chatMacro.gridPos.m;
                int y = 3 + 18 * chatMacro.gridPos.n;
                int width = 15 + 18 * (chatMacro.widthCount - 1);
                RenderUtil.fill(context, x, y, width, 15, ModConfig.getInstance().cfgColorGui.buttonColor);
                context.method_27534(ctx.client.field_1772, (class_2561)class_2561.method_43470((String)chatMacro.displayName), (int)((double)x + (double)width / 2.0), (int)((double)y + 7.5 - 3.5), -1);
            }
        });
        return screenEntryList;
    }

    public static ScreenEntryList<StringHolder> stringListScreen(ClientContext ctx, int panelWidth, List<StringHolder> data) {
        return new ScreenEntryList<StringHolder>(ctx, panelWidth, false, data, datum -> new StringEntryWidgetsProvider(ctx, panelWidth).getWidgets((StringHolder)datum), StringHolder::new);
    }

    public static <T> int calcPanelWidth(EntryWidgetsProvider<T> entryWidgetsProvider, DataGenerator<T> dataGenerator) {
        T datum = dataGenerator.generate();
        List<class_339> widgets = entryWidgetsProvider.getWidgets(datum);
        if (widgets.isEmpty()) {
            return 0;
        }
        if (widgets.size() == 1) {
            return widgets.getFirst().method_25368();
        }
        int width = widgets.getFirst().method_25368();
        for (int i = 1; i < widgets.size(); ++i) {
            width += widgets.get(i).method_25368() + 3;
        }
        return width;
    }

    public ScreenEntryList(ClientContext ctx, int panelWidth, boolean alignRight, List<T> data, EntryWidgetsProvider<T> entryWidgetsProvider, DataGenerator<T> dataGenerator) {
        this(ctx, panelWidth, 10, alignRight, data, entryWidgetsProvider, dataGenerator);
    }

    public ScreenEntryList(ClientContext ctx, int panelWidth, int rowCount, boolean alignRight, List<T> data, EntryWidgetsProvider<T> entryWidgetsProvider, DataGenerator<T> dataGenerator) {
        super(ctx);
        this.panelWidth = panelWidth;
        if (rowCount < 3) {
            rowCount = 3;
        }
        this.rowCount = rowCount;
        this.alignRight = alignRight;
        this.data = data;
        this.entryWidgetsProvider = entryWidgetsProvider;
        this.dataGenerator = dataGenerator;
        this.scrollDataOffset = 0;
    }

    @Override
    protected void method_25426() {
        ModPanel panelMain;
        ModPanel panelOperation;
        if (this.alignRight) {
            panelOperation = this.createPanel(ModScreen.InnerPosition.RIGHT_MIDDLE, ScreenEntryList.calcWidth(3), ScreenEntryList.calcHeight(this.rowCount));
            panelMain = this.appendPanel(panelOperation, ModScreen.OuterPosition.LEFT_MIDDLE, this.panelWidth, ScreenEntryList.calcHeight(this.rowCount), true);
        } else {
            panelMain = this.createPanel(ModScreen.InnerPosition.CENTER, this.panelWidth, ScreenEntryList.calcHeight(this.rowCount));
            panelMain.move(-ScreenEntryList.calcWidth(3) / 2, 0);
            panelOperation = this.appendPanel(panelMain, ModScreen.OuterPosition.RIGHT_MIDDLE, ScreenEntryList.calcWidth(3), ScreenEntryList.calcHeight(this.rowCount), true);
        }
        ModPanel panelAdd = this.appendPanel(panelMain, ModScreen.OuterPosition.LEFT_TOP, ScreenEntryList.calcWidth(1), ScreenEntryList.calcHeight(1), true);
        ModPanel panelScroll = this.appendPanel(panelMain, ModScreen.OuterPosition.LEFT_BOTTOM, ScreenEntryList.calcWidth(1), ScreenEntryList.calcHeight(2), true);
        int i = this.scrollDataOffset;
        int j = 0;
        while (i < this.scrollDataOffset + this.rowCount && i < this.data.size()) {
            T datum = this.data.get(i);
            int appendX = 0;
            List<class_339> widgets = this.entryWidgetsProvider.getWidgets(datum);
            if (!widgets.isEmpty()) {
                panelMain.addDrawableChild(widgets.getFirst());
                appendX = widgets.getFirst().method_25368() + 3;
            }
            if (widgets.size() > 1) {
                for (int k = 1; k < widgets.size(); ++k) {
                    panelMain.addDrawableChild(widgets.get(k), appendX, j * 18);
                    appendX += widgets.get(k).method_25368() + 3;
                }
            }
            ++i;
            ++j;
        }
        this.addPanel(panelMain);
        i = this.scrollDataOffset;
        j = 0;
        while (i < this.scrollDataOffset + this.rowCount && i < this.data.size()) {
            int finalI = i++;
            panelOperation.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.add, button -> {
                this.data.add(finalI + 1, this.dataGenerator.generate());
                this.method_41843();
            }), 0, j * 18);
            panelOperation.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.remove, button -> {
                this.data.remove(finalI);
                this.method_41843();
            }), 18, j * 18);
            panelOperation.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.up, button -> {
                if (finalI > 0) {
                    T temp = this.data.get(finalI);
                    this.data.set(finalI, this.data.get(finalI - 1));
                    this.data.set(finalI - 1, temp);
                    this.method_41843();
                }
            }), 36, j * 18);
            ++j;
        }
        this.addPanel(panelOperation);
        panelAdd.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.add, button -> {
            this.data.add(this.dataGenerator.generate());
            this.goBottom();
        }));
        this.addPanel(panelAdd);
        panelScroll.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.up, button -> this.goTop()));
        panelScroll.addDrawableChild((class_339)new ModButton(15, RhiTexts.common.icon.down, button -> this.goBottom()));
        this.addPanel(panelScroll);
        super.method_25426();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.customScreenRenderer != null) {
            this.customScreenRenderer.render(context, mouseX, mouseY, delta);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    @Override
    protected void method_41843() {
        if (this.data.size() >= this.rowCount && this.scrollDataOffset > this.data.size() - this.rowCount) {
            this.scrollDataOffset = this.data.size() - this.rowCount;
        }
        super.method_41843();
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int _scrollDataOffset = this.scrollDataOffset;
        if (verticalAmount != 0.0 && this.data.size() > this.rowCount) {
            _scrollDataOffset = verticalAmount < 0.0 ? ++_scrollDataOffset : --_scrollDataOffset;
            if (_scrollDataOffset < 0) {
                _scrollDataOffset = 0;
            }
            if (_scrollDataOffset > this.data.size() - this.rowCount) {
                _scrollDataOffset = this.data.size() - this.rowCount;
            }
            if (_scrollDataOffset != this.scrollDataOffset) {
                this.scrollDataOffset = _scrollDataOffset;
                this.method_41843();
                return true;
            }
        } else {
            this.scrollDataOffset = 0;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void goTop() {
        this.scrollDataOffset = 0;
        this.method_41843();
    }

    private void goBottom() {
        if (this.data.size() > this.rowCount) {
            this.scrollDataOffset = this.data.size() - this.rowCount;
            this.method_41843();
        } else {
            this.goTop();
        }
    }

    public void setCustomScreenRenderer(@NotNull ScreenRenderer customScreenRenderer) {
        this.customScreenRenderer = customScreenRenderer;
    }

    public static interface ScreenRenderer {
        public void render(class_332 var1, int var2, int var3, float var4);
    }
}

