/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.screen.screens;

import dev.nymnux.rhizome.Rhizome;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.config.string.StringHolder;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.container.ModPanel;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.render.RenderUtil;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import org.jetbrains.annotations.Nullable;

public class ScreenCoordInput
extends ModScreen {
    private static final int BUTTON_WIDTH = 100;
    private static final String SINGLE_COORD = "[+-]?\\d+(?:\\.\\d+)?";
    private static final Pattern PATTERN = Pattern.compile("^\\s*([+-]?\\d+(?:\\.\\d+)?)\\s*[,\\s]+\\s*([+-]?\\d+(?:\\.\\d+)?)\\s*[,\\s]+\\s*([+-]?\\d+(?:\\.\\d+)?)\\s*$");
    private final StringHolder x = new StringHolder();
    private final StringHolder y = new StringHolder();
    private final StringHolder z = new StringHolder();
    private ModButton btnX;
    private ModButton btnY;
    private ModButton btnZ;
    private int focused = -1;
    private final Consumer<class_2338> callback;

    public ScreenCoordInput(ClientContext ctx, Consumer<class_2338> callback) {
        super(ctx);
        this.callback = callback;
        this.fromClipboard(ctx);
    }

    @Override
    protected void method_25426() {
        int panelWidth = 306;
        ModPanel panel = this.createPanel(ModScreen.InnerPosition.CENTER, panelWidth, ScreenCoordInput.calcHeight(2));
        int buttonColor = ModConfig.getInstance().cfgColorGui.buttonColor;
        this.btnX = new ModButton(100, (class_2561)class_2561.method_43473(), button -> {
            this.x.str = "";
            this.focused = 0;
        });
        this.btnX.setCustomBGColorHovered(buttonColor);
        panel.addDrawableChild((class_339)this.btnX);
        this.btnY = new ModButton(100, (class_2561)class_2561.method_43473(), button -> {
            this.y.str = "";
            this.focused = 1;
        });
        this.btnY.setCustomBGColorHovered(buttonColor);
        panel.addDrawableChild((class_339)this.btnY, 103, 0);
        this.btnZ = new ModButton(100, (class_2561)class_2561.method_43473(), button -> {
            this.z.str = "";
            this.focused = 2;
        });
        this.btnZ.setCustomBGColorHovered(buttonColor);
        panel.addDrawableChild((class_339)this.btnZ, 206, 0);
        panel.addDrawableChild((class_339)new ModButton(panelWidth, RhiTexts.common.message.done, button -> this.parseCoord().ifPresent(blockPos -> {
            this.callback.accept((class_2338)blockPos);
            ScreenCoordInput.closeScreen();
        })));
        this.addPanel(panel);
        super.method_25426();
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        if (this.btnX == null || this.btnY == null || this.btnZ == null) {
            return;
        }
        context.method_25300(this.field_22793, this.x.str, this.btnX.method_46426() + this.btnX.method_25368() / 2, (int)((double)(this.btnX.method_46427() + this.btnX.method_25364() / 2) - 3.5), -1);
        context.method_25300(this.field_22793, this.y.str, this.btnY.method_46426() + this.btnY.method_25368() / 2, (int)((double)(this.btnY.method_46427() + this.btnY.method_25364() / 2) - 3.5), -1);
        context.method_25300(this.field_22793, this.z.str, this.btnZ.method_46426() + this.btnZ.method_25368() / 2, (int)((double)(this.btnZ.method_46427() + this.btnZ.method_25364() / 2) - 3.5), -1);
        if (this.focused == -1) {
            return;
        }
        int focusedX = this.focused == 0 ? this.btnX.method_46426() : (this.focused == 1 ? this.btnY.method_46426() : this.btnZ.method_46426());
        RenderUtil.drawOutlineQuad(context, focusedX, this.btnX.method_46427(), 100, 15, -1);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            ScreenCoordInput.closeScreen();
            return true;
        }
        StringHolder focusedCoord = this.getFocusedCoord();
        if (focusedCoord == null) {
            return false;
        }
        if (keyCode == 259) {
            if (!focusedCoord.str.isEmpty()) {
                focusedCoord.str = focusedCoord.str.substring(0, focusedCoord.str.length() - 1);
            }
        } else if (keyCode == 257 || keyCode == 335) {
            if (focusedCoord == this.z) {
                this.parseCoord().ifPresent(blockPos -> {
                    this.callback.accept((class_2338)blockPos);
                    ScreenCoordInput.closeScreen();
                });
            } else {
                ++this.focused;
                StringHolder s = this.getFocusedCoord();
                if (s != null) {
                    s.str = "";
                }
            }
        } else if (keyCode == 258) {
            this.focused = (this.focused + 1) % 3;
            StringHolder s = this.getFocusedCoord();
            if (s != null) {
                s.str = "";
            }
        } else {
            Character c = null;
            if (keyCode >= 48 && keyCode <= 57) {
                c = Character.valueOf((char)(48 + (keyCode - 48)));
            } else if (keyCode >= 320 && keyCode <= 329) {
                c = Character.valueOf((char)(48 + (keyCode - 320)));
            } else if (keyCode == 45 || keyCode == 333) {
                c = Character.valueOf('-');
            }
            if (c != null) {
                focusedCoord.str = focusedCoord.str + c;
            }
        }
        return false;
    }

    private Optional<class_2338> parseCoord() {
        String s = this.x.str + " " + this.y.str + " " + this.z.str;
        Rhizome.LOGGER.info(s);
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            int x = (int)Double.parseDouble(matcher.group(1));
            int y = (int)Double.parseDouble(matcher.group(2));
            int z = (int)Double.parseDouble(matcher.group(3));
            return Optional.of(new class_2338(x, y, z));
        }
        return Optional.empty();
    }

    private void fromClipboard(ClientContext ctx) {
        String s = ctx.client.field_1774.method_1460();
        Matcher matcher = PATTERN.matcher(s);
        if (matcher.matches()) {
            int x = (int)Double.parseDouble(matcher.group(1));
            int y = (int)Double.parseDouble(matcher.group(2));
            int z = (int)Double.parseDouble(matcher.group(3));
            this.x.str = String.valueOf(x);
            this.y.str = String.valueOf(y);
            this.z.str = String.valueOf(z);
        }
    }

    @Nullable
    private StringHolder getFocusedCoord() {
        if (this.focused == 0) {
            return this.x;
        }
        if (this.focused == 1) {
            return this.y;
        }
        if (this.focused == 2) {
            return this.z;
        }
        return null;
    }
}

