/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.gadget;

import dev.nymnux.rhizome.config.CfgPartyWaypointShare;
import dev.nymnux.rhizome.config.CfgRareEvent;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.keybind.RhiKeyBinds;
import dev.nymnux.rhizome.module.AModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.modules.render.SimpleTitleContainer;
import dev.nymnux.rhizome.util.BlockUtil;
import dev.nymnux.rhizome.util.ChatUtil;
import dev.nymnux.rhizome.util.SoundUtil;
import dev.nymnux.rhizome.util.io.KeyBindUtil;
import dev.nymnux.rhizome.util.math.HistoryBuffer;
import dev.nymnux.rhizome.util.math.ProjectionUtil;
import dev.nymnux.rhizome.util.math.Vec2d;
import dev.nymnux.rhizome.util.render.RenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class PartyWaypointShare
extends AModModule {
    private static final Pattern PATTERN = Pattern.compile(".*?Party > (\\[.*?] )?(\\w+): X: (-?\\d+) Y: (-?\\d+) Z: (-?\\d+) \\| (.+)$");
    private static final HistoryBuffer<class_2338> selfPos = new HistoryBuffer(5);
    private static final List<PartyWaypoint> partyWaypoints = new ArrayList<PartyWaypoint>();
    @Nullable
    private static String lastRareEventMessage = null;
    private static int timer = 0;

    @Override
    public void onClientTickStart(ClientContext ctx) {
        if (KeyBindUtil.getState(RhiKeyBinds.keyPartyWaypoint).onPress()) {
            PartyWaypointShare.shareWaypoint(ctx, lastRareEventMessage != null ? lastRareEventMessage : "Unknown");
        }
        if (timer > 0) {
            --timer;
        } else {
            lastRareEventMessage = null;
        }
    }

    @Override
    public void onClientTickEnd(ClientContext ctx) {
        class_243 pos = ctx.player.method_19538();
        int interactRadius = ModConfig.getInstance().cfgPartyWaypointShare.interactRadius;
        partyWaypoints.removeIf(partyWaypoint -> {
            double distance = pos.method_1022(partyWaypoint.pos.method_46558());
            return distance < (double)interactRadius;
        });
    }

    @Override
    public void onChatTrigger(ClientContext ctx, class_2561 raw, String message2) {
        PartyWaypointShare.onRareEvent(ctx, message2);
        PartyWaypointShare.phasePlayerWaypoint(ctx, message2).ifPresent(partyWaypoint -> {
            if (selfPos.contains(partyWaypoint.pos) || partyWaypoints.contains(partyWaypoint)) {
                return;
            }
            partyWaypoints.add((PartyWaypoint)partyWaypoint);
            CfgPartyWaypointShare config2 = ModConfig.getInstance().cfgPartyWaypointShare;
            SimpleTitleContainer.addTitle((class_2561)class_2561.method_43470((String)partyWaypoint.info).method_10862(class_2583.field_24360.method_36139(config2.messageColor)));
            SoundUtil.getVanillaSound(config2.soundEffect).ifPresent(arg_0 -> ((class_746)ctx.player).method_43077(arg_0));
        });
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        float guiScale = ClientContext.getScaleFactor(ctx);
        float resizedGuiScale = 1.0f / guiScale;
        matrixStack.pushMatrix();
        matrixStack.scale(resizedGuiScale, resizedGuiScale);
        CfgPartyWaypointShare config2 = ModConfig.getInstance().cfgPartyWaypointShare;
        for (PartyWaypoint waypoint : partyWaypoints) {
            class_640 playerListEntry;
            double scale;
            matrixStack.pushMatrix();
            class_243 pos = waypoint.pos.method_46558();
            ProjectionUtil.ProjectResult result = ProjectionUtil.project(ctx, pos, tickDelta);
            Vec2d screenPos = result.screenPos();
            boolean onScreen = RenderUtil.checkAndLockOnScreen(ctx, screenPos);
            double dist = pos.method_1022(ctx.client.field_1773.method_19418().method_19326());
            if (dist > (double)config2.minScaleDistance) {
                dist = config2.minScaleDistance;
            }
            double d = scale = Double.isNaN(scale = config2.scale / dist) ? Double.MAX_VALUE : scale;
            if (onScreen) {
                scale /= result.rawFov() / 70.0;
            }
            matrixStack.translate((float)screenPos.m, (float)(screenPos.n - scale * 4.0));
            matrixStack.scale((float)scale, (float)scale);
            drawContext.method_25300(ctx.client.field_1772, waypoint.info, 0, 0, config2.messageColor);
            if (config2.showPlayerHead && (playerListEntry = ctx.player.field_3944.method_2871(waypoint.player)) != null) {
                class_8685 skin = playerListEntry.method_52810();
                class_7532.method_52722((class_332)drawContext, (class_8685)skin, (int)-8, (int)-20, (int)16);
            }
            matrixStack.popMatrix();
        }
        matrixStack.popMatrix();
    }

    @Override
    public void onClientWorldJoinEnd(ClientContext ctx) {
        PartyWaypointShare.clear();
    }

    public static void shareWaypoint(ClientContext ctx, String message2) {
        BlockUtil.getCameraPlaceBlockPos(ctx).ifPresent(pos -> {
            selfPos.add((class_2338)pos);
            ChatUtil.sendChatMessage(ctx, "/pchat X: " + pos.method_10263() + " Y: " + pos.method_10264() + " Z: " + pos.method_10260() + " | " + message2);
        });
    }

    private static void onRareEvent(ClientContext ctx, String message2) {
        CfgPartyWaypointShare config2 = ModConfig.getInstance().cfgPartyWaypointShare;
        for (CfgRareEvent rareEvent : ModConfig.getInstance().cfgRareEvents) {
            if (!message2.contains(rareEvent.event)) continue;
            lastRareEventMessage = rareEvent.message;
            timer = config2.rareEventDuration;
            SimpleTitleContainer.addTitle((class_2561)class_2561.method_43470((String)rareEvent.message).method_10862(class_2583.field_24360.method_36139(config2.messageColor)));
            SoundUtil.getVanillaSound(config2.soundEffect).ifPresent(arg_0 -> ((class_746)ctx.player).method_43077(arg_0));
            return;
        }
    }

    public static void clear() {
        selfPos.clear();
        partyWaypoints.clear();
    }

    private static Optional<PartyWaypoint> phasePlayerWaypoint(ClientContext ctx, String message2) {
        Matcher matcher = PATTERN.matcher(message2);
        if (matcher.matches()) {
            String player = matcher.group(2);
            int x = Integer.parseInt(matcher.group(3));
            int y = Integer.parseInt(matcher.group(4));
            int z = Integer.parseInt(matcher.group(5));
            String info = matcher.group(6);
            class_640 playerListEntry = ctx.player.field_3944.method_2874(player);
            if (playerListEntry != null) {
                return Optional.of(new PartyWaypoint(new class_2338(x, y, z), playerListEntry.method_2966().getId(), info));
            }
        }
        return Optional.empty();
    }

    private record PartyWaypoint(class_2338 pos, UUID player, String info) {
        @Override
        public boolean equals(Object o) {
            if (o instanceof PartyWaypoint) {
                PartyWaypoint p = (PartyWaypoint)o;
                return p.player.equals(this.player) && p.info.equals(this.info);
            }
            return false;
        }
    }
}

