/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.profile;

import dev.nymnux.rhizome.config.CfgFishingTimer;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.RhiTexts;
import dev.nymnux.rhizome.util.ToastUtil;
import dev.nymnux.rhizome.util.io.CsvLoader;
import dev.nymnux.rhizome.util.string.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PrfFishingTimerLoader {
    public static void importProfile(ClientContext ctx) {
        String path = ctx.client.field_1697.getPath() + "/config/rhizome/profile/fishing_timer/timer.csv";
        List<String[]> profile = CsvLoader.readCsv(new File(path));
        if (profile == null || profile.size() < 41) {
            ToastUtil.addToast(RhiTexts.toast.fishing_timer.failed_to_import, "");
            return;
        }
        Object[] ticks = new TimerTick[41];
        Arrays.fill(ticks, new TimerTick());
        for (int i = 0; i < 41; ++i) {
            String[] tick = profile.get(i);
            if (tick == null || tick.length < 4) continue;
            ticks[i] = new TimerTick(tick[0], tick[1], StringUtil.getDouble(tick[2], 1.0), StringUtil.getInt(tick[3], 12));
        }
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        for (int i = 0; i < 41; ++i) {
            config2.timerBar[i] = ((TimerTick)ticks[i]).bar;
            config2.soundEffects[i].id = ((TimerTick)ticks[i]).soundId;
            config2.soundEffects[i].volume = ((TimerTick)ticks[i]).volume;
            config2.soundEffects[i].pitch = ((TimerTick)ticks[i]).pitch;
        }
    }

    public static boolean exportProfile(ClientContext ctx) {
        String path = ctx.client.field_1697.getPath() + "/config/rhizome/profile/fishing_timer/timer.csv";
        ArrayList<String[]> profile = new ArrayList<String[]>();
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        for (int i = 0; i < 41; ++i) {
            profile.add(new String[]{config2.timerBar[i], config2.soundEffects[i].id, String.valueOf(config2.soundEffects[i].volume), String.valueOf(config2.soundEffects[i].pitch)});
        }
        return CsvLoader.writeCsv(new File(path), profile);
    }

    public static class TimerTick {
        public String bar;
        public String soundId;
        public double volume;
        public int pitch;

        public TimerTick() {
            this("", "", 1.0, 12);
        }

        public TimerTick(String bar, String soundId, double volume, int pitch) {
            this.bar = bar;
            this.soundId = soundId;
            this.volume = volume;
            this.pitch = pitch;
        }
    }
}

