/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.util.io;

import dev.nymnux.rhizome.Rhizome;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class CsvLoader {
    public static List<String[]> readCsv(File file) {
        if (!file.exists()) {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                Rhizome.LOGGER.info("Failed to create directory: {}", (Object)file.getParentFile().getPath());
                return null;
            }
            try {
                if (file.createNewFile()) {
                    Rhizome.LOGGER.info("Created new CSV file: {}", (Object)file.getPath());
                } else {
                    Rhizome.LOGGER.info("Failed to create CSV file: {}", (Object)file.getPath());
                }
            }
            catch (IOException e) {
                Rhizome.LOGGER.info("Failed to create CSV file {}: {}", (Object)file.getPath(), (Object)e.getMessage());
            }
            return null;
        }
        ArrayList<String[]> data = new ArrayList<String[]>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                String[] values = line.split(",");
                data.add(values);
            }
        }
        catch (IOException e) {
            Rhizome.LOGGER.info("Failed to read CSV file {}: {}", (Object)file.getPath(), (Object)e.getMessage());
        }
        return data.isEmpty() ? null : data;
    }

    public static boolean writeCsv(File file, List<String[]> data) {
        boolean bl;
        if (!file.exists()) {
            if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                Rhizome.LOGGER.info("Failed to create directory: {}", (Object)file.getParentFile().getPath());
                return false;
            }
            try {
                if (file.createNewFile()) {
                    Rhizome.LOGGER.info("Created new CSV file: {}", (Object)file.getPath());
                } else {
                    Rhizome.LOGGER.info("Failed to create CSV file: {}", (Object)file.getPath());
                }
            }
            catch (IOException e) {
                Rhizome.LOGGER.info("Failed to create CSV file {}: {}", (Object)file.getPath(), (Object)e.getMessage());
                return false;
            }
        }
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
        try {
            for (CharSequence[] charSequenceArray : data) {
                String line = String.join((CharSequence)",", charSequenceArray);
                bw.write(line + "\n");
            }
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                Rhizome.LOGGER.info("Failed to write CSV file {}: {}", (Object)file.getPath(), (Object)e.getMessage());
                return false;
            }
        }
        bw.close();
        return bl;
    }
}

