/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.gui.module;

import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.widget.ModButton;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.text.ModuleButtonText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleButton {
    private final ModuleButtonText moduleButtonText;
    @NotNull
    private final PressAction onLeftClick;
    @Nullable
    private PressAction onRightClick = null;
    @Nullable
    private PressAction onMiddleClick = null;

    public ModuleButton(ModuleButtonText moduleButtonText, @NotNull PressAction onLeftClick) {
        this.moduleButtonText = moduleButtonText;
        this.onLeftClick = onLeftClick;
    }

    public ModuleButton(ModuleButtonText moduleButtonText, @NotNull PressAction onLeftClick, @NotNull PressAction onRightClick) {
        this.moduleButtonText = moduleButtonText;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
    }

    public ModuleButton(ModuleButtonText moduleButtonText, @NotNull PressAction onLeftClick, @NotNull PressAction onRightClick, @NotNull PressAction onMiddleClick) {
        this.moduleButtonText = moduleButtonText;
        this.onLeftClick = onLeftClick;
        this.onRightClick = onRightClick;
        this.onMiddleClick = onMiddleClick;
    }

    public ModButton getButtonWidget(ClientContext ctx) {
        PressAction lc = this.onLeftClick;
        PressAction rc = this.onRightClick != null ? this.onRightClick : this.onLeftClick;
        PressAction mc = this.onMiddleClick != null ? this.onMiddleClick : this.onLeftClick;
        ModButton modButton = new ModButton(15, this.moduleButtonText.icon.getText(), button -> lc.onPress(ctx), button -> rc.onPress(ctx), button -> mc.onPress(ctx));
        ModScreen.setMouseClickTooltip(modButton, this.moduleButtonText);
        return modButton;
    }

    public static interface PressAction {
        public void onPress(ClientContext var1);
    }
}

