/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.skyblock.dungeon;

import dev.nymnux.rhizome.config.CfgDragonSplit;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.AModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4587;

public class DragonSplit
extends AModModule {
    private static final List<Dragons> ARCHER_PRIORITY = List.of(Dragons.PURPLE, Dragons.BLUE, Dragons.RED, Dragons.GREEN, Dragons.ORANGE);
    private static final Pattern PATTERN = Pattern.compile("The\\s(Purple|Blue|Red|Green|Orange)\\sdragon\\swill\\sspawn\\ssoon!");
    private static final int NOTIFICATION_DURATION = 60;
    private static final int TRIGGER_THRESHOLD = 30;
    private static int notificationTimer = 0;
    private static int triggerTimer = 0;
    private static Dragons dragonCache = null;
    private static Dragons archerDragon = null;
    private static Dragons mageDragon = null;

    @Override
    public void onClientTickStart(ClientContext ctx) {
        if (triggerTimer == 1) {
            dragonCache = null;
        }
        if (triggerTimer > 0) {
            --triggerTimer;
        }
        if (notificationTimer == 1) {
            archerDragon = null;
            mageDragon = null;
        }
        if (notificationTimer > 0) {
            --notificationTimer;
        }
    }

    @Override
    public void onChatTrigger(ClientContext ctx, class_2561 message2) {
        Matcher matcher = PATTERN.matcher(message2.getString());
        if (!matcher.find()) {
            return;
        }
        Dragons dragon = Dragons.valueOf(matcher.group(1).toUpperCase());
        if (dragonCache == null) {
            dragonCache = dragon;
            triggerTimer = 30;
        } else if (dragonCache != dragon && triggerTimer > 0) {
            this.figurePriority(dragonCache, dragon);
            dragonCache = null;
            triggerTimer = 0;
            notificationTimer = 60;
            ctx.player.method_43077((class_3414)class_3417.field_14622.comp_349());
        }
    }

    private void figurePriority(Dragons dragon1, Dragons dragon2) {
        int index2;
        int index1 = ARCHER_PRIORITY.indexOf((Object)dragon1);
        if (index1 < (index2 = ARCHER_PRIORITY.indexOf((Object)dragon2))) {
            archerDragon = dragon1;
            mageDragon = dragon2;
        } else {
            archerDragon = dragon2;
            mageDragon = dragon1;
        }
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        if (notificationTimer == 0 || archerDragon == null || mageDragon == null) {
            return;
        }
        class_4587 matrixStack = drawContext.method_51448();
        float resizedGuiScale = 1.0f / ClientContext.getScaleFactor(ctx);
        double windowWidth = ctx.client.method_22683().method_4489();
        double windowHeight = ctx.client.method_22683().method_4506();
        CfgDragonSplit config2 = ModConfig.getInstance().cfgDragonSplit;
        float scale = (float)config2.scale;
        matrixStack.method_22903();
        matrixStack.method_22905(resizedGuiScale, resizedGuiScale, 1.0f);
        matrixStack.method_22903();
        matrixStack.method_22904(windowWidth * config2.labelX, windowHeight * config2.labelY, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        drawContext.method_25300(ctx.client.field_1772, "A", 0, 0, -1);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22904(windowWidth * (1.0 - config2.labelX), windowHeight * config2.labelY, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        drawContext.method_25300(ctx.client.field_1772, "M", 0, 0, -1);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22904(windowWidth * config2.labelX, windowHeight * config2.dragonY, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        drawContext.method_25300(ctx.client.field_1772, archerDragon.getName(), 0, 0, archerDragon.getColor());
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22904(windowWidth * (1.0 - config2.labelX), windowHeight * config2.dragonY, 0.0);
        matrixStack.method_22905(scale, scale, 1.0f);
        drawContext.method_25300(ctx.client.field_1772, mageDragon.getName(), 0, 0, mageDragon.getColor());
        matrixStack.method_22909();
        matrixStack.method_22909();
    }

    public static enum Dragons {
        PURPLE("Purple", -5635926),
        BLUE("Blue", -11184641),
        RED("Red", -43691),
        GREEN("Green", -11141291),
        ORANGE("Orange", -22016);

        private final String name;
        private final int color;

        private Dragons(String name, int color2) {
            this.name = name;
            this.color = color2;
        }

        public int getColor() {
            return this.color;
        }

        public String getName() {
            return this.name;
        }
    }
}

