/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.gadget;

import dev.nymnux.rhizome.config.CfgPartyWaypointShare;
import dev.nymnux.rhizome.config.CfgRareEvent;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.keybind.RhiKeyBinds;
import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.SimpleEvents;
import dev.nymnux.rhizome.module.modules.keybind.KeyBindManager;
import dev.nymnux.rhizome.module.modules.render.SimpleTitleContainer;
import dev.nymnux.rhizome.util.BlockUtil;
import dev.nymnux.rhizome.util.ChatUtil;
import dev.nymnux.rhizome.util.SoundUtil;
import dev.nymnux.rhizome.util.array.SimpleQueue;
import dev.nymnux.rhizome.util.render.HudRenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_332;
import net.minecraft.class_640;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_8685;
import org.joml.Matrix3x2fStack;
import org.joml.Vector2d;

public class PartyWaypointShare
implements ModModule {
    private static final Pattern PATTERN = Pattern.compile(".*?Party > (\\[.*?] )?(\\w+): X: (-?\\d+) Y: (-?\\d+) Z: (-?\\d+) \\| (.+)$");
    private static final int REMOVE_COOLDOWN = 100;
    private static final SimpleQueue<class_2338> selfPos = new SimpleQueue(3);
    private static final List<PartyWaypoint> partyWaypoints = new ArrayList<PartyWaypoint>();
    private static final SimpleQueue<RareEvent> lastRareEvents = new SimpleQueue(3);

    @Override
    public void onClientTickStart(ClientContext ctx) {
        if (!KeyBindManager.hasScreen(ctx) && KeyBindManager.getContext(RhiKeyBinds.keyPartyWaypoint).onPress()) {
            String message2 = "Unknown";
            if (!lastRareEvents.isEmpty()) {
                message2 = PartyWaypointShare.lastRareEvents.popOldest().event;
            }
            PartyWaypointShare.shareWaypoint(ctx, message2);
        }
    }

    @Override
    public void onClientTickEnd(ClientContext ctx) {
        class_243 pos = ctx.player.method_24515().method_46558();
        int interactRadius = ModConfig.getInstance().cfgPartyWaypointShare.interactRadius;
        partyWaypoints.removeIf(partyWaypoint -> {
            if (partyWaypoint.removeCooldown > 0) {
                --partyWaypoint.removeCooldown;
                return false;
            }
            double distance = pos.method_1022(partyWaypoint.pos.method_46558());
            return distance < (double)interactRadius;
        });
        lastRareEvents.removeIf(rareEvent -> {
            ++rareEvent.timer;
            return rareEvent.timer == rareEvent.duration;
        });
    }

    private void onChatTrigger(ClientContext ctx, class_2561 raw, String message2) {
        PartyWaypointShare.onRareEvent(ctx, message2);
        PartyWaypointShare.phasePlayerWaypoint(ctx, message2).ifPresent(partyWaypoint -> {
            if (selfPos.contains(partyWaypoint.pos) || partyWaypoints.contains(partyWaypoint)) {
                return;
            }
            partyWaypoints.add((PartyWaypoint)partyWaypoint);
            CfgPartyWaypointShare config2 = ModConfig.getInstance().cfgPartyWaypointShare;
            SimpleTitleContainer.addTitle((class_2561)class_2561.method_43470((String)partyWaypoint.info).method_10862(class_2583.field_24360.method_36139(config2.messageColor)));
            SoundUtil.getVanillaSound(config2.soundEffect).ifPresent(arg_0 -> ((class_746)ctx.player).method_43077(arg_0));
        });
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        float guiScale = ClientContext.getScaleFactor(ctx);
        float resizedGuiScale = 1.0f / guiScale;
        matrixStack.pushMatrix();
        matrixStack.scale(resizedGuiScale, resizedGuiScale);
        CfgPartyWaypointShare config2 = ModConfig.getInstance().cfgPartyWaypointShare;
        for (PartyWaypoint waypoint : partyWaypoints) {
            class_640 playerListEntry;
            matrixStack.pushMatrix();
            class_243 pos = waypoint.pos.method_46558();
            Vector2d screenPos = HudRenderUtil.getAlwaysOnScreenPos(ctx, pos, tickDelta);
            double scale = config2.scale;
            matrixStack.translate((float)screenPos.x, (float)(screenPos.y - scale * 4.5));
            matrixStack.scale((float)scale, (float)scale);
            drawContext.method_25300(ctx.client.field_1772, waypoint.info, 0, 0, config2.messageColor);
            if (config2.showPlayerHead && (playerListEntry = ctx.player.field_3944.method_2871(waypoint.player)) != null) {
                class_8685 skin = playerListEntry.method_52810();
                class_7532.method_52722((class_332)drawContext, (class_8685)skin, (int)-8, (int)-20, (int)16);
            }
            matrixStack.popMatrix();
        }
        matrixStack.popMatrix();
    }

    @Override
    public void onClientWorldJoinEnd(ClientContext ctx) {
        PartyWaypointShare.clear();
    }

    public static void shareWaypoint(ClientContext ctx, String message2) {
        BlockUtil.getCameraPlaceBlockPos(ctx).ifPresent(pos -> {
            selfPos.push((class_2338)pos);
            ChatUtil.sendChatMessage(ctx, "/pchat X: " + pos.method_10263() + " Y: " + pos.method_10264() + " Z: " + pos.method_10260() + " | " + message2);
        });
    }

    private static void onRareEvent(ClientContext ctx, String chatMessage) {
        CfgPartyWaypointShare config2 = ModConfig.getInstance().cfgPartyWaypointShare;
        for (CfgRareEvent rareEvent : ModConfig.getInstance().cfgRareEvents) {
            if (!chatMessage.contains(rareEvent.event)) continue;
            lastRareEvents.push(new RareEvent(rareEvent.message, config2.rareEventDuration));
            SimpleTitleContainer.addTitle((class_2561)class_2561.method_43470((String)rareEvent.message).method_10862(class_2583.field_24360.method_36139(config2.messageColor)));
            SoundUtil.getVanillaSound(config2.soundEffect).ifPresent(arg_0 -> ((class_746)ctx.player).method_43077(arg_0));
            return;
        }
    }

    public static void clear() {
        selfPos.clear();
        partyWaypoints.clear();
        lastRareEvents.clear();
    }

    private static Optional<PartyWaypoint> phasePlayerWaypoint(ClientContext ctx, String message2) {
        Matcher matcher = PATTERN.matcher(message2);
        if (matcher.matches()) {
            String player = matcher.group(2);
            int x = Integer.parseInt(matcher.group(3));
            int y = Integer.parseInt(matcher.group(4));
            int z = Integer.parseInt(matcher.group(5));
            String info = matcher.group(6);
            class_640 playerListEntry = ctx.player.field_3944.method_2874(player);
            if (playerListEntry != null) {
                return Optional.of(new PartyWaypoint(new class_2338(x, y, z), playerListEntry.method_2966().getId(), info));
            }
        }
        return Optional.empty();
    }

    public PartyWaypointShare() {
        SimpleEvents.CHAT_TRIGGER.register(this::onChatTrigger);
    }

    private static class RareEvent {
        public String event;
        public int duration;
        public int timer = 0;

        public RareEvent(String event, int duration) {
            this.event = event;
            this.duration = duration;
        }
    }

    private static class PartyWaypoint {
        public class_2338 pos;
        public UUID player;
        public String info;
        public int removeCooldown = 100;

        public PartyWaypoint(class_2338 pos, UUID player, String info) {
            this.pos = pos;
            this.player = player;
            this.info = info;
        }

        public boolean equals(Object o) {
            if (o instanceof PartyWaypoint) {
                PartyWaypoint p = (PartyWaypoint)o;
                return p.player.equals(this.player) && p.info.equals(this.info);
            }
            return false;
        }
    }
}

