/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.keybind;

import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.gui.screen.ModScreen;
import dev.nymnux.rhizome.gui.screen.screens.ScreenIndex;
import dev.nymnux.rhizome.gui.screen.screens.ScreenSimpleWarpMenu;
import dev.nymnux.rhizome.keybind.ModKeyBind;
import dev.nymnux.rhizome.keybind.RhiKeyBinds;
import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.modules.keybind.KeyBindContext;
import dev.nymnux.rhizome.util.ChatUtil;
import dev.nymnux.rhizome.util.mixin.IMixinKeyBinding;
import java.util.List;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import org.lwjgl.glfw.GLFW;

public class KeyBindManager
implements ModModule {
    private static Long window = null;

    @Override
    public void onClientTickStart(ClientContext ctx) {
        class_437 class_4372;
        KeyBindManager.syncKeyBindStateStart(ctx);
        KeyBindContext keyIndexContext = KeyBindManager.getContext(RhiKeyBinds.keyIndex);
        if (keyIndexContext.onPress() && !KeyBindManager.hasScreen(ctx)) {
            ModScreen.openScreen(new ScreenIndex(ctx));
        }
        if (keyIndexContext.onRelease() && (class_4372 = ctx.client.field_1755) instanceof ScreenIndex) {
            ScreenIndex screenIndex = (ScreenIndex)class_4372;
            screenIndex.method_25419();
        }
        if (KeyBindManager.getContext(RhiKeyBinds.keyWarpMenu).onPress() && !KeyBindManager.hasScreen(ctx)) {
            if (ModConfig.getInstance().useDefaultWarpMenu) {
                ChatUtil.sendChatMessage(ctx, "/warp");
            } else {
                ModScreen.openScreen(new ScreenSimpleWarpMenu(ctx));
            }
        }
    }

    @Override
    public void onClientTickEnd(ClientContext ctx) {
        KeyBindManager.syncKeyBindStateEnd(ctx);
    }

    private static void syncKeyBindStateStart(ClientContext ctx) {
        for (ModKeyBind class_4372 : RhiKeyBinds.keyBinds) {
            ((IMixinKeyBinding)((Object)class_4372)).rhizome$setKeyDown(KeyBindManager.isKeyOrMouseDown(class_4372));
        }
        for (class_304 class_3042 : KeyBindManager.getClientPlayKeyBinds(ctx)) {
            ((IMixinKeyBinding)class_3042).rhizome$setKeyDown(KeyBindManager.isKeyOrMouseDown(class_3042));
        }
        class_437 class_4372 = ctx.client.field_1755;
        if (class_4372 instanceof ModScreen) {
            ModScreen modScreen = (ModScreen)class_4372;
            if (modScreen.allowMoveControl()) {
                KeyBindManager.syncMoveControlKeyBindState(ctx);
            } else {
                for (class_304 keyBind : KeyBindManager.getMoveControlKeyBinds(ctx)) {
                    keyBind.method_23481(false);
                }
            }
        }
    }

    private static void syncKeyBindStateEnd(ClientContext ctx) {
        for (ModKeyBind modKeyBind : RhiKeyBinds.keyBinds) {
            ((IMixinKeyBinding)((Object)modKeyBind)).rhizome$setKeyDownPre(KeyBindManager.isKeyOrMouseDown(modKeyBind));
        }
        for (class_304 class_3042 : KeyBindManager.getClientPlayKeyBinds(ctx)) {
            ((IMixinKeyBinding)class_3042).rhizome$setKeyDownPre(KeyBindManager.isKeyOrMouseDown(class_3042));
        }
    }

    public static void syncMoveControlKeyBindState(ClientContext ctx) {
        for (class_304 keyBind : KeyBindManager.getMoveControlKeyBinds(ctx)) {
            keyBind.method_23481(KeyBindManager.isKeyOrMouseDown(keyBind));
        }
    }

    public static KeyBindContext getContext(class_304 keyBind) {
        boolean isDown = ((IMixinKeyBinding)keyBind).rhizome$isKeyDown();
        boolean isDownPre = ((IMixinKeyBinding)keyBind).rhizome$isKeyDownPre();
        boolean onPress = isDown && !isDownPre;
        boolean onRelease = !isDown && isDownPre;
        return new KeyBindContext(onPress, isDown, onRelease, KeyBindManager.getModifier());
    }

    public static boolean hasScreen(ClientContext ctx) {
        return ctx.client.field_1755 != null;
    }

    private static KeyBindContext.Modifier getModifier() {
        if (KeyBindManager.isRightButtonDown()) {
            return KeyBindContext.Modifier.WITH_RIGHT_BUTTON;
        }
        if (KeyBindManager.isLeftButtonDown()) {
            return KeyBindContext.Modifier.WITH_LEFT_BUTTON;
        }
        if (KeyBindManager.isShiftDown()) {
            return KeyBindContext.Modifier.WITH_SHIFT;
        }
        if (KeyBindManager.isCtrlDown()) {
            return KeyBindContext.Modifier.WITH_CTRL;
        }
        if (KeyBindManager.isAltDown()) {
            return KeyBindContext.Modifier.WITH_ALT;
        }
        if (KeyBindManager.isTabDown()) {
            return KeyBindContext.Modifier.WITH_TAB;
        }
        return KeyBindContext.Modifier.NORMAL;
    }

    public static boolean isShiftDown() {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetKey((long)window, (int)340) == 1 || GLFW.glfwGetKey((long)window, (int)344) == 1;
    }

    public static boolean isCtrlDown() {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetKey((long)window, (int)341) == 1 || GLFW.glfwGetKey((long)window, (int)345) == 1;
    }

    public static boolean isAltDown() {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetKey((long)window, (int)342) == 1 || GLFW.glfwGetKey((long)window, (int)346) == 1;
    }

    public static boolean isTabDown() {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetKey((long)window, (int)258) == 1;
    }

    public static boolean isLeftButtonDown() {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetMouseButton((long)window, (int)0) == 1;
    }

    public static boolean isRightButtonDown() {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetMouseButton((long)window, (int)1) == 1;
    }

    public static boolean isKeyDown(int glfwCode) {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetKey((long)window, (int)glfwCode) == 1;
    }

    public static boolean isMouseDown(int glfwCode) {
        KeyBindManager.updateWindow();
        return GLFW.glfwGetMouseButton((long)window, (int)glfwCode) == 1;
    }

    public static boolean isKeyOrMouseDown(class_304 keyBind) {
        KeyBindManager.updateWindow();
        class_3675.class_306 key = ((IMixinKeyBinding)keyBind).rhizome$getKey();
        if (key.method_1442() == class_3675.class_307.field_1668) {
            if (key.method_1444() == class_3675.field_16237.method_1444()) {
                return false;
            }
            return GLFW.glfwGetKey((long)window, (int)key.method_1444()) == 1;
        }
        if (key.method_1442() == class_3675.class_307.field_1672) {
            return GLFW.glfwGetMouseButton((long)window, (int)key.method_1444()) == 1;
        }
        return false;
    }

    private static void updateWindow() {
        if (window == null) {
            window = class_310.method_1551().method_22683().method_4490();
        }
    }

    public static List<class_304> getMoveControlKeyBinds(ClientContext ctx) {
        class_315 options = ctx.client.field_1690;
        return List.of(options.field_1894, options.field_1913, options.field_1881, options.field_1849, options.field_1903, options.field_1832, options.field_1867);
    }

    public static List<class_304> getClientPlayKeyBinds(ClientContext ctx) {
        class_315 options = ctx.client.field_1690;
        return List.of(options.field_1894, options.field_1913, options.field_1881, options.field_1849, options.field_1903, options.field_1832, options.field_1867, options.field_1886, options.field_1904, options.field_1871);
    }
}

