/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.skyblock.dungeon;

import dev.nymnux.rhizome.config.CfgUndyingTimer;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.SimpleEvents;
import dev.nymnux.rhizome.util.SoundUtil;
import dev.nymnux.rhizome.util.render.HudRenderUtil;
import java.awt.Color;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_6373;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2d;

public class UndyingTimer
implements ModModule {
    private static Type currType = null;
    private static int timer = 0;

    private void onChatTrigger(ClientContext ctx, class_2561 raw, String message2) {
        Type newType = UndyingTimer.getTypeByChat(message2);
        if (newType != null) {
            currType = newType;
            double pingMillis = ModConfig.getInstance().cfgUndyingTimer.pingMillis;
            int dt = (int)(pingMillis / 50.0 * 2.0);
            timer = Math.max(UndyingTimer.currType.durationTick - dt, 0);
            CfgUndyingTimer.ConfigEntry config2 = UndyingTimer.getConfigEntryByType(currType);
            SoundUtil.getSoundById(config2.sound).ifPresent(soundEvent -> ctx.player.method_5783(soundEvent, (float)config2.volume, 1.0f));
        }
    }

    private void onServerTick(ClientContext ctx, class_6373 packet) {
        if (currType == null || !ModConfig.getInstance().cfgUndyingTimer.useServerTick) {
            return;
        }
        if (timer > 0) {
            --timer;
        }
        if (timer == 0) {
            currType = null;
        }
    }

    @Override
    public void onClientTickStart(ClientContext ctx) {
        if (currType == null || ModConfig.getInstance().cfgUndyingTimer.useServerTick) {
            return;
        }
        if (timer > 0) {
            --timer;
        }
        if (timer == 0) {
            currType = null;
        }
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        if (currType == null || timer == 0) {
            return;
        }
        CfgUndyingTimer config2 = ModConfig.getInstance().cfgUndyingTimer;
        CfgUndyingTimer.ConfigEntry configEntry = UndyingTimer.getConfigEntryByType(currType);
        double timerMillis = 50.0 * (double)((float)timer - tickDelta);
        String timerText = String.format("%.2f s", timerMillis / 1000.0);
        float gradientStart = (float)config2.gradientStart;
        float hue = (float)(timerMillis / ((double)UndyingTimer.currType.durationTick * 50.0)) * gradientStart;
        int timerColor = Color.HSBtoRGB(hue, (float)config2.saturation, 1.0f);
        HudRenderUtil.drawText(ctx, drawContext, (class_2561)class_2561.method_43470((String)configEntry.message), new Vector2d(config2.labelX, config2.labelY), config2.scaleLabel, configEntry.color, true, true, true);
        HudRenderUtil.drawText(ctx, drawContext, (class_2561)class_2561.method_43470((String)timerText), new Vector2d(config2.timerX, config2.timerY), config2.scaleTimer, timerColor, true, true, true);
    }

    @Nullable
    private static Type getTypeByChat(String message2) {
        for (Type type : Type.values()) {
            if (!message2.contains(type.regex)) continue;
            return type;
        }
        return null;
    }

    private static CfgUndyingTimer.ConfigEntry getConfigEntryByType(Type type) {
        CfgUndyingTimer config2 = ModConfig.getInstance().cfgUndyingTimer;
        return switch (type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> config2.bonzo;
            case 1 -> config2.spirit;
            case 2 -> config2.phoenix;
        };
    }

    public static void reset() {
        currType = null;
        timer = 0;
    }

    public UndyingTimer() {
        SimpleEvents.CHAT_TRIGGER.register(this::onChatTrigger);
        SimpleEvents.SERVER_TICK.register(this::onServerTick);
    }

    public static enum Type {
        BONZO("Bonzo's Mask saved your life!", 60),
        SPIRIT("Second Wind Activated! Your Spirit Mask saved your life!", 60),
        PHOENIX("Your Phoenix Pet saved you from certain death!", 80);

        public final String regex;
        public final int durationTick;

        private Type(String regex, int durationTick) {
            this.regex = regex;
            this.durationTick = durationTick;
        }
    }
}

