/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.skyblock.dungeon.m7dragons;

import dev.nymnux.rhizome.config.CfgM7Dragons;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.SimpleEvents;
import dev.nymnux.rhizome.module.modules.skyblock.dungeon.m7dragons.Dragon;
import dev.nymnux.rhizome.util.math.MathUtil;
import dev.nymnux.rhizome.util.mixin.IMixinEntity;
import dev.nymnux.rhizome.util.render.WorldRenderUtil;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1297;
import net.minecraft.class_1510;
import net.minecraft.class_1531;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2675;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_6373;
import org.joml.Matrix3x2fStack;

public class M7Dragons
implements ModModule {
    private static final String FIGHT_PHASE_PREFIX = "[BOSS] Wither King: ";
    private static final List<String> END_PHASE = List.of("[BOSS] Wither King: Thank you for coming all the way here.", "[BOSS] Wither King: Now I will truly have peace.", "[BOSS] Wither King: Let\u2019s enjoy your final moments in silence.", "[BOSS] Wither King: Let's enjoy your final moments in silence.", "[BOSS] Wither King: Incredible. You did what I couldn't do myself.", "[BOSS] Wither King: In a way I should thank you, I lost all hopes centuries ago that it would ever end.", "[BOSS] Wither King: I hope you\u2019ll become the Heroes I could never be.", "[BOSS] Wither King: I hope you'll become the Heroes I could never be.", "[BOSS] Wither King: So long champions of this mad world!", "[BOSS] Wither King: My strengths are depleting, this\u2026 this is it\u2026", "[NPC] Mort: Here, I found this map when I first entered the dungeon.");
    private static final Pattern DRAGON_HEALTH_PATTERN = Pattern.compile("\ufd3e (?:.+ )?Withered Dragon (?:\\u16E4 )?(?<health>[\\dkKMB.]+)/(?<max>[\\dkKMB.]+)\\u2764 \ufd3f");
    private static final Pattern HEALTH_PATTERN = Pattern.compile("(\\d+(\\.\\d+)?)[KMB]?", 2);
    private static final List<Dragon> ARCHER_PRIORITY = List.of(Dragon.values());
    private static final int TIMER_DURATION_TICK = 100;
    private static final int SPLIT_TRIGGER_THRESHOLD_TICK = 30;
    private static final int NOTIFICATION_DURATION_TICK = 60;
    private static final int TIMER_COOLDOWN_TICK = 60;
    private static final double SPAWN_PARTICLE_POS_EPSILON = 0.0625;
    private static final int[] dragonSpawnTimers = new int[5];
    private static boolean inM7Dragons = false;
    private static boolean firstTwoDragonsSpawned = false;
    private static int splitTriggerTimer = -1;
    private static int notificationTimer = -1;
    private static Dragon currentDragon = null;
    private static Dragon archerDragon = null;
    private static Dragon mageDragon = null;

    @Override
    public void onClientTickStart(ClientContext ctx) {
        if (!inM7Dragons) {
            return;
        }
        if (splitTriggerTimer == 0) {
            currentDragon = null;
        }
        if (splitTriggerTimer >= 0) {
            --splitTriggerTimer;
        }
        if (notificationTimer >= 0) {
            --notificationTimer;
        }
    }

    private void onServerTick(ClientContext ctx, class_6373 packet) {
        if (!inM7Dragons) {
            return;
        }
        for (int i = 0; i < dragonSpawnTimers.length; ++i) {
            if (dragonSpawnTimers[i] <= -60) continue;
            int n = i;
            dragonSpawnTimers[n] = dragonSpawnTimers[n] - 1;
        }
    }

    private void onDragonSpawn(ClientContext ctx, Dragon dragon) {
        if (!firstTwoDragonsSpawned && currentDragon != null && splitTriggerTimer >= 0 && currentDragon != dragon) {
            int indexCurrentDragon = ARCHER_PRIORITY.indexOf((Object)currentDragon);
            int indexNewDragon = ARCHER_PRIORITY.indexOf((Object)dragon);
            int lowIndex = Math.min(indexCurrentDragon, indexNewDragon);
            int highIndex = Math.max(indexCurrentDragon, indexNewDragon);
            archerDragon = ARCHER_PRIORITY.get(lowIndex);
            mageDragon = ARCHER_PRIORITY.get(highIndex);
            currentDragon = null;
            splitTriggerTimer = -1;
            firstTwoDragonsSpawned = true;
        } else if (currentDragon == null || firstTwoDragonsSpawned) {
            currentDragon = dragon;
            archerDragon = null;
            mageDragon = null;
            splitTriggerTimer = 30;
        }
        notificationTimer = 60;
        ctx.player.method_43077((class_3414)class_3417.field_14622.comp_349());
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        if (!inM7Dragons || notificationTimer < 0) {
            return;
        }
        if (currentDragon != null) {
            M7Dragons.renderOneDragonNotification(ctx, drawContext, currentDragon);
        } else if (archerDragon != null && mageDragon != null) {
            M7Dragons.renderTwoDragonNotification(ctx, drawContext, archerDragon, mageDragon);
        }
    }

    public static void renderOneDragonNotification(ClientContext ctx, class_332 drawContext, Dragon dragon) {
        CfgM7Dragons config2 = ModConfig.getInstance().cfgM7Dragons;
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        float resizedGuiScale = 1.0f / ClientContext.getScaleFactor(ctx);
        double screenWidth = ctx.client.method_22683().method_4489();
        double screenHeight = ctx.client.method_22683().method_4506();
        matrixStack.pushMatrix();
        matrixStack.scale(resizedGuiScale, resizedGuiScale);
        matrixStack.translate((float)(screenWidth * 0.5), (float)(screenHeight * config2.yDragonPercent));
        matrixStack.scale((float)config2.scaleHud);
        drawContext.method_25300(ctx.client.field_1772, dragon.name, 0, 0, dragon.color);
        matrixStack.popMatrix();
    }

    public static void renderTwoDragonNotification(ClientContext ctx, class_332 drawContext, Dragon archerDragon, Dragon mageDragon) {
        CfgM7Dragons config2 = ModConfig.getInstance().cfgM7Dragons;
        float scale = (float)config2.scaleHud;
        double labelX = config2.xPercent;
        double labelY = config2.yIconPercent;
        double dragonX = labelX;
        double dragonY = config2.yDragonPercent;
        Matrix3x2fStack matrixStack = drawContext.method_51448();
        float resizedGuiScale = 1.0f / ClientContext.getScaleFactor(ctx);
        double screenWidth = ctx.client.method_22683().method_4489();
        double screenHeight = ctx.client.method_22683().method_4506();
        matrixStack.pushMatrix();
        matrixStack.scale(resizedGuiScale, resizedGuiScale);
        matrixStack.pushMatrix();
        matrixStack.translate((float)(screenWidth * labelX), (float)(screenHeight * labelY));
        matrixStack.scale(scale);
        drawContext.method_25300(ctx.client.field_1772, "\u27b9", 0, 0, -1);
        matrixStack.popMatrix();
        matrixStack.pushMatrix();
        matrixStack.translate((float)(screenWidth * (1.0 - labelX)), (float)(screenHeight * labelY));
        matrixStack.scale(scale);
        drawContext.method_25300(ctx.client.field_1772, "\u2604", 0, 0, -1);
        matrixStack.popMatrix();
        matrixStack.pushMatrix();
        matrixStack.translate((float)(screenWidth * dragonX), (float)(screenHeight * dragonY));
        matrixStack.scale(scale);
        drawContext.method_25300(ctx.client.field_1772, archerDragon.name, 0, 0, archerDragon.color);
        matrixStack.popMatrix();
        matrixStack.pushMatrix();
        matrixStack.translate((float)(screenWidth * (1.0 - dragonX)), (float)(screenHeight * dragonY));
        matrixStack.scale(scale);
        drawContext.method_25300(ctx.client.field_1772, mageDragon.name, 0, 0, mageDragon.color);
        matrixStack.popMatrix();
        matrixStack.popMatrix();
    }

    @Override
    public void onWorldRender(ClientContext ctx, WorldRenderContext renderContext) {
        if (!inM7Dragons) {
            return;
        }
        this.renderDragonBoxes(ctx, renderContext);
        this.renderDragonSpawnTimers(ctx, renderContext);
        this.renderDragonHealth(ctx, renderContext);
    }

    private void renderDragonHealth(ClientContext ctx, WorldRenderContext renderContext) {
        CfgM7Dragons config2 = ModConfig.getInstance().cfgM7Dragons;
        for (class_1297 entity : ctx.world.method_18112()) {
            String name;
            Matcher matcher;
            class_2561 text;
            class_1531 armorStand;
            if (!(entity instanceof class_1531) || !(armorStand = (class_1531)entity).method_16914() || (text = armorStand.method_5797()) == null || !(matcher = DRAGON_HEALTH_PATTERN.matcher(name = text.getString())).find()) continue;
            String healthStr = matcher.group("health");
            String maxHealthStr = matcher.group("max");
            double health = M7Dragons.parseHealth(healthStr);
            double maxHealth = M7Dragons.parseHealth(maxHealthStr);
            int color2 = Color.HSBtoRGB((float)(health / maxHealth / 3.0), 0.8f, 1.0f);
            class_243 pos = armorStand.method_30950(renderContext.tickCounter().method_60637(false));
            class_5250 healthText = class_2561.method_43470((String)healthStr.toUpperCase()).method_54663(color2);
            WorldRenderUtil.renderText(ctx, renderContext, pos, (class_2561)healthText, config2.scaleHp, color2, true, true, true);
        }
    }

    private void renderDragonBoxes(ClientContext ctx, WorldRenderContext renderContext) {
        for (Dragon dragon : Dragon.values()) {
            WorldRenderUtil.renderBox(ctx, renderContext, dragon.statueBox, dragon.color);
        }
    }

    private void renderDragonSpawnTimers(ClientContext ctx, WorldRenderContext renderContext) {
        CfgM7Dragons config2 = ModConfig.getInstance().cfgM7Dragons;
        for (int i = 0; i < 5; ++i) {
            if (dragonSpawnTimers[i] <= 0) continue;
            double countDown = (double)dragonSpawnTimers[i] * 0.05;
            Dragon dragon = Dragon.values()[i];
            class_5250 text = class_2561.method_43470((String)(MathUtil.DF_2_0.format(countDown) + " s"));
            WorldRenderUtil.renderText(ctx, renderContext, dragon.timerAndShootPos, (class_2561)text, config2.scaleTimer, dragon.color, true, true, true);
        }
    }

    private void onParticle(ClientContext ctx, class_2675 packet) {
        if (!inM7Dragons) {
            return;
        }
        if (!packet.method_11551().method_10295().equals(class_2398.field_11215)) {
            return;
        }
        for (int i = 0; i < Dragon.values().length; ++i) {
            class_243 particlePos = new class_243(packet.method_11544(), packet.method_11547(), packet.method_11546());
            if (Dragon.values()[i].spawnParticlePos.method_1022(particlePos) > 0.0625 || dragonSpawnTimers[i] > -60) continue;
            M7Dragons.dragonSpawnTimers[i] = 100;
            this.onDragonSpawn(ctx, Dragon.values()[i]);
        }
    }

    private void onEntitySpawn(ClientContext ctx, class_1297 entity) {
        if (!inM7Dragons) {
            return;
        }
        if (entity instanceof class_1510) {
            class_1510 dragonEntity = (class_1510)entity;
            ((IMixinEntity)dragonEntity).rhizome$setCustomGlowColor(-1);
        }
    }

    private void onChatTrigger(ClientContext ctx, class_2561 raw, String message2) {
        if (!inM7Dragons && message2.contains(FIGHT_PHASE_PREFIX)) {
            inM7Dragons = true;
        }
        if (!inM7Dragons) {
            return;
        }
        for (String s : END_PHASE) {
            if (!message2.contains(s)) continue;
            this.reset();
            return;
        }
    }

    @Override
    public void onClientWorldJoinEnd(ClientContext ctx) {
        this.reset();
    }

    private void reset() {
        inM7Dragons = false;
        Arrays.fill(dragonSpawnTimers, -60);
        firstTwoDragonsSpawned = false;
        splitTriggerTimer = -1;
        notificationTimer = -1;
        currentDragon = null;
        archerDragon = null;
        mageDragon = null;
    }

    private static double parseHealth(String healthStr) {
        Matcher matcher = HEALTH_PATTERN.matcher(healthStr);
        if (!matcher.matches()) {
            return 1.0;
        }
        String numberPart = matcher.group(1);
        String unit = healthStr.substring(numberPart.length()).toUpperCase();
        double value = Double.parseDouble(numberPart);
        switch (unit) {
            case "K": {
                value *= 1000.0;
                break;
            }
            case "M": {
                value *= 1000000.0;
                break;
            }
            case "B": {
                value *= 1.0E9;
            }
        }
        return Math.max(1.0, value);
    }

    public M7Dragons() {
        SimpleEvents.PARTICLE.register(this::onParticle);
        SimpleEvents.CHAT_TRIGGER.register(this::onChatTrigger);
        SimpleEvents.SERVER_TICK.register(this::onServerTick);
        SimpleEvents.ENTITY_SPAWN.register(this::onEntitySpawn);
    }
}

