/*
 * Decompiled with CFR 0.152.
 */
package dev.nymnux.rhizome.module.modules.skyblock.fishing;

import dev.nymnux.rhizome.config.CfgFishingTimer;
import dev.nymnux.rhizome.config.ModConfig;
import dev.nymnux.rhizome.module.ModModule;
import dev.nymnux.rhizome.module.RhiModules;
import dev.nymnux.rhizome.module.event.ClientContext;
import dev.nymnux.rhizome.module.event.EventClock;
import dev.nymnux.rhizome.sound.ModSounds;
import dev.nymnux.rhizome.util.render.HudRenderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.joml.Vector2d;

public class FishingTimer
implements ModModule {
    private static final EventClock ALARM = new EventClock(RhiModules.FISHING_TIMER, 4, 4, ctx -> ctx.player.method_43077((class_3414)class_3417.field_14622.comp_349()));
    private static final Pattern TIMER_PATTERN = Pattern.compile("^[0-9]\\.[0-9]$");
    private static final String BITE_PATTERN = "!!!";
    private static final class_2960 TEXTURE = class_2960.method_60655((String)"rhizome", (String)"textures/skyblock/fishing_timer_bar.png");
    private static final int TEXTURE_UNIT_WIDTH = 128;
    private static final int TEXTURE_UNIT_HEIGHT = 32;
    private static final int TEXTURE_GRID_HEIGHT = 33;
    private static final int TEXTURE_GRID_COUNT = 12;
    private static final int TEXTURE_WIDTH = 128;
    private static final int TEXTURE_HEIGHT = 395;
    private static int currTimer = -1;
    private static int prevTimer = -1;
    private static boolean casted = false;

    @Override
    public void onClientTickStart(ClientContext ctx) {
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        if (!config2.showTimerBar && !config2.enableSoundEffect) {
            this.reset();
            return;
        }
        class_1799 itemStack = ctx.player.method_6047();
        if (itemStack.method_7960() || !itemStack.method_31574(class_1802.field_8378)) {
            this.reset();
            return;
        }
        List<Integer> result = FishingTimer.getTimerFromArmorStand(ctx);
        if (result.size() > 1) {
            this.onStrangeThing();
            this.reset();
        } else if (result.size() == 1) {
            currTimer = result.getFirst();
            if (config2.enableSoundEffect) {
                this.onSoundEffect(ctx, (float)config2.volume);
            }
        } else {
            this.reset();
        }
    }

    private void onSoundEffect(ClientContext ctx, float volume) {
        if (currTimer == prevTimer) {
            return;
        }
        if (!casted && currTimer > 10) {
            casted = true;
            ctx.world.method_67392(ModSounds.FISHING_TIMER_BAR[11], class_3419.field_15250, volume, 1.0f);
        } else if (currTimer >= 0 && currTimer <= 10) {
            ctx.world.method_67392(ModSounds.FISHING_TIMER_BAR[currTimer], class_3419.field_15250, volume, 1.0f);
        }
    }

    @Override
    public void onHudRender(ClientContext ctx, class_332 drawContext, float tickDelta) {
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        if (!config2.showTimerBar || currTimer < 0 || currTimer > 40) {
            return;
        }
        int timer = Math.min(currTimer, 11);
        int u = 0;
        int v = 33 * (11 - timer);
        HudRenderUtil.drawTexture(ctx, drawContext, TEXTURE, new Vector2d(config2.xPercent, config2.yPercent), u, v, 128, 32, 128, 395, config2.scale, true, true, config2.mirror, false, -1);
    }

    @Override
    public void onClientTickEnd(ClientContext ctx) {
        if (currTimer != -1) {
            prevTimer = currTimer;
        }
    }

    private void onStrangeThing() {
        if (RhiModules.SCHEDULER.hasEventClockStart(ALARM)) {
            return;
        }
        ALARM.reset();
        RhiModules.SCHEDULER.addEventClockStart(ALARM);
    }

    private void reset() {
        currTimer = -1;
        prevTimer = -1;
        casted = false;
    }

    private static List<Integer> getTimerFromArmorStand(ClientContext ctx) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        CfgFishingTimer config2 = ModConfig.getInstance().cfgFishingTimer;
        for (class_1297 entity : ctx.world.method_18112()) {
            class_243 labelPos;
            class_1531 armorStand;
            class_2561 name;
            if (!(entity instanceof class_1531) || (name = (armorStand = (class_1531)entity).method_5797()) == null || !armorStand.method_5807() || !HudRenderUtil.canSeeOnScreen(ctx, labelPos = armorStand.method_19538().method_1031(0.0, config2.armorStandOffsetY, 0.0), 0.0f)) continue;
            if (TIMER_PATTERN.matcher(name.getString()).matches()) {
                int timer = (int)(Double.parseDouble(name.getString()) * 10.0);
                if (timer < 1 || timer > 40) continue;
                result.add(timer);
                continue;
            }
            if (!name.getString().equals(BITE_PATTERN)) continue;
            result.add(0);
        }
        return result;
    }

    public static class_2960 getDemoTexture() {
        return TEXTURE;
    }

    public static int getDemoTextureUnitWidth() {
        return 128;
    }

    public static int getDemoTextureUnitHeight() {
        return 32;
    }

    public static int getDemoTextureU() {
        return 0;
    }

    public static int getDemoTextureV() {
        return 165;
    }

    public static int getDemoTextureWidth() {
        return 128;
    }

    public static int getDemoTextureHeight() {
        return 395;
    }
}

